/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.diagram.ui.notation.uml;

import org.eclipse.draw2d.Figure;
import org.eclipse.swt.graphics.Image;
import org.teiid.designer.diagram.ui.DiagramUiPlugin;
import org.teiid.designer.diagram.ui.IDiagramType;
import org.teiid.designer.diagram.ui.figure.AbstractDiagramFigure;
import org.teiid.designer.diagram.ui.figure.DiagramFigure;
import org.teiid.designer.diagram.ui.model.AbstractDiagramModelNode;
import org.teiid.designer.diagram.ui.model.DiagramModelNode;
import org.teiid.designer.diagram.ui.notation.NotationFigureGenerator;
import org.teiid.designer.diagram.ui.notation.uml.figure.UmlAssociationFigure;
import org.teiid.designer.diagram.ui.notation.uml.figure.UmlAttributeFigure;
import org.teiid.designer.diagram.ui.notation.uml.figure.UmlClassifierContainerFigure;
import org.teiid.designer.diagram.ui.notation.uml.figure.UmlClassifierFigure;
import org.teiid.designer.diagram.ui.notation.uml.figure.UmlOperationFigure;
import org.teiid.designer.diagram.ui.notation.uml.figure.UmlPackageFigure;
import org.teiid.designer.diagram.ui.notation.uml.model.UmlAssociationNode;
import org.teiid.designer.diagram.ui.notation.uml.model.UmlAttributeNode;
import org.teiid.designer.diagram.ui.notation.uml.model.UmlClassifierContainerNode;
import org.teiid.designer.diagram.ui.notation.uml.model.UmlClassifierNode;
import org.teiid.designer.diagram.ui.notation.uml.model.UmlModelNode;
import org.teiid.designer.diagram.ui.notation.uml.model.UmlOperationNode;
import org.teiid.designer.diagram.ui.notation.uml.model.UmlPackageNode;
import org.teiid.designer.diagram.ui.util.colors.ColorPalette;
import org.teiid.designer.diagram.ui.util.colors.ColorPaletteManager;
import org.teiid.designer.metamodels.diagram.Diagram;
import org.teiid.designer.ui.viewsupport.ModelUtilities;

public class UmlFigureGenerator
implements NotationFigureGenerator {
    private static final int UML_CLASS = 1;
    private static final int UML_PACKAGE = 2;
    private static final int UML_CLASS_CONTAINER = 3;
    private static final int UML_ATTRIBUTE = 4;
    private static final int UML_ASSOCIATION = 5;
    private static final int UML_OPERATION = 6;
    private static final int UML_CLASS_IN_CLASS = 7;

    @Override
    public Figure createFigure(Object modelObject) {
        DiagramModelNode node;
        int objectType = this.getObjectType(modelObject);
        AbstractDiagramFigure newFigure = null;
        ColorPalette colorPalette = null;
        switch (objectType) {
            case 2: {
                node = (UmlPackageNode)modelObject;
                String nodeName = ((UmlPackageNode)node).getName();
                Image icon = null;
                if (((AbstractDiagramModelNode)node).getModelObject() != null) {
                    colorPalette = this.getColorPalette(node);
                    icon = this.getImage(node);
                }
                if (nodeName == null || nodeName.equalsIgnoreCase("null")) {
                    nodeName = "UnknownPackage";
                }
                String path = ((UmlPackageNode)node).getPath();
                if (((AbstractDiagramModelNode)node).hideLocation()) {
                    path = null;
                }
                newFigure = new UmlPackageFigure(((UmlModelNode)node).getStereotype(), nodeName, path, icon, colorPalette);
                break;
            }
            case 7: {
                node = (UmlClassifierNode)modelObject;
                Image icon = null;
                if (((AbstractDiagramModelNode)node).getModelObject() != null) {
                    colorPalette = this.getColorPalette(node);
                    icon = this.getImage(node);
                }
                newFigure = new UmlClassifierFigure(node, ((UmlModelNode)node).getStereotype(), ((UmlClassifierNode)node).getName(), null, icon, colorPalette);
                break;
            }
            case 1: {
                node = (UmlClassifierNode)modelObject;
                Image icon = null;
                if (((AbstractDiagramModelNode)node).getModelObject() != null) {
                    colorPalette = this.getColorPalette(node);
                    icon = this.getImage(node);
                }
                String path = ((UmlClassifierNode)node).getPath();
                if (((AbstractDiagramModelNode)node).hideLocation()) {
                    path = null;
                }
                newFigure = new UmlClassifierFigure(node, ((UmlModelNode)node).getStereotype(), ((UmlClassifierNode)node).getName(), path, icon, colorPalette);
                break;
            }
            case 3: {
                node = (DiagramModelNode)modelObject;
                colorPalette = this.getColorPalette(node);
                newFigure = new UmlClassifierContainerFigure(node, colorPalette);
                break;
            }
            case 4: {
                node = (UmlAttributeNode)modelObject;
                String signature = ((UmlAttributeNode)node).getSignature();
                Image icon = null;
                if (((AbstractDiagramModelNode)node).getModelObject() != null) {
                    colorPalette = this.getColorPalette(node);
                    icon = this.getImage(node);
                }
                UmlAttributeFigure figure = new UmlAttributeFigure(signature, icon, colorPalette);
                figure.updateForType((UmlAttributeNode)node);
                newFigure = figure;
                break;
            }
            case 5: {
                node = (UmlAssociationNode)modelObject;
                String signature = ((UmlAssociationNode)node).getSignature();
                Image icon = null;
                if (((AbstractDiagramModelNode)node).getModelObject() != null) {
                    colorPalette = this.getColorPalette(node);
                    icon = this.getImage(node);
                }
                newFigure = new UmlAssociationFigure(signature, icon, colorPalette);
                break;
            }
            case 6: {
                node = (UmlOperationNode)modelObject;
                String signature = ((UmlOperationNode)node).getSignature();
                Image icon = null;
                if (((AbstractDiagramModelNode)node).getModelObject() != null) {
                    colorPalette = this.getColorPalette(node);
                    icon = this.getImage(node);
                }
                newFigure = new UmlOperationFigure(signature, icon, colorPalette);
            }
        }
        if (newFigure != null && modelObject instanceof DiagramModelNode) {
            node = (DiagramModelNode)modelObject;
            ((DiagramFigure)newFigure).setDiagramModelNode(node);
            if (node.hasErrors()) {
                ((DiagramFigure)newFigure).updateForError(true);
            } else if (node.hasWarnings()) {
                ((DiagramFigure)newFigure).updateForWarning(true);
            }
        }
        return newFigure;
    }

    protected int getObjectType(Object modelObject) {
        int objectType = -1;
        if (modelObject != null) {
            if (modelObject instanceof UmlPackageNode) {
                objectType = 2;
            } else if (modelObject instanceof UmlClassifierNode) {
                objectType = ((DiagramModelNode)modelObject).getParent() instanceof UmlClassifierContainerNode ? 7 : 1;
            } else if (modelObject instanceof UmlClassifierContainerNode) {
                objectType = 3;
            } else if (modelObject instanceof UmlAttributeNode) {
                objectType = 4;
            } else if (modelObject instanceof UmlAssociationNode) {
                objectType = 5;
            } else if (modelObject instanceof UmlOperationNode) {
                objectType = 6;
            }
        }
        return objectType;
    }

    public ColorPaletteManager getColorPaletteManager(DiagramModelNode modelObject) {
        IDiagramType diagram;
        int objectType = this.getObjectType(modelObject);
        ColorPaletteManager cpm = null;
        String diagramType = null;
        DiagramModelNode dmn = null;
        if (objectType == 2 || objectType == 1) {
            dmn = modelObject.getParent();
        } else if (objectType == 3) {
            DiagramModelNode classNode = modelObject.getParent();
            dmn = classNode.getParent();
        } else if (objectType == 4 || objectType == 5 || objectType == 6) {
            DiagramModelNode parentClassNode = modelObject.getParent().getParent();
            if (this.getObjectType(parentClassNode) == 7) {
                return this.getColorPaletteManager(parentClassNode);
            }
            DiagramModelNode classContainerNode = modelObject.getParent();
            dmn = classContainerNode.getParent().getParent();
        } else if (objectType == 7) {
            DiagramModelNode classContainerNode = modelObject.getParent();
            DiagramModelNode parentClassNode = classContainerNode.getParent();
            return this.getColorPaletteManager(parentClassNode);
        }
        if (dmn != null && (diagramType = ((Diagram)dmn.getModelObject()).getType()) != null && (diagram = DiagramUiPlugin.getDiagramTypeManager().getDiagram(diagramType)) != null) {
            cpm = diagram.getColorPaletteManager();
        }
        return cpm;
    }

    private Image getImage(DiagramModelNode node) {
        Image icon = null;
        if (node instanceof UmlModelNode) {
            icon = ModelUtilities.getModelObjectLabelProvider().getImage((Object)node.getModelObject());
        }
        if (icon == null) {
            icon = DiagramUiPlugin.getDiagramNotationManager().getLabelProvider().getImage((Object)node.getModelObject());
        }
        return icon;
    }

    private ColorPalette getColorPalette(DiagramModelNode inputNode) {
        int objectType = this.getObjectType(inputNode);
        DiagramModelNode dmn = inputNode;
        if (objectType == 3) {
            dmn = inputNode.getParent();
        }
        return this.getColorPaletteManager(dmn).getColorPalette(dmn.getModelObject());
    }
}

