/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.diagram.ui.model;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.swt.graphics.Image;
import org.teiid.designer.diagram.ui.DiagramUiConstants;
import org.teiid.designer.diagram.ui.connection.NodeConnectionModel;
import org.teiid.designer.diagram.ui.model.DiagramModelNode;
import org.teiid.designer.diagram.ui.util.DiagramEntityManager;
import org.teiid.designer.diagram.ui.util.DiagramUiUtilities;
import org.teiid.designer.metamodels.diagram.Diagram;
import org.teiid.designer.metamodels.diagram.DiagramEntity;
import org.teiid.designer.ui.viewsupport.ModelObjectUtilities;

public abstract class AbstractLocalDiagramModelNode
implements DiagramModelNode,
DiagramUiConstants {
    private Vector m_sourceConnections = new Vector();
    private Vector m_targetConnections = new Vector();
    private EObject modelObject;
    private List children = null;
    private DiagramModelNode parent;
    private Image firstOverlayImage;
    private Image secondOverlayImage;
    private String editorID;
    protected Diagram diagram;
    private boolean readOnly = false;
    private boolean errorState = false;
    private boolean warningState = false;
    private int x;
    private int y;
    protected int width;
    protected int height;
    private String name;
    private boolean heightFixed = false;
    private int fixedHeight = 200;
    protected transient PropertyChangeSupport listeners = new PropertyChangeSupport(this);

    public AbstractLocalDiagramModelNode(EObject modelObject, String name) {
        this.modelObject = modelObject;
        this.setName(name);
    }

    @Override
    public void setModelObject(EObject object) {
        this.modelObject = object;
        this.setReadOnly(DiagramUiUtilities.getReadOnlyState(object));
    }

    @Override
    public void setDiagramModelObject(DiagramEntity object) {
    }

    @Override
    public EObject getModelObject() {
        return this.modelObject;
    }

    @Override
    public DiagramEntity getDiagramModelObject() {
        return null;
    }

    @Override
    public void addChild(DiagramModelNode child) {
        if (this.children == null) {
            this.children = new ArrayList();
        }
        child.setParent(this);
        this.children.add(child);
        this.fireStructureChange("children", child);
    }

    @Override
    public void addChildren(List newChildren) {
        if (newChildren != null && !newChildren.isEmpty()) {
            if (this.children == null) {
                this.children = new ArrayList();
            }
            for (Object nextChild : newChildren) {
                if (nextChild instanceof DiagramModelNode) {
                    ((DiagramModelNode)nextChild).setParent(this);
                }
                this.children.add(nextChild);
            }
            this.fireStructureChange("children", this);
        }
    }

    @Override
    public void removeChild(DiagramModelNode child, boolean deleteDiagramEntity) {
        if (this.children == null) {
            return;
        }
        Diagram diagram = child.getDiagram();
        DiagramEntity staleDE = child.getDiagramModelObject();
        if (staleDE != null) {
            DiagramEntityManager.removeEntity(diagram, child.getModelObject());
        }
        this.children.remove(child);
        if (deleteDiagramEntity && staleDE != null && !ModelObjectUtilities.isReadOnly((EObject)this.getModelObject())) {
            DiagramEntityManager.cleanUpDiagram(diagram);
            DiagramEntityManager.cleanDiagramEntities(diagram);
        }
        this.fireStructureChange("children", child);
    }

    @Override
    public void removeChildren(List oldChildren, boolean deleteDiagramEntities) {
        if (oldChildren != null && !oldChildren.isEmpty()) {
            if (this.children == null) {
                return;
            }
            Diagram diagram = null;
            DiagramModelNode nextChild = null;
            Iterator iter = oldChildren.iterator();
            ArrayList<DiagramEntity> removeList = new ArrayList<DiagramEntity>(oldChildren.size());
            while (iter.hasNext()) {
                nextChild = (DiagramModelNode)iter.next();
                DiagramEntity staleDE = nextChild.getDiagramModelObject();
                if (diagram == null) {
                    diagram = nextChild.getDiagram();
                }
                if (staleDE != null) {
                    DiagramEntityManager.removeEntity(diagram, nextChild.getModelObject());
                }
                this.children.remove(nextChild);
                if (!deleteDiagramEntities || staleDE == null) continue;
                removeList.add(staleDE);
            }
            if (deleteDiagramEntities && !removeList.isEmpty()) {
                DiagramEntityManager.cleanDiagramEntities(diagram);
                DiagramUiUtilities.deleteDiagramEntities(removeList, this);
            }
            this.fireStructureChange("children", this);
        }
    }

    @Override
    public void updateForChild(boolean isMove) {
        this.fireStructureChange("children", "EMPTY");
    }

    @Override
    public void setChildren(List childList) {
        this.children = childList;
    }

    @Override
    public List getChildren() {
        if (this.children == null || this.children.isEmpty()) {
            return Collections.EMPTY_LIST;
        }
        return this.children;
    }

    public int getNumberOfChildren() {
        if (this.children == null || this.children.isEmpty()) {
            return 0;
        }
        return this.children.size();
    }

    @Override
    public void setParent(DiagramModelNode parent) {
        this.parent = parent;
    }

    @Override
    public DiagramModelNode getParent() {
        return this.parent;
    }

    @Override
    public void setPosition(Point position) {
        this.x = position.x;
        this.y = position.y;
        this.firePropertyChange("location", null, position);
    }

    @Override
    public void setCenterXY(int newCenterX, int newCenterY) {
        int newX = newCenterX - this.getWidth() / 2;
        int newY = newCenterY - this.getHeight() / 2;
        this.x = newX;
        this.y = newY;
        this.firePropertyChange("location", null, new Point(newX, newY));
    }

    @Override
    public void setCenterX(int newCenterX) {
        int newX;
        this.x = newX = newCenterX - this.getWidth() / 2;
        this.firePropertyChange("location", null, new Point(newX, this.y));
    }

    @Override
    public void setCenterY(int newCenterY) {
        int newY;
        this.y = newY = newCenterY - this.getHeight() / 2;
        this.firePropertyChange("location", null, new Point(this.x, newY));
    }

    @Override
    public Point getPosition() {
        Point posn = new Point(this.x, this.y);
        return posn;
    }

    @Override
    public void setSize(Dimension dimension) {
        this.width = dimension.width;
        this.height = dimension.height;
        this.firePropertyChange("size", null, dimension);
    }

    @Override
    public Dimension getSize() {
        Dimension size = new Dimension(this.width, this.height);
        return size;
    }

    @Override
    public void addPropertyChangeListener(PropertyChangeListener l) {
        this.listeners.addPropertyChangeListener(l);
    }

    @Override
    public void firePropertyChange(String prop, Object old, Object newValue) {
        this.listeners.firePropertyChange(prop, old, newValue);
    }

    protected void fireStructureChange(String prop, Object child) {
        this.listeners.firePropertyChange(prop, null, child);
    }

    public Object getEditableValue() {
        return this;
    }

    @Override
    public void removePropertyChangeListener(PropertyChangeListener l) {
        this.listeners.removePropertyChangeListener(l);
    }

    @Override
    public void update() {
        this.firePropertyChange("prop", null, null);
    }

    @Override
    public void update(String property) {
        this.firePropertyChange(property, null, null);
    }

    @Override
    public void update(String prop, String oldValue, String newValue) {
        this.firePropertyChange(prop, oldValue, newValue);
    }

    @Override
    public void setName(String name) {
        this.name = name;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getDisplayString() {
        return this.getName();
    }

    public String getPath() {
        return "Path";
    }

    public int getXPosition() {
        return this.x;
    }

    public int getYPosition() {
        return this.y;
    }

    @Override
    public int getX() {
        return this.x;
    }

    @Override
    public int getY() {
        return this.y;
    }

    @Override
    public int getCenterX() {
        return this.x + this.width / 2;
    }

    @Override
    public int getCenterY() {
        return this.y + this.height / 2;
    }

    @Override
    public int getWidth() {
        return this.width;
    }

    @Override
    public int getHeight() {
        return this.height;
    }

    public String toString() {
        StringBuffer result = new StringBuffer(super.toString());
        result.append(" (name: ");
        result.append(this.getName());
        result.append(", path: ");
        result.append(this.getPath());
        result.append(", xPosition: ");
        result.append(this.getXPosition());
        result.append(", yPosition: ");
        result.append(this.getYPosition());
        result.append(", height: ");
        result.append(this.getHeight());
        result.append(", width: ");
        result.append(this.getWidth());
        result.append(')');
        return result.toString();
    }

    @Override
    public Vector getSourceConnections() {
        return this.m_sourceConnections;
    }

    @Override
    public Vector getTargetConnections() {
        return this.m_targetConnections;
    }

    @Override
    public void addSourceConnection(NodeConnectionModel iConnection) {
        this.m_sourceConnections.addElement(iConnection);
    }

    @Override
    public void addTargetConnection(NodeConnectionModel iConnection) {
        this.m_targetConnections.addElement(iConnection);
    }

    @Override
    public void removeSourceConnection(NodeConnectionModel iConnection) {
        this.m_sourceConnections.removeElement(iConnection);
    }

    @Override
    public void removeTargetConnection(NodeConnectionModel iConnection) {
        this.m_targetConnections.removeElement(iConnection);
    }

    @Override
    public List getAssociations(HashMap nodeMap) {
        return Collections.EMPTY_LIST;
    }

    @Override
    public void updateAssociations() {
    }

    @Override
    public boolean hasErrors() {
        return this.errorState;
    }

    @Override
    public boolean hasWarnings() {
        return this.warningState;
    }

    @Override
    public void recoverObjectProperties() {
    }

    @Override
    public boolean wasLayedOut() {
        return false;
    }

    @Override
    public List getDependencies() {
        return Collections.EMPTY_LIST;
    }

    @Override
    public Image getFirstOverlayImage() {
        return this.firstOverlayImage;
    }

    @Override
    public void setFirstOverlayImage(Image image, String editorID) {
        this.firstOverlayImage = image;
        this.editorID = editorID;
    }

    @Override
    public Image getSecondOverlayImage() {
        return this.secondOverlayImage;
    }

    @Override
    public void setSecondOverlayImage(Image image, int positionIndex) {
        this.secondOverlayImage = image;
    }

    @Override
    public void updateForErrorsAndWarnings() {
    }

    @Override
    public Diagram getDiagram() {
        return this.diagram;
    }

    @Override
    public boolean isReadOnly() {
        return this.readOnly;
    }

    @Override
    public void setReadOnly(boolean readOnly) {
        this.readOnly = readOnly;
    }

    @Override
    public boolean hideLocation() {
        return false;
    }

    @Override
    public void setHideLocation(boolean hideLocation) {
    }

    @Override
    public String getEditorID() {
        return this.editorID;
    }

    public void setEditorID(String editorID) {
        this.editorID = editorID;
    }

    @Override
    public int getFixedHeight() {
        return this.fixedHeight;
    }

    @Override
    public void setFixedHeight(int theFixedHeight) {
        this.fixedHeight = theFixedHeight;
    }

    @Override
    public boolean isHeightFixed() {
        return this.heightFixed;
    }

    @Override
    public void setHeightFixed(boolean theHeightFixed) {
        this.heightFixed = theHeightFixed;
        if (this.children != null && !this.children.isEmpty()) {
            for (DiagramModelNode nextChildNode : this.children) {
                nextChildNode.setHeightFixed(theHeightFixed);
            }
        }
    }
}

