/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.diagram.ui.layout;

import java.util.Hashtable;
import java.util.Iterator;
import java.util.Vector;
import org.teiid.designer.diagram.ui.connection.NodeConnectionModel;
import org.teiid.designer.diagram.ui.layout.DiagramLayout;
import org.teiid.designer.diagram.ui.model.DiagramModelNode;

public class MmTreeLayout
extends DiagramLayout {
    static final String CLASS_NAME = "MmTreeLayout";
    public static final int COMPACT_METHOD = 0;
    public static final int SEPARATE_METHOD = 1;
    public static final int LIST_ORDER = 0;
    public static final int POSITION_ORDER = 1;
    public static final int ORIENTATION_ROOT_LEFT = 0;
    public static final int ORIENTATION_ROOT_TOP = 1;
    public static final int ORIENTATION_ROOT_RIGHT = 2;
    public static final int ORIENTATION_ROOT_BOTTOM = 3;
    public static final int ERROR_TREE_HAS_NO_ROOT = 1;
    public static final int ERROR_ROOT_NOT_MANAGED = 2;
    public static final int ERROR_NOT_A_TREE = 3;
    private DiagramModelNode modelRoot = null;
    private int _depth = -1;
    private int _order = 1;
    private int _orientation = 0;
    private int _method = 0;
    private boolean _useObjectsSizes = false;
    private boolean _fixedSpacing = true;
    private double _fixedXSpacing = 500.0;
    private double _fixedYSpacing = 400.0;
    private transient Hashtable _compToNode = new Hashtable();
    private transient TreeNode[] rawTreeNodes = null;

    @Override
    protected int run() {
        if (this.getComponentCount() == 0) {
            return 0;
        }
        int i = this.buildTree();
        if (i != 0) {
            return i;
        }
        TreeNode treenode = (TreeNode)this._compToNode.get(this.modelRoot);
        if (treenode == null) {
            return 2;
        }
        TreeNode[] treenodes = new TreeNode[this._depth + 1];
        treenode.setNeighbors(treenodes);
        double d = 0.0;
        double d_85_ = 0.0;
        double d_86_ = 0.0;
        double d_87_ = 1.0;
        double d_88_ = 0.0;
        double[] ds = new double[this._depth + 1];
        if (this._method == 0) {
            double[] ds_89_ = new double[this._depth + 1];
            double[] ds_90_ = new double[this._depth + 1];
            treenode.calculatePosition(ds_89_, ds_90_);
            treenode.setEven();
            int i_91_ = 0;
            while (i_91_ <= this._depth) {
                d_86_ = Math.max(d_86_, ds_90_[i_91_]);
                ++i_91_;
            }
            if (this._useObjectsSizes) {
                treenode.getMaximumWidths(ds);
                int i_92_ = 0;
                while (i_92_ <= this._depth) {
                    d_88_ = ds[i_92_];
                    int n = i_92_;
                    ds[n] = ds[n] + (d - 0.5 * d_88_);
                    d += d_88_;
                    d_85_ = Math.max(d_85_, ds_89_[i_92_]);
                    ++i_92_;
                }
            }
        } else {
            double[] ds_93_ = new double[1];
            double[] ds_94_ = new double[1];
            treenode.calculateSeparatePosition(ds_93_, ds_94_);
            d_86_ = ds_94_[0];
            if (this._useObjectsSizes) {
                treenode.getMaximumWidths(ds);
                int i_95_ = 0;
                while (i_95_ <= this._depth) {
                    d_88_ = ds[i_95_];
                    int n = i_95_++;
                    ds[n] = ds[n] + (d - 0.5 * d_88_);
                    d += d_88_;
                }
                d_85_ = ds_93_[0];
            }
        }
        double d_96_ = 0.0;
        double d_97_ = 0.0;
        double d_98_ = this.getWidth();
        double d_99_ = this.getHeight();
        double d_100_ = this.getXOrigin();
        double d_101_ = this.getYOrigin();
        if (this._useObjectsSizes) {
            d_96_ = 1.0;
            d_97_ = 1.0;
        }
        if (this._orientation == 1 || this._orientation == 3) {
            d_88_ = d_98_;
            d_98_ = d_99_;
            d_99_ = d_88_;
            d_88_ = d_100_;
            d_100_ = d_101_;
            d_101_ = d_88_;
        }
        if (this._orientation == 2 || this._orientation == 3) {
            d_100_ += d_98_;
            d_101_ += d_99_;
            d_96_ = -d_96_;
            d_97_ = -d_97_;
            d_87_ = -1.0;
        }
        if (this._fixedSpacing) {
            if (this._orientation == 1 || this._orientation == 3) {
                d_98_ = d_87_ * this._fixedYSpacing;
                d_99_ = d_87_ * this._fixedXSpacing;
            } else {
                d_98_ = d_87_ * this._fixedXSpacing;
                d_99_ = d_87_ * this._fixedYSpacing;
            }
        } else {
            d_98_ = d_87_ * (d_98_ - d) / (double)(this._depth + 1);
            d_99_ = d_87_ * (d_99_ - d_85_) / d_86_;
        }
        d_100_ += 0.5 * d_98_;
        d_101_ -= 0.5 * d_99_;
        int i_102_ = 0;
        while (i_102_ <= this._depth) {
            ds[i_102_] = d_100_ + d_96_ * ds[i_102_] + d_98_ * (double)i_102_;
            ++i_102_;
        }
        DiagramModelNode[] modelNodes = this.getNodeArray();
        int i_103_ = modelNodes.length;
        if (this._orientation == 2 || this._orientation == 0) {
            int i_104_ = 0;
            while (i_104_ < i_103_) {
                DiagramModelNode modelNode = modelNodes[i_104_];
                treenode = this.rawTreeNodes[i_104_];
                if (treenode._level != -1) {
                    int newX = (int)ds[treenode._level];
                    int newY = (int)(treenode._absolutePosition * d_97_ + treenode._relativePosition * d_99_ + d_101_);
                    modelNode.setCenterXY(newX, newY);
                }
                ++i_104_;
            }
        } else {
            int i_105_ = 0;
            while (i_105_ < i_103_) {
                DiagramModelNode modelNode = modelNodes[i_105_];
                treenode = this.rawTreeNodes[i_105_];
                if (treenode._level != -1) {
                    int newX = (int)ds[treenode._level];
                    int newY = (int)(treenode._absolutePosition * d_97_ + treenode._relativePosition * d_99_ + d_101_);
                    modelNode.setCenterXY(newX, newY);
                }
                ++i_105_;
            }
        }
        return 0;
    }

    private int buildTree() {
        this._compToNode.clear();
        int i = this.getComponentCount();
        if (i == 0) {
            return 0;
        }
        DiagramModelNode[] modelNodes = this.getNodeArray();
        this.rawTreeNodes = new TreeNode[i];
        int iiNode = 0;
        while (iiNode < i) {
            DiagramModelNode modelNode = modelNodes[iiNode];
            this.rawTreeNodes[iiNode] = new TreeNode(modelNode);
            this._compToNode.put(modelNode, this.rawTreeNodes[iiNode]);
            ++iiNode;
        }
        if (this._order == 0) {
            int i_107_ = 0;
            while (i_107_ < i) {
                this.rawTreeNodes[i_107_]._orderVar = i_107_;
                ++i_107_;
            }
        } else if (this._orientation == 0) {
            int i_108_ = 0;
            while (i_108_ < i) {
                this.rawTreeNodes[i_108_]._orderVar = modelNodes[i_108_].getCenterY();
                ++i_108_;
            }
        } else if (this._orientation == 1) {
            int i_109_ = 0;
            while (i_109_ < i) {
                this.rawTreeNodes[i_109_]._orderVar = modelNodes[i_109_].getCenterX();
                ++i_109_;
            }
        } else if (this._orientation == 2) {
            int i_110_ = 0;
            while (i_110_ < i) {
                this.rawTreeNodes[i_110_]._orderVar = -modelNodes[i_110_].getCenterY();
                ++i_110_;
            }
        } else {
            int i_111_ = 0;
            while (i_111_ < i) {
                this.rawTreeNodes[i_111_]._orderVar = -modelNodes[i_111_].getCenterX();
                ++i_111_;
            }
        }
        if (this._orientation == 0 || this._orientation == 2) {
            int i_112_ = 0;
            while (i_112_ < i) {
                this.rawTreeNodes[i_112_]._width = modelNodes[i_112_].getWidth();
                this.rawTreeNodes[i_112_]._height = modelNodes[i_112_].getHeight();
                ++i_112_;
            }
        } else {
            int i_113_ = 0;
            while (i_113_ < i) {
                this.rawTreeNodes[i_113_]._width = modelNodes[i_113_].getHeight();
                this.rawTreeNodes[i_113_]._height = modelNodes[i_113_].getWidth();
                ++i_113_;
            }
        }
        iiNode = 0;
        while (iiNode < i) {
            DiagramModelNode sourceNode = modelNodes[iiNode];
            Vector sourceConnections = sourceNode.getSourceConnections();
            TreeNode sourceTreeNode = (TreeNode)this._compToNode.get(sourceNode);
            if (!sourceConnections.isEmpty()) {
                Iterator iter = sourceConnections.iterator();
                NodeConnectionModel nextConnection = null;
                while (iter.hasNext()) {
                    nextConnection = (NodeConnectionModel)iter.next();
                    TreeNode targetTreeNode = (TreeNode)this._compToNode.get(nextConnection.getTargetNode());
                    if (sourceTreeNode == null || targetTreeNode == null) continue;
                    sourceTreeNode.addLinkToNode(targetTreeNode);
                    targetTreeNode.addLinkToNode(sourceTreeNode);
                }
            }
            ++iiNode;
        }
        if (this.modelRoot == null) {
            return 1;
        }
        TreeNode treenode = (TreeNode)this._compToNode.get(this.modelRoot);
        if (treenode == null) {
            return 2;
        }
        this._depth = -1;
        try {
            this._depth = treenode.setParent(null);
        }
        catch (NotATreeException notATreeException) {
            return 3;
        }
        return 0;
    }

    public boolean getFixedSpacing() {
        return this._fixedSpacing;
    }

    public double getFixedXSpacing() {
        return this._fixedXSpacing;
    }

    public double getFixedYSpacing() {
        return this._fixedYSpacing;
    }

    public int getMethod() {
        return this._method;
    }

    public int getOrder() {
        return this._order;
    }

    public int getOrientation() {
        return this._orientation;
    }

    public DiagramModelNode getRoot() {
        return this.modelRoot;
    }

    public boolean getUseObjectsSizes() {
        return this._useObjectsSizes;
    }

    public void setFixedSpacing(boolean bool) {
        this._fixedSpacing = bool;
    }

    public void setFixedXSpacing(double d) {
        this._fixedXSpacing = d;
    }

    public void setFixedYSpacing(double d) {
        this._fixedYSpacing = d;
    }

    public void setMethod(int i) {
        this._method = i;
    }

    public void setOrder(int i) {
        this._order = i;
    }

    public void setOrientation(int i) {
        this._orientation = i;
    }

    public void setRoot(DiagramModelNode modelNode) {
        this.modelRoot = modelNode;
    }

    public void setUseObjectsSizes(boolean bool) {
        this._useObjectsSizes = bool;
    }

    private static class NotATreeException
    extends Exception {
        private static final long serialVersionUID = 1L;
    }

    private class TreeNode {
        int _level = -1;
        double _orderVar = 0.0;
        double _width = 0.0;
        double _height = 0.0;
        double _absolutePosition = 0.0;
        private double _absoluteSpaceLeft = 0.0;
        double _relativePosition = 0.0;
        private double _relativeSpaceLeft = 0.0;
        private TreeNode _parent = null;
        private final Vector _children = new Vector();
        private TreeNode _upNeighbor = null;
        private TreeNode _downNeighbor = null;
        private boolean _upSibling = false;
        private boolean _downSibling = false;

        public TreeNode(DiagramModelNode modelNode) {
        }

        public void calculatePosition(double[] ds, double[] ds_0_) {
            int i = this._children.size();
            if (i == 0) {
                this._absolutePosition = ds[this._level] + 0.5 * this._height;
                int n = this._level;
                ds[n] = ds[n] + this._height;
                ds_0_[this._level] = this._relativePosition = ds_0_[this._level] + 1.0;
            } else {
                double d = 0.0;
                double d_1_ = 0.0;
                int i_2_ = 0;
                while (i_2_ < i) {
                    TreeNode treenode_3_ = (TreeNode)this._children.get(i_2_);
                    treenode_3_.calculatePosition(ds, ds_0_);
                    d = treenode_3_._absolutePosition;
                    d_1_ = treenode_3_._relativePosition;
                    ++i_2_;
                }
                int[] is = new int[1];
                double[] ds_4_ = new double[2];
                int i_5_ = i - 2;
                while (i_5_ >= 0) {
                    TreeNode treenode_6_ = (TreeNode)this._children.get(i_5_);
                    is[0] = this._level;
                    treenode_6_.calculateSpaceDown(is, ds_4_);
                    double d_7_ = ds_4_[0];
                    double d_8_ = ds_4_[1] - 1.0;
                    if (d_7_ < 0.0) {
                        d_7_ = 0.0;
                    }
                    if (d_8_ < 0.0) {
                        d_8_ = 0.0;
                    }
                    if (d_7_ > 0.0 || d_8_ > 0.0) {
                        treenode_6_.shiftDown(ds, ds_0_, d_7_, d_8_);
                        treenode_6_._absoluteSpaceLeft = d_7_;
                        treenode_6_._relativeSpaceLeft = d_8_;
                    }
                    --i_5_;
                }
                TreeNode treenode_9_ = (TreeNode)this._children.get(0);
                this._absolutePosition = 0.5 * (treenode_9_._absolutePosition + d);
                this._relativePosition = 0.5 * (treenode_9_._relativePosition + d_1_);
                double d_10_ = treenode_9_._absoluteSpaceLeft;
                double d_11_ = treenode_9_._relativeSpaceLeft;
                int i_12_ = 1;
                while (i_12_ < i && treenode_9_._absoluteSpaceLeft > 0.0) {
                    treenode_9_._absoluteSpaceLeft -= d_10_;
                    if (treenode_9_._absoluteSpaceLeft < 0.0) {
                        treenode_9_._absoluteSpaceLeft = 0.0;
                    }
                    treenode_9_ = (TreeNode)this._children.get(i_12_);
                    ++i_12_;
                }
                treenode_9_ = (TreeNode)this._children.get(0);
                int i_13_ = 1;
                while (i_13_ < i && treenode_9_._relativeSpaceLeft > 0.0) {
                    treenode_9_._relativeSpaceLeft -= d_11_;
                    if (treenode_9_._relativeSpaceLeft < 0.0) {
                        treenode_9_._relativeSpaceLeft = 0.0;
                    }
                    treenode_9_ = (TreeNode)this._children.get(i_13_);
                    ++i_13_;
                }
                double d_14_ = ds[this._level] + 0.5 * this._height - this._absolutePosition;
                double d_15_ = ds_0_[this._level] + 1.0 - this._relativePosition;
                if (d_14_ < 0.0) {
                    d_14_ = 0.0;
                }
                if (d_15_ < 0.0) {
                    d_15_ = 0.0;
                }
                if (d_14_ > 0.0 || d_15_ > 0.0) {
                    this.shiftDown(ds, ds_0_, d_14_, d_15_);
                } else {
                    ds[this._level] = this._absolutePosition + 0.5 * this._height;
                    ds_0_[this._level] = this._relativePosition;
                }
            }
        }

        public void calculateSeparatePosition(double[] ds, double[] ds_16_) {
            int i = this._children.size();
            if (i == 0) {
                this._absolutePosition = ds[0] + 0.5 * this._height;
                ds[0] = ds[0] + this._height;
                ds_16_[0] = this._relativePosition = ds_16_[0] + 1.0;
            } else {
                double d = ds[0];
                double d_17_ = 0.0;
                double d_18_ = 0.0;
                int i_19_ = 0;
                while (i_19_ < i) {
                    TreeNode treenode_20_ = (TreeNode)this._children.get(i_19_);
                    treenode_20_.calculateSeparatePosition(ds, ds_16_);
                    d_17_ = treenode_20_._absolutePosition;
                    d_18_ = treenode_20_._relativePosition;
                    ++i_19_;
                }
                TreeNode treenode_21_ = (TreeNode)this._children.get(0);
                this._absolutePosition = 0.5 * (treenode_21_._absolutePosition + d_17_);
                this._relativePosition = 0.5 * (treenode_21_._relativePosition + d_18_);
                if ((d -= this._absolutePosition - 0.5 * this._height) > 0.0) {
                    this.shiftSeparateDown(ds, d);
                }
                ds[0] = Math.max(this._absolutePosition + 0.5 * this._height, ds[0]);
            }
        }

        private void calculateSpaceDown(int[] is, double[] ds) {
            double d = -1.0;
            double d_22_ = -1.0;
            if (this._level > is[0]) {
                is[0] = this._level;
                if (this._downNeighbor != null) {
                    d = this._downNeighbor._absolutePosition - this._absolutePosition - 0.5 * (this._height + this._downNeighbor._height);
                    d_22_ = this._downNeighbor._relativePosition - this._relativePosition;
                    if (d <= 0.0 && d_22_ <= 1.0) {
                        ds[0] = d;
                        ds[1] = d_22_;
                        return;
                    }
                }
            }
            int i = this._children.size();
            int i_23_ = i - 1;
            while (i_23_ >= 0) {
                TreeNode treenode_24_ = (TreeNode)this._children.get(i_23_);
                treenode_24_.calculateSpaceDown(is, ds);
                if (ds[0] >= 0.0 && (ds[0] < d || d < 0.0)) {
                    d = ds[0];
                }
                if (ds[1] >= 1.0 && (ds[1] < d_22_ || d_22_ < 0.0)) {
                    d_22_ = ds[1];
                }
                if (d <= 0.0 && d_22_ <= 1.0) {
                    ds[0] = d;
                    ds[1] = d_22_;
                    return;
                }
                --i_23_;
            }
            ds[0] = d;
            ds[1] = d_22_;
        }

        private double absoluteSetEven(double d, int i) {
            double d_25_ = 0.0;
            double d_26_ = Math.min(d, this._absoluteSpaceLeft);
            if (this._downSibling && this._downNeighbor._absoluteSpaceLeft > 0.0) {
                d_25_ = this._downNeighbor.absoluteSetEven(d_26_, i + 1);
            }
            if ((d_25_ += (d_26_ - d_25_) / (double)(i + 1)) > 0.0) {
                this.shiftUpAbsolute(d_25_);
            }
            this._absoluteSpaceLeft = 0.0;
            return d_25_;
        }

        private double relativeSetEven(double d, int i) {
            double d_27_ = 0.0;
            double d_28_ = Math.min(d, this._relativeSpaceLeft);
            if (this._downSibling && this._downNeighbor._relativeSpaceLeft > 0.0) {
                d_27_ = this._downNeighbor.relativeSetEven(d_28_, i + 1);
            }
            if ((d_27_ += (d_28_ - d_27_) / (double)(i + 1)) > 0.0) {
                this.shiftUpRelative(d_27_);
            }
            this._relativeSpaceLeft = 0.0;
            return d_27_;
        }

        void getMaximumWidths(double[] ds) {
            ds[this._level] = Math.max(ds[this._level], this._width);
            int i = this._children.size();
            int i_29_ = 0;
            while (i_29_ < i) {
                ((TreeNode)this._children.get(i_29_)).getMaximumWidths(ds);
                ++i_29_;
            }
        }

        public void setEven() {
            int i = this._children.size();
            int i_30_ = 0;
            while (i_30_ < i) {
                TreeNode treenode_31_ = (TreeNode)this._children.get(i_30_);
                treenode_31_.setEven();
                if (treenode_31_._absoluteSpaceLeft > 0.0) {
                    treenode_31_.absoluteSetEven(treenode_31_._absoluteSpaceLeft, 1);
                }
                if (treenode_31_._relativeSpaceLeft > 0.0) {
                    treenode_31_.relativeSetEven(treenode_31_._relativeSpaceLeft, 1);
                }
                ++i_30_;
            }
        }

        public void addLinkToNode(TreeNode treenode_32_) {
            int i = this._children.size();
            int i_33_ = 0;
            while (i_33_ < i && ((TreeNode)this._children.get((int)i_33_))._orderVar < treenode_32_._orderVar) {
                ++i_33_;
            }
            if (i_33_ >= i || (TreeNode)this._children.get(i_33_) != treenode_32_) {
                this._children.add(i_33_, treenode_32_);
            }
        }

        public void setNeighbors(TreeNode[] treenodes) {
            if (treenodes[this._level] != null) {
                this._upNeighbor = treenodes[this._level];
                this._upSibling = this._upNeighbor._parent == this._parent;
                this._upNeighbor._downNeighbor = this;
                this._upNeighbor._downSibling = this._upSibling;
            }
            treenodes[this._level] = this;
            int i = this._children.size();
            int i_34_ = 0;
            while (i_34_ < i) {
                ((TreeNode)this._children.get(i_34_)).setNeighbors(treenodes);
                ++i_34_;
            }
        }

        public int setParent(TreeNode treenode_35_) throws NotATreeException {
            if (this._parent != null) {
                throw new NotATreeException();
            }
            this._parent = treenode_35_;
            this._level = treenode_35_ != null ? treenode_35_._level + 1 : 0;
            this._children.remove(treenode_35_);
            int i = this._children.size();
            int i_36_ = this._level;
            int i_37_ = 0;
            while (i_37_ < i) {
                i_36_ = Math.max(i_36_, ((TreeNode)this._children.get(i_37_)).setParent(this));
                ++i_37_;
            }
            return i_36_;
        }

        private void shiftDown(double[] ds, double[] ds_47_, double d, double d_48_) {
            this._absolutePosition += d;
            this._relativePosition += d_48_;
            ds[this._level] = Math.max(ds[this._level], this._absolutePosition + 0.5 * this._height);
            ds_47_[this._level] = Math.max(ds_47_[this._level], this._relativePosition);
            int i = this._children.size();
            int i_49_ = 0;
            while (i_49_ < i) {
                ((TreeNode)this._children.get(i_49_)).shiftDown(ds, ds_47_, d, d_48_);
                ++i_49_;
            }
        }

        private void shiftSeparateDown(double[] ds, double d) {
            this._absolutePosition += d;
            ds[0] = Math.max(ds[0], this._absolutePosition + 0.5 * this._height);
            int i = this._children.size();
            int i_50_ = 0;
            while (i_50_ < i) {
                ((TreeNode)this._children.get(i_50_)).shiftSeparateDown(ds, d);
                ++i_50_;
            }
        }

        private void shiftUpAbsolute(double d) {
            this._absolutePosition -= d;
            int i = this._children.size();
            int i_51_ = 0;
            while (i_51_ < i) {
                ((TreeNode)this._children.get(i_51_)).shiftUpAbsolute(d);
                ++i_51_;
            }
        }

        private void shiftUpRelative(double d) {
            this._relativePosition -= d;
            int i = this._children.size();
            int i_52_ = 0;
            while (i_52_ < i) {
                ((TreeNode)this._children.get(i_52_)).shiftUpRelative(d);
                ++i_52_;
            }
        }
    }
}

