/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.diagram.ui.custom.actions;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.ui.IWorkbenchPart;
import org.teiid.designer.core.ModelerCore;
import org.teiid.designer.core.metamodel.aspect.MetamodelAspect;
import org.teiid.designer.core.metamodel.aspect.uml.UmlPackage;
import org.teiid.designer.core.workspace.ModelResource;
import org.teiid.designer.core.workspace.ModelUtil;
import org.teiid.designer.core.workspace.ModelWorkspaceException;
import org.teiid.designer.diagram.ui.DiagramUiConstants;
import org.teiid.designer.diagram.ui.actions.DiagramAction;
import org.teiid.designer.metamodels.diagram.Diagram;
import org.teiid.designer.ui.common.eventsupport.SelectionUtilities;
import org.teiid.designer.ui.editors.ModelEditorManager;
import org.teiid.designer.ui.viewsupport.ModelObjectUtilities;
import org.teiid.designer.ui.viewsupport.ModelUtilities;

public class NewCustomDiagramAction
extends DiagramAction
implements DiagramUiConstants {
    private static final boolean PERSIST_CUSTOM_DIAGRAMS = true;

    public NewCustomDiagramAction() {
    }

    public NewCustomDiagramAction(int theStyle) {
        super(theStyle);
    }

    public void selectionChanged(IWorkbenchPart part, ISelection selection) {
        super.selectionChanged(part, selection);
        this.determineEnablement();
    }

    @Override
    protected void doRun() {
        block14: {
            Object selectedObject = SelectionUtilities.getSelectedObject((ISelection)this.getSelection());
            boolean requiredStart = false;
            boolean succeeded = false;
            try {
                try {
                    requiredStart = ModelerCore.startTxn((boolean)true, (boolean)false, (String)"New Custom Diagram", (Object)this);
                    this.createDiagram(selectedObject);
                    succeeded = true;
                }
                catch (ModelWorkspaceException ex) {
                    String message = Util.getString("NewCustomDiagramAction.createCustomDiagramError", (Object)selectedObject.toString());
                    Util.log(4, (Throwable)ex, message);
                    if (requiredStart) {
                        if (succeeded) {
                            ModelerCore.commitTxn();
                        } else {
                            ModelerCore.rollbackTxn();
                        }
                    }
                    break block14;
                }
            }
            catch (Throwable throwable) {
                if (requiredStart) {
                    if (succeeded) {
                        ModelerCore.commitTxn();
                    } else {
                        ModelerCore.rollbackTxn();
                    }
                }
                throw throwable;
            }
            if (requiredStart) {
                if (succeeded) {
                    ModelerCore.commitTxn();
                } else {
                    ModelerCore.rollbackTxn();
                }
            }
        }
        this.determineEnablement();
    }

    private void createDiagram(Object selectedObject) throws ModelWorkspaceException {
        if (selectedObject instanceof IResource && ModelUtilities.isModelFile((IResource)((IResource)selectedObject))) {
            ModelResource modelResource = ModelUtil.getModelResource((IFile)((IFile)selectedObject), (boolean)false);
            if (modelResource != null) {
                Diagram result = modelResource.getModelDiagrams().createNewDiagram(null, true);
                result.setType("customDiagramType");
            }
        } else {
            ModelResource modelResource;
            EObject eObject = SelectionUtilities.getSelectedEObject((ISelection)this.getSelection());
            if (eObject != null && (modelResource = ModelUtilities.getModelResourceForModelObject((EObject)eObject)) != null) {
                Diagram result = modelResource.getModelDiagrams().createNewDiagram(eObject, true);
                result.setType("customDiagramType");
            }
        }
    }

    private void determineEnablement() {
        Object selectedObject = SelectionUtilities.getSelectedObject((ISelection)this.getSelection());
        if (selectedObject instanceof IResource && ModelUtilities.isModelFile((IResource)((IResource)selectedObject))) {
            ModelResource modelResource = null;
            try {
                modelResource = ModelUtil.getModelResource((IFile)((IFile)selectedObject), (boolean)false);
            }
            catch (ModelWorkspaceException e) {
                String message = Util.getString("NewCustomDiagramAction.createCustomDiagramError", (Object)selectedObject.toString());
                Util.log(4, (Throwable)e, message);
            }
            if (modelResource != null && !modelResource.isReadOnly()) {
                this.setEnabled(true);
                return;
            }
        } else {
            MetamodelAspect aspect;
            ModelResource modelResource;
            EObject eObject = SelectionUtilities.getSelectedEObject((ISelection)this.getSelection());
            if (eObject != null && (modelResource = ModelUtilities.getModelResourceForModelObject((EObject)eObject)) != null && !modelResource.isReadOnly() && (aspect = ModelObjectUtilities.getUmlAspect((EObject)eObject)) != null && aspect instanceof UmlPackage) {
                this.setEnabled(true);
                return;
            }
        }
        this.setEnabled(false);
    }

    protected boolean preRun() {
        if (this.requiresEditorForRun()) {
            Object selectedObject = SelectionUtilities.getSelectedObject((ISelection)this.getSelection());
            ModelResource modelResource = null;
            if (selectedObject instanceof IResource && ModelUtilities.isModelFile((IResource)((IResource)selectedObject))) {
                try {
                    modelResource = ModelUtil.getModelResource((IFile)((IFile)selectedObject), (boolean)false);
                }
                catch (ModelWorkspaceException e) {
                    String message = Util.getString("NewCustomDiagramAction.createCustomDiagramError", (Object)selectedObject.toString());
                    Util.log(4, (Throwable)e, message);
                }
            } else {
                EObject eObject = SelectionUtilities.getSelectedEObject((ISelection)this.getSelection());
                if (eObject != null) {
                    modelResource = ModelUtilities.getModelResourceForModelObject((EObject)eObject);
                }
            }
            if (modelResource != null) {
                ModelEditorManager.activate((ModelResource)modelResource, (boolean)true);
            }
        }
        return true;
    }

    @Override
    protected boolean requiresEditorForRun() {
        return true;
    }
}

