/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.webservice.ui.wizard;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.custom.ViewForm;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.teiid.core.designer.util.CoreArgCheck;
import org.teiid.core.designer.util.I18nUtil;
import org.teiid.designer.ui.common.util.WidgetFactory;
import org.teiid.designer.ui.common.widget.Dialog;
import org.teiid.designer.webservice.IWebServiceModelBuilder;
import org.teiid.designer.webservice.IWebServiceResource;
import org.teiid.designer.webservice.ui.IInternalUiConstants;
import org.teiid.designer.webservice.ui.util.WebServiceUiUtil;

public final class ShowDependenciesDialog
extends Dialog
implements IInternalUiConstants {
    static final String PREFIX = I18nUtil.getPropertyPrefix(ShowDependenciesDialog.class);
    private static final String[] TBL_HDRS;
    static final int NAMESPACE_COLUMN;
    static final int USES_COLUMN;
    private IWebServiceModelBuilder builder;

    static {
        NAMESPACE_COLUMN = 0;
        USES_COLUMN = 1;
        TBL_HDRS = new String[2];
        ShowDependenciesDialog.TBL_HDRS[ShowDependenciesDialog.NAMESPACE_COLUMN] = ShowDependenciesDialog.getString("tableColumn.namespace");
        ShowDependenciesDialog.TBL_HDRS[ShowDependenciesDialog.USES_COLUMN] = ShowDependenciesDialog.getString("tableColumn.uses");
    }

    public ShowDependenciesDialog(Shell theShell, IWebServiceModelBuilder theBuilder) {
        super(theShell, ShowDependenciesDialog.getString("title"));
        ShowDependenciesDialog.setDefaultImage((Image)WebServiceUiUtil.getImage("icons/full/cview16/show_dependencies.gif"));
        this.setCenterOnDisplay(true);
        this.builder = theBuilder;
    }

    protected Button createButton(Composite theParent, int theId, String theLabel, boolean theDefaultButton) {
        return theId == 1 ? null : super.createButton(theParent, theId, theLabel, theDefaultButton);
    }

    protected Control createDialogArea(Composite theParent) {
        ViewForm viewForm = WidgetFactory.createViewForm((Composite)theParent, (int)2048, (int)1808, (int)1);
        viewForm.setTopLeft((Control)WidgetFactory.createLabel((Composite)viewForm, (String)ShowDependenciesDialog.getString("label.tableViewForm")));
        Composite pnl = WidgetFactory.createPanel((Composite)viewForm);
        viewForm.setContent((Control)pnl);
        int style = 68354;
        TableViewer viewer = WidgetFactory.createTableViewer((Composite)pnl, (int)style);
        viewer.setContentProvider((IContentProvider)new TableContentProvider());
        viewer.setLabelProvider((IBaseLabelProvider)new TableLabelProvider());
        Table tbl = viewer.getTable();
        tbl.setHeaderVisible(true);
        tbl.setLinesVisible(true);
        int i = 0;
        while (i < TBL_HDRS.length) {
            TableColumn col = new TableColumn(tbl, 16384);
            col.setText(TBL_HDRS[i]);
            ++i;
        }
        viewer.setInput((Object)this.builder);
        i = 0;
        while (i < TBL_HDRS.length) {
            viewer.getTable().getColumn(i).pack();
            ++i;
        }
        return viewForm.getContent();
    }

    IWebServiceModelBuilder getBuilder() {
        return this.builder;
    }

    private static String getString(String theKey) {
        return UTIL.getString(new StringBuffer().append(PREFIX).append(theKey).toString(), new Object[0]);
    }

    class TableContentProvider
    implements IStructuredContentProvider {
        TableContentProvider() {
        }

        public void dispose() {
        }

        public Object[] getElements(Object theInputElement) {
            ArrayList<TableRow> result = new ArrayList<TableRow>();
            IWebServiceModelBuilder builder = ShowDependenciesDialog.this.getBuilder();
            for (IWebServiceResource resource : builder.getResources()) {
                Collection references = resource.getReferencedResources();
                if (references == null || references.isEmpty()) continue;
                Iterator itrRefs = references.iterator();
                while (itrRefs.hasNext()) {
                    result.add(new TableRow(resource, (IWebServiceResource)itrRefs.next()));
                }
            }
            return result.toArray();
        }

        public void inputChanged(Viewer theViewer, Object theOldInput, Object theNewInput) {
        }
    }

    class TableLabelProvider
    extends LabelProvider
    implements ITableLabelProvider {
        TableLabelProvider() {
        }

        public Image getColumnImage(Object theElement, int theIndex) {
            Image result = null;
            if (theElement instanceof TableRow) {
                TableRow row = (TableRow)theElement;
                if (theIndex == NAMESPACE_COLUMN) {
                    if (!row.namespace.isResolved()) {
                        result = WebServiceUiUtil.getStatusImage(row.namespace.getStatus());
                    }
                } else if (theIndex == USES_COLUMN) {
                    if (!row.uses.isResolved()) {
                        result = WebServiceUiUtil.getStatusImage(row.uses.getStatus());
                    }
                } else {
                    CoreArgCheck.isTrue((boolean)false, (String)UTIL.getString(String.valueOf(PREFIX) + "msg.unknownTableColumn", new Object[]{Integer.toString(theIndex)}));
                }
            } else {
                CoreArgCheck.isTrue((boolean)false, (String)UTIL.getString(String.valueOf(PREFIX) + "msg.unknownObjectType", new Object[]{theElement.getClass().getName()}));
            }
            return result;
        }

        public String getColumnText(Object theElement, int theIndex) {
            String result = null;
            if (theElement instanceof TableRow) {
                if (theIndex == NAMESPACE_COLUMN) {
                    result = WebServiceUiUtil.getText(((TableRow)theElement).namespace);
                } else if (theIndex == USES_COLUMN) {
                    result = WebServiceUiUtil.getText(((TableRow)theElement).uses);
                } else {
                    CoreArgCheck.isTrue((boolean)false, (String)UTIL.getString(String.valueOf(PREFIX) + "msg.unknownTableColumn", new Object[]{Integer.toString(theIndex)}));
                }
            } else {
                CoreArgCheck.isTrue((boolean)false, (String)UTIL.getString(String.valueOf(PREFIX) + "msg.unknownObjectType", new Object[]{theElement.getClass().getName()}));
            }
            return result;
        }
    }

    private class TableRow {
        public IWebServiceResource namespace;
        public IWebServiceResource uses;

        public TableRow(IWebServiceResource theNamespace, IWebServiceResource theUses) {
            this.namespace = theNamespace;
            this.uses = theUses;
        }
    }
}

