/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.webservice.ui.wizard;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.ListenerList;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.swt.custom.CLabel;
import org.eclipse.swt.custom.ViewForm;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.help.IWorkbenchHelpSystem;
import org.teiid.core.designer.util.I18nUtil;
import org.teiid.designer.core.ModelerCore;
import org.teiid.designer.ui.common.product.ProductCustomizerMgr;
import org.teiid.designer.ui.common.util.UiUtil;
import org.teiid.designer.ui.common.util.WidgetFactory;
import org.teiid.designer.ui.common.util.WidgetUtil;
import org.teiid.designer.ui.common.widget.GridPanel;
import org.teiid.designer.ui.common.widget.Label;
import org.teiid.designer.ui.explorer.ModelExplorerLabelProvider;
import org.teiid.designer.ui.viewsupport.ModelNameUtil;
import org.teiid.designer.ui.viewsupport.ModelingResourceFilter;
import org.teiid.designer.webservice.IWebServiceModelBuilder;
import org.teiid.designer.webservice.IWebServiceXsdResource;
import org.teiid.designer.webservice.ui.IInternalUiConstants;
import org.teiid.designer.webservice.ui.WebServiceUiPlugin;
import org.teiid.designer.webservice.ui.util.WebServiceUiUtil;

public class SchemaLocationEditor
extends GridPanel
implements IInternalUiConstants,
IInternalUiConstants.HelpContexts,
IInternalUiConstants.Images {
    private static final String DIRTY_INDICATOR = "*";
    private static final String PREFIX = I18nUtil.getPropertyPrefix(SchemaLocationEditor.class);
    public static final int FOLDER_ONLY_SAVED = 0;
    public static final int MODEL_ONLY_SAVED = 1;
    public static final int SAVED = 2;
    public static final int CLOSED = 3;
    private static final String TARGET_FOLDER_MRU = "targetFolderList";
    private String currentFolder;
    private boolean dirty;
    private boolean isValid;
    private List editorInput;
    private IWebServiceModelBuilder builder;
    private String initialFolder;
    private String initialName;
    private ListenerList listeners;
    private IDialogSettings settings;
    private TargetFilter targetFilter;
    private Button btnApply;
    private Button btnFolder;
    private Combo cbxFolder;
    private Button chkFolder;
    private Button chkName;
    private CLabel lblEditorTitle;
    private CLabel lblStatusMsg;
    private Text txfName;
    private ViewForm viewForm;

    public SchemaLocationEditor(Composite theParent, IWebServiceModelBuilder theBuilder) {
        super(theParent);
        IWorkbenchHelpSystem helpSystem = UiUtil.getWorkbench().getHelpSystem();
        helpSystem.setHelp((Control)this, "org.teiid.designer.webservice.ui.schemaLocationPage_schemaLocationEditor");
        this.builder = theBuilder;
        this.listeners = new ListenerList(1);
        this.targetFilter = new TargetFilter();
        this.constructUi((Composite)this);
    }

    public void addListener(Listener theListener) {
        this.listeners.add((Object)theListener);
    }

    public void clear() {
        this.setInput(null);
    }

    public Point computeSize(int theWidgthHint, int theHeightHint, boolean theChangedFlag) {
        return this.getVisible() ? super.computeSize(theWidgthHint, theHeightHint, theChangedFlag) : new Point(0, 0);
    }

    private void constructUi(Composite theParent) {
        this.viewForm = WidgetFactory.createViewForm((Composite)theParent, (int)2048, (int)1808, (int)1);
        this.lblEditorTitle = WidgetFactory.createLabel((Composite)this.viewForm, (String)this.getTitle(), (Image)WebServiceUiPlugin.getDefault().getImage("icons/full/cview16/schemaEditor.gif"), (int)0);
        this.viewForm.setTopLeft((Control)this.lblEditorTitle);
        this.createActions(WidgetFactory.createViewFormToolBar((ViewForm)this.viewForm));
        Composite pnl = WidgetFactory.createPanel((Composite)this.viewForm, (int)0, (int)1808, (int)1, (int)4);
        this.viewForm.setContent((Control)pnl);
        this.chkFolder = WidgetFactory.createCheckBox((Composite)pnl);
        this.chkFolder.setEnabled(false);
        this.chkFolder.setToolTipText(UTIL.getString(String.valueOf(PREFIX) + "checkBox.folder.tip", new Object[0]));
        this.chkFolder.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent theEvent) {
                SchemaLocationEditor.this.handleFolderCheckBoxSelected();
            }
        });
        Label folderLabel = WidgetFactory.createLabel((Composite)pnl, (String)UTIL.getString(String.valueOf(PREFIX) + "label.folder", new Object[0]));
        this.cbxFolder = WidgetFactory.createCombo((Composite)pnl, (int)8, (int)768);
        this.cbxFolder.setEnabled(false);
        this.cbxFolder.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent theEvent) {
                SchemaLocationEditor.this.handleFolderChanged();
            }
        });
        this.btnFolder = WidgetFactory.createButton((Composite)pnl, (String)UTIL.getString(String.valueOf(PREFIX) + "button.browse", new Object[0]));
        this.btnFolder.setEnabled(false);
        this.btnFolder.setToolTipText(UTIL.getString(String.valueOf(PREFIX) + "button.browse.folder.tip", new Object[0]));
        this.btnFolder.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent theEvent) {
                SchemaLocationEditor.this.handleBrowseFolderSelected();
            }
        });
        this.chkName = WidgetFactory.createCheckBox((Composite)pnl);
        this.chkName.setEnabled(false);
        this.chkName.setToolTipText(UTIL.getString(String.valueOf(PREFIX) + "checkBox.targetName.tip", new Object[0]));
        this.chkName.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent theEvent) {
                SchemaLocationEditor.this.handleNameCheckBoxSelected();
            }
        });
        WidgetFactory.createLabel((Composite)pnl, (String)UTIL.getString(String.valueOf(PREFIX) + "label.targetName", new Object[0]));
        this.txfName = WidgetFactory.createTextField((Composite)pnl, (int)256, (int)2);
        this.txfName.setEnabled(false);
        this.txfName.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent theEvent) {
                SchemaLocationEditor.this.handleNameChanged();
            }
        });
        this.lblStatusMsg = WidgetFactory.createLabel((Composite)pnl, (int)256, (int)4);
        int style = 1424;
        Composite pnlButtons = WidgetFactory.createPanel((Composite)pnl, (int)0, (int)style, (int)4, (int)1);
        ((GridLayout)pnlButtons.getLayout()).marginWidth = 0;
        this.btnApply = WidgetFactory.createButton((Composite)pnlButtons, (String)UTIL.getString(String.valueOf(PREFIX) + "button.apply", new Object[0]));
        this.btnApply.setEnabled(false);
        this.btnApply.setToolTipText(UTIL.getString(String.valueOf(PREFIX) + "button.apply.tip", new Object[0]));
        this.btnApply.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent theEvent) {
                SchemaLocationEditor.this.handleApplySelected();
            }
        });
        if (ProductCustomizerMgr.getInstance().getProductCharacteristics().isHiddenProjectCentric()) {
            folderLabel.setVisible(false);
            this.btnFolder.setVisible(false);
            this.cbxFolder.setVisible(false);
            this.chkFolder.setVisible(false);
        }
    }

    private void createActions(IToolBarManager theToolBarMgr) {
        Action action = new Action(){

            public void run() {
                SchemaLocationEditor.this.setVisible(false);
                SchemaLocationEditor.this.fireEvent(3);
            }
        };
        action.setImageDescriptor(WebServiceUiPlugin.getDefault().getImageDescriptor("icons/full/cview16/closeEditor.gif"));
        action.setToolTipText(UTIL.getString(String.valueOf(PREFIX) + "button.closeEditor.tip", new Object[0]));
        theToolBarMgr.add((IAction)action);
        theToolBarMgr.update(true);
    }

    void fireEvent(int theType) {
        Event event = new Event();
        event.widget = this;
        event.type = theType;
        Object[] stateListeners = this.listeners.getListeners();
        int i = 0;
        while (i < stateListeners.length) {
            ((Listener)stateListeners[i]).handleEvent(event);
            ++i;
        }
    }

    private String getContainerText(IContainer theContainer) {
        return theContainer == null ? "" : theContainer.getFullPath().makeRelative().toString();
    }

    public List getInput() {
        return this.editorInput;
    }

    private IPath getNewPath(String theFolder, String theName) {
        IPath result = null;
        IResource resource = ModelerCore.getWorkspace().getRoot().findMember(theFolder);
        if (resource != null && resource instanceof IContainer) {
            IContainer folder = (IContainer)resource;
            result = folder.getFullPath().append(theName).makeRelative();
        }
        return result;
    }

    private String getTitle() {
        String result = null;
        if (this.editorInput == null || this.editorInput.isEmpty()) {
            result = UTIL.getString(String.valueOf(PREFIX) + "label.editorTitle.noInput", new Object[0]);
        } else {
            IWebServiceXsdResource xsd = (IWebServiceXsdResource)this.editorInput.get(0);
            result = UTIL.getString(String.valueOf(PREFIX) + "label.editorTitle", new Object[]{xsd.getTargetNamespace()});
        }
        return result;
    }

    void handleApplySelected() {
        boolean folderChanged = this.chkFolder.getSelection();
        boolean modelChanged = this.chkName.getSelection();
        IPath newPath = null;
        if (folderChanged || modelChanged) {
            this.initialFolder = this.currentFolder;
            this.initialName = String.valueOf(this.txfName.getText()) + ".xsd";
            newPath = this.getNewPath(this.initialFolder, this.initialName);
            int size = this.editorInput.size();
            int i = 0;
            while (i < size) {
                IWebServiceXsdResource xsd = (IWebServiceXsdResource)this.editorInput.get(i);
                this.builder.setDestinationPath(xsd, newPath);
                ++i;
            }
        }
        this.btnApply.setEnabled(false);
        this.chkFolder.setSelection(false);
        this.chkFolder.setEnabled(false);
        this.chkName.setSelection(false);
        this.chkName.setEnabled(false);
        this.updateState();
        if (this.settings != null) {
            WidgetUtil.saveSettings((IDialogSettings)this.settings, (String)TARGET_FOLDER_MRU, (Combo)this.cbxFolder);
        }
        int type = -1;
        if (folderChanged && modelChanged) {
            type = 2;
        } else if (modelChanged) {
            type = 1;
        } else if (folderChanged) {
            type = 0;
        }
        this.fireEvent(type);
    }

    void handleBrowseFolderSelected() {
        Object[] resources = WidgetUtil.showWorkspaceObjectSelectionDialog((String)UTIL.getString(String.valueOf(PREFIX) + "dialog.targetLocationChooser.title", new Object[0]), (String)UTIL.getString(String.valueOf(PREFIX) + "dialog.targetLocationChooser.msg", new Object[0]), (boolean)false, (Object)this.currentFolder, (ViewerFilter)new ModelingResourceFilter((ViewerFilter)this.targetFilter), null, (ILabelProvider)new ModelExplorerLabelProvider());
        if (resources != null && resources.length > 0) {
            this.setFolder(this.getContainerText((IContainer)resources[0]));
        }
    }

    void handleFolderChanged() {
        boolean check;
        this.currentFolder = this.cbxFolder.getText();
        boolean bl = check = this.currentFolder.length() > 0;
        if (check) {
            check = this.initialFolder == null ? true : !this.initialFolder.equals(this.currentFolder);
        }
        this.chkFolder.setSelection(check);
        this.chkFolder.setEnabled(check);
        this.updateState();
    }

    void handleFolderCheckBoxSelected() {
        if (!this.chkFolder.getSelection()) {
            this.setFolder(this.initialFolder);
        }
        this.updateState();
    }

    void handleNameChanged() {
        boolean check = false;
        check = this.initialName == null ? this.txfName.getText().length() > 0 : !this.initialName.equals(this.txfName.getText());
        this.chkName.setSelection(check);
        this.chkName.setEnabled(check);
        this.updateState();
    }

    void handleNameCheckBoxSelected() {
        if (!this.chkName.getSelection()) {
            this.setSchemaName(this.initialName);
        }
        this.updateState();
    }

    public boolean isDirty() {
        return this.dirty;
    }

    public boolean canSave() {
        return this.isValid;
    }

    public void removeListener(Listener theListener) {
        this.listeners.remove((Object)theListener);
    }

    public void save() {
        if (this.isDirty()) {
            this.handleApplySelected();
        }
    }

    public void setDialogSettings(IDialogSettings theSettings) {
        this.settings = theSettings;
        String[] temp = this.settings.getArray(TARGET_FOLDER_MRU);
        this.setFolderMru(temp == null ? new String[]{} : temp);
    }

    public void setEnabled(boolean theEnableFlag) {
        super.setEnabled(theEnableFlag);
        this.btnFolder.setEnabled(theEnableFlag);
        this.btnApply.setEnabled(theEnableFlag);
        this.cbxFolder.setEnabled(theEnableFlag);
        this.txfName.setEnabled(theEnableFlag);
        this.chkFolder.setEnabled(theEnableFlag);
        this.chkName.setEnabled(theEnableFlag);
    }

    private void setFolder(String thePath) {
        if (thePath != null) {
            int index = this.cbxFolder.indexOf(thePath);
            if (index == -1) {
                this.cbxFolder.add(thePath);
                index = this.cbxFolder.indexOf(thePath);
            }
            this.cbxFolder.select(index);
        }
    }

    private void setFolderMru(String[] theFolders) {
        ArrayList<String> folders = null;
        if (theFolders == null || theFolders.length == 0) {
            folders = new ArrayList<String>(0);
        } else {
            folders = new ArrayList(theFolders.length);
            int i = 0;
            while (i < theFolders.length) {
                if (ModelerCore.getWorkspace().getRoot().findMember(theFolders[i]) != null) {
                    folders.add(theFolders[i]);
                }
                ++i;
            }
        }
        WidgetUtil.setComboItems((Combo)this.cbxFolder, folders, null, (boolean)true);
    }

    public void setInput(List theSchemas) {
        this.editorInput = theSchemas;
        this.initialFolder = null;
        this.initialName = "";
        boolean checkFolder = true;
        boolean checkName = true;
        int numSchemas = 0;
        if (theSchemas == null || theSchemas.isEmpty()) {
            this.setEnabled(false);
        } else {
            this.setEnabled(true);
            numSchemas = theSchemas.size();
            int i = 0;
            while (i < numSchemas) {
                int index;
                String tempFolder = null;
                String tempName = null;
                IWebServiceXsdResource xsd = (IWebServiceXsdResource)theSchemas.get(i);
                IPath path = xsd.getDestinationPath();
                if (checkFolder) {
                    tempFolder = path.removeLastSegments(1).toOSString();
                }
                if (checkName && (index = (tempName = path.lastSegment()).indexOf(".xsd")) != -1) {
                    tempName = tempName.substring(0, index);
                }
                if (i == 0) {
                    this.initialFolder = tempFolder;
                    this.initialName = tempName;
                }
                if (this.initialFolder == null) {
                    checkFolder = tempFolder == null;
                } else {
                    boolean bl = checkFolder = tempFolder == null ? false : this.initialFolder.equals(tempFolder);
                }
                if (!checkFolder) {
                    this.initialFolder = null;
                }
                if (!this.initialName.equals(tempName)) {
                    this.initialName = "";
                    checkName = false;
                }
                if (!checkFolder && !checkName) break;
                ++i;
            }
        }
        this.lblEditorTitle.setText(this.getTitle());
        this.setFolder(this.initialFolder);
        this.setSchemaName(this.initialName);
        this.btnApply.setEnabled(false);
        this.chkFolder.setEnabled(false);
        this.chkFolder.setSelection(false);
        this.chkName.setEnabled(false);
        this.chkName.setSelection(false);
        this.updateState();
    }

    private void setSchemaName(String theName) {
        this.txfName.setText(theName);
    }

    private void setTitleDirty(boolean theDirtyFlag) {
        String currentTitle = this.lblEditorTitle.getText();
        boolean update = false;
        if (theDirtyFlag && !currentTitle.startsWith(DIRTY_INDICATOR)) {
            this.lblEditorTitle.setText(DIRTY_INDICATOR + currentTitle);
            update = true;
        } else if (!theDirtyFlag && currentTitle.startsWith(DIRTY_INDICATOR)) {
            this.lblEditorTitle.setText(currentTitle.substring(1));
            update = true;
        }
        if (update) {
            this.lblEditorTitle.update();
        }
    }

    private void updateState() {
        this.dirty = this.chkFolder.getSelection() || this.chkName.getSelection();
        this.setTitleDirty(this.dirty);
        this.isValid = true;
        Image image = null;
        String text = "";
        if (this.editorInput != null && !this.editorInput.isEmpty() && this.isDirty() && this.editorInput.size() == 1) {
            String enteredName = this.txfName.getText();
            boolean nameValid = false;
            if (enteredName != null && enteredName.length() > 0) {
                boolean bl = nameValid = ModelNameUtil.validate((String)enteredName, (String)".xsd", null, (int)5).getSeverity() < 4;
            }
            if (!nameValid) {
                text = UTIL.getString(String.valueOf(PREFIX) + "editor.invalidName.msg", new Object[0]);
                image = WebServiceUiUtil.getSharedImage("IMG_OBJS_ERROR_TSK");
                this.isValid = false;
            } else {
                IWebServiceXsdResource xsd = (IWebServiceXsdResource)this.editorInput.get(0);
                IStatus status = xsd.isValid(this.getNewPath(this.currentFolder, String.valueOf(this.txfName.getText()) + ".xsd"));
                image = WebServiceUiUtil.getStatusImage(status);
                text = status.getMessage();
                this.isValid = status.getSeverity() != 4;
            }
        }
        this.lblStatusMsg.setImage(image);
        this.lblStatusMsg.setText(text);
        this.btnApply.setEnabled(this.dirty && this.isValid);
    }

    class TargetFilter
    extends ViewerFilter {
        TargetFilter() {
        }

        public boolean select(Viewer theViewer, Object theParent, Object theElement) {
            IProject project;
            boolean result = false;
            IProject parentProject = SchemaLocationEditor.this.builder.getParentResource().getProject();
            if (parentProject != null && theElement instanceof IContainer && parentProject == (project = ((IContainer)theElement).getProject()) && project.isOpen()) {
                try {
                    if (project.getNature("org.teiid.designer.core.modelNature") != null) {
                        result = true;
                    }
                }
                catch (CoreException theException) {
                    UTIL.log((Throwable)theException);
                }
            }
            return result;
        }
    }
}

