/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.datatools.views;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.jface.text.Position;
import org.teiid.datatools.views.PlanAttribute;

public class PlanElement {
    private final String SEPARATOR = "/";
    private List<PlanElement> elementChildren = new ArrayList<PlanElement>();
    private List attributeChildren = new ArrayList();
    private String name;
    private PlanElement parent;
    private Position position;
    private String value;
    private boolean isRoot = false;

    public PlanElement(String name) {
        this.name = name;
    }

    public Object[] getChildElements() {
        return this.elementChildren.toArray(new Object[0]);
    }

    public PlanElement addChildElement(PlanElement element) {
        this.elementChildren.add(element);
        element.setParent(this);
        return this;
    }

    public void setParent(PlanElement element) {
        this.parent = element;
    }

    public PlanElement getParent() {
        return this.parent;
    }

    public PlanElement addChildAttribute(PlanAttribute attribute) {
        this.attributeChildren.add(attribute);
        return this;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getValue() {
        return this.value;
    }

    public void setValue(String value) {
        this.value = value;
    }

    public String getAttributeValue(String localName) {
        for (PlanAttribute attribute : this.attributeChildren) {
            if (!attribute.getName().equals(localName)) continue;
            return attribute.getValue();
        }
        return null;
    }

    public void clear() {
        this.elementChildren.clear();
        this.attributeChildren.clear();
    }

    public void setPosition(Position position) {
        this.position = position;
    }

    public Position getPosition() {
        return this.position;
    }

    public void setRoot(boolean isRoot) {
        this.isRoot = isRoot;
    }

    public boolean isRoot() {
        return this.isRoot;
    }

    public String getFullPath() {
        String path = "/" + this.getName();
        PlanElement thisElement = this;
        while (thisElement.getParent() != null) {
            path = "/" + thisElement.getParent().getName() + path;
            thisElement = thisElement.getParent();
        }
        return path;
    }
}

