/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.datatools.views;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.browser.Browser;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TabFolder;
import org.eclipse.swt.widgets.TabItem;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.help.IWorkbenchHelpSystem;
import org.eclipse.ui.part.ViewPart;
import org.osgi.service.prefs.BackingStoreException;
import org.teiid.datatools.connectivity.ui.Activator;
import org.teiid.datatools.connectivity.ui.Messages;
import org.teiid.datatools.connectivity.ui.plan.ExecutionPlanConverter;
import org.teiid.datatools.views.ExecutionPlan;
import org.teiid.datatools.views.ExecutionPlanParser;
import org.teiid.datatools.views.PlanElement;

public class ExecutionPlanView
extends ViewPart
implements IEclipsePreferences.IPreferenceChangeListener {
    public static final String VIEW_ID = "views.executionPlanView";
    private static final String IMPORT_PLAN_IMG = "icons/import_from_file.gif";
    private static final String EXPORT_PLAN_IMG = "icons/export_to_file.gif";
    private static final String EXECUTION_PLAN_HELP_ID = "org.teiid.designer.runtime.ui.executionPlanOverview";
    private static final String PREFIX = "ExecutionPlanView.";
    private Browser visualisation;
    private StyledText sqlTextArea;
    private TreeViewer planTreeViewer;
    private StyledText planTextArea;
    private Label panelDescriptionLabel;
    private Label panelPlansEnabledLabel;
    private String planString;
    private IAction saveToFileAction;
    private IAction readFromFileAction;
    private Button expandAll;
    private Button collapseAll;

    public void createPartControl(Composite parent) {
        this.createActions();
        this.createPanel(parent);
        IActionBars actionBars = this.getViewSite().getActionBars();
        this.configureToolBar(actionBars.getToolBarManager());
        IWorkbenchHelpSystem helpSystem = Activator.getDefault().getWorkbench().getHelpSystem();
        helpSystem.setHelp((Control)parent, EXECUTION_PLAN_HELP_ID);
        this.updateButtonEnablements();
    }

    public void setFocus() {
    }

    private void configureToolBar(IToolBarManager toolBarMgr) {
        toolBarMgr.add(this.saveToFileAction);
        toolBarMgr.add(this.readFromFileAction);
        toolBarMgr.update(true);
    }

    private void createActions() {
        String savePlanToFileActionText = Messages.getString("ExecutionPlanView.savePlanToFileButton.text");
        String savePlanToFileActionTooltip = Messages.getString("ExecutionPlanView.savePlanToFileButton.tooltip");
        this.saveToFileAction = new Action(savePlanToFileActionText, 2048){

            public void run() {
                ExecutionPlanView.this.handleSavePlanToFile();
            }
        };
        this.saveToFileAction.setToolTipText(savePlanToFileActionTooltip);
        this.saveToFileAction.setEnabled(false);
        this.saveToFileAction.setImageDescriptor(Activator.getDefault().getImageDescriptor(EXPORT_PLAN_IMG));
        String readPlanFromFileActionText = Messages.getString("ExecutionPlanView.readPlanFromFileButton.text");
        String readPlanFromFileActionTooltip = Messages.getString("ExecutionPlanView.readPlanFromFileButton.tooltip");
        this.readFromFileAction = new Action(readPlanFromFileActionText, 2048){

            public void run() {
                ExecutionPlanView.this.handleReadPlanFromFile();
            }
        };
        this.readFromFileAction.setToolTipText(readPlanFromFileActionTooltip);
        this.readFromFileAction.setEnabled(true);
        this.readFromFileAction.setImageDescriptor(Activator.getDefault().getImageDescriptor(IMPORT_PLAN_IMG));
    }

    private void createPanel(Composite parent) {
        Composite mainPanel = new Composite(parent, 0);
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 3;
        mainPanel.setLayout((Layout)gridLayout);
        mainPanel.setLayoutData((Object)new GridData(1808));
        this.createDescriptionPanel(mainPanel);
        SashForm splitter = new SashForm(mainPanel, 512);
        GridData gd = new GridData();
        gd.grabExcessVerticalSpace = true;
        gd.grabExcessHorizontalSpace = true;
        gd.verticalAlignment = 4;
        gd.horizontalAlignment = 4;
        gd.horizontalSpan = 3;
        splitter.setLayoutData((Object)gd);
        this.createSqlGroup((Composite)splitter);
        this.createPlanViewerGroup((Composite)splitter);
        splitter.setWeights(new int[]{25, 75});
        IEclipsePreferences prefs = Activator.getDefault().getPreferences();
        prefs.addPreferenceChangeListener((IEclipsePreferences.IPreferenceChangeListener)this);
    }

    private String getPlansEnabledText() {
        boolean showPlan = Activator.getDefault().getPreferences().getBoolean("org.teiid.datatools.connectivity.ui.preferences.TeiidQueryPlansEnabled", true);
        StringBuffer sb = new StringBuffer(Messages.getString("ExecutionPlanView.queryPlansEnabledLabel"));
        if (showPlan) {
            sb.append(" " + Messages.getString("ExecutionPlanView.queryPlansEnabledStateText"));
        } else {
            sb.append(" " + Messages.getString("ExecutionPlanView.queryPlansDisabledStateText"));
        }
        return sb.toString();
    }

    private void createSqlGroup(Composite parent) {
        Group sqlTextGroup = new Group(parent, 0);
        sqlTextGroup.setText(Messages.getString("ExecutionPlanView.sqlGroup"));
        sqlTextGroup.setLayout((Layout)new GridLayout(1, false));
        GridData gd = new GridData(1808);
        sqlTextGroup.setLayoutData((Object)gd);
        this.sqlTextArea = new StyledText((Composite)sqlTextGroup, 512);
        GridData gdt = new GridData(1808);
        this.sqlTextArea.setLayoutData((Object)gdt);
        this.sqlTextArea.setEditable(false);
        this.sqlTextArea.setWordWrap(true);
        this.sqlTextArea.setBackground(sqlTextGroup.getBackground());
    }

    private void createPlanViewerGroup(Composite parent) {
        Group planViewerGroup = new Group(parent, 0);
        planViewerGroup.setText(Messages.getString("ExecutionPlanView.planViewerGroup"));
        planViewerGroup.setLayout((Layout)new GridLayout(1, false));
        GridData gd = new GridData(1808);
        planViewerGroup.setLayoutData((Object)gd);
        TabFolder tabFolder = new TabFolder((Composite)planViewerGroup, 128);
        tabFolder.setLayoutData((Object)new GridData(1808));
        this.createPlanHTMLTab(tabFolder);
        this.createPlanTreeTab(tabFolder);
        this.createPlanTextTab(tabFolder);
    }

    private void createPlanHTMLTab(TabFolder folderParent) {
        Composite tabPanel = this.createHTMLViewerPanel((Composite)folderParent);
        if (tabPanel == null) {
            return;
        }
        TabItem planHTMLTab = new TabItem(folderParent, 0);
        planHTMLTab.setControl((Control)tabPanel);
        planHTMLTab.setText(Messages.getString("ExecutionPlanView.planViewerHTMLTab.name"));
    }

    private void createPlanTextTab(TabFolder folderParent) {
        Composite tabPanel = this.createTextViewerPanel((Composite)folderParent);
        TabItem planTextTab = new TabItem(folderParent, 0);
        planTextTab.setControl((Control)tabPanel);
        planTextTab.setText(Messages.getString("ExecutionPlanView.planViewerTextTab.name"));
    }

    private void createPlanTreeTab(TabFolder folderParent) {
        Composite tabPanel = this.createTreeViewerPanel((Composite)folderParent);
        TabItem planTreeTab = new TabItem(folderParent, 0);
        planTreeTab.setControl((Control)tabPanel);
        planTreeTab.setText(Messages.getString("ExecutionPlanView.planViewerTreeTab.name"));
    }

    private Composite createHTMLViewerPanel(Composite parent) {
        try {
            this.visualisation = new Browser(parent, 0);
        }
        catch (Throwable ex) {
            Activator.log(ex);
        }
        return this.visualisation;
    }

    private Composite createTextViewerPanel(Composite parent) {
        Composite textViewerPanel = new Composite(parent, 0);
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 1;
        textViewerPanel.setLayout((Layout)gridLayout);
        textViewerPanel.setLayoutData((Object)new GridData(1808));
        this.planTextArea = new StyledText(textViewerPanel, 512);
        GridData gdt = new GridData(1808);
        this.planTextArea.setLayoutData((Object)gdt);
        this.planTextArea.setEditable(false);
        this.planTextArea.setWordWrap(true);
        return textViewerPanel;
    }

    private Composite createTreeViewerPanel(Composite parent) {
        Composite treeViewerPanel = new Composite(parent, 0);
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 1;
        treeViewerPanel.setLayout((Layout)gridLayout);
        treeViewerPanel.setLayoutData((Object)new GridData(1808));
        this.createTreeViewerButtonsPanel(treeViewerPanel);
        this.planTreeViewer = new TreeViewer(treeViewerPanel, 768);
        this.planTreeViewer.setContentProvider((IContentProvider)new PlanTreeContentProvider());
        this.planTreeViewer.setLabelProvider((IBaseLabelProvider)new LabelProvider(){

            public Image getImage(Object element) {
                return null;
            }

            public String getText(Object element) {
                return ExecutionPlanView.this.getNodeDisplayName((PlanElement)element);
            }
        });
        this.planTreeViewer.getControl().setLayoutData((Object)new GridData(1808));
        return treeViewerPanel;
    }

    private void createDescriptionPanel(Composite parent) {
        Composite descPanel = new Composite(parent, 0);
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 3;
        descPanel.setLayout((Layout)gridLayout);
        descPanel.setLayoutData((Object)new GridData(768));
        GridData gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.verticalAlignment = 1;
        gd.grabExcessHorizontalSpace = true;
        gd.horizontalSpan = 1;
        this.panelDescriptionLabel = new Label(descPanel, 0);
        this.panelDescriptionLabel.setLayoutData((Object)gd);
        this.panelDescriptionLabel.setText(Messages.getString("ExecutionPlanView.emptyPanelText"));
        this.panelPlansEnabledLabel = new Label(descPanel, 0);
        GridData gd2 = new GridData();
        gd2.horizontalAlignment = 3;
        gd2.verticalAlignment = 1;
        gd2.grabExcessHorizontalSpace = false;
        gd2.horizontalSpan = 1;
        this.panelPlansEnabledLabel.setLayoutData((Object)gd2);
        this.panelPlansEnabledLabel.setText(this.getPlansEnabledText());
        Button changeButton = new Button(descPanel, 8);
        GridData gd3 = new GridData();
        gd3.horizontalAlignment = 3;
        gd3.verticalAlignment = 1;
        gd3.grabExcessHorizontalSpace = false;
        gd3.horizontalSpan = 1;
        changeButton.setLayoutData((Object)gd3);
        changeButton.setText(Messages.getString("ExecutionPlanView.changePrefButton.text"));
        changeButton.setToolTipText(Messages.getString("ExecutionPlanView.changePrefButton.tooltip"));
        changeButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent theEvent) {
                IEclipsePreferences prefs;
                boolean currentSetting = (prefs = Activator.getDefault().getPreferences()).getBoolean("org.teiid.datatools.connectivity.ui.preferences.TeiidQueryPlansEnabled", true);
                prefs.putBoolean("org.teiid.datatools.connectivity.ui.preferences.TeiidQueryPlansEnabled", !currentSetting);
                try {
                    prefs.flush();
                }
                catch (BackingStoreException backingStoreException) {}
            }
        });
    }

    private void createTreeViewerButtonsPanel(Composite parent) {
        Composite buttonPanel = new Composite(parent, 0);
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 2;
        buttonPanel.setLayout((Layout)gridLayout);
        buttonPanel.setLayoutData((Object)new GridData(768));
        String expandAllButtonText = Messages.getString("ExecutionPlanView.expandAllButton.text");
        String expandAllButtonTooltip = Messages.getString("ExecutionPlanView.expandAllButton.tooltip");
        String collapseAllButtonText = Messages.getString("ExecutionPlanView.collapseAllButton.text");
        String collapseAllButtonTooltip = Messages.getString("ExecutionPlanView.collapseAllButton.tooltip");
        this.expandAll = new Button(buttonPanel, 8);
        this.expandAll.setText(expandAllButtonText);
        this.collapseAll = new Button(buttonPanel, 8);
        this.collapseAll.setText(collapseAllButtonText);
        this.expandAll.setToolTipText(expandAllButtonTooltip);
        this.expandAll.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent theEvent) {
                ExecutionPlanView.this.planTreeViewer.expandAll();
            }
        });
        this.collapseAll.setToolTipText(collapseAllButtonTooltip);
        this.collapseAll.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent theEvent) {
                ExecutionPlanView.this.planTreeViewer.collapseAll();
            }
        });
    }

    private String getNodeDisplayName(PlanElement element) {
        String displayName = null;
        String nodeName = element.getName();
        if ("node".equalsIgnoreCase(nodeName) || "property".equalsIgnoreCase(nodeName)) {
            displayName = element.getAttributeValue("name");
        } else if ("value".equalsIgnoreCase(nodeName)) {
            displayName = element.getValue();
        }
        return displayName;
    }

    private void handleSavePlanToFile() {
        block19: {
            Shell shell = Activator.getDefault().getWorkbench().getActiveWorkbenchWindow().getShell();
            FileDialog dlg = new FileDialog(shell, 8192);
            dlg.setFilterExtensions(new String[]{"*.*"});
            dlg.setText(Messages.getString("ExecutionPlanView.savePlanDialog.title"));
            dlg.setFileName(Messages.getString("ExecutionPlanView.savePlanDialog.defaultFileName"));
            String fileStr = dlg.open();
            if (fileStr != null && fileStr.indexOf(46) == -1) {
                fileStr = String.valueOf(fileStr) + "." + Messages.getString("ExecutionPlanView.savePlanDialog.defaultFileExt");
            }
            if (fileStr != null) {
                FileWriter fw = null;
                BufferedWriter out = null;
                PrintWriter pw = null;
                try {
                    try {
                        fw = new FileWriter(fileStr);
                        out = new BufferedWriter(fw);
                        pw = new PrintWriter(out);
                        pw.write(this.planString);
                    }
                    catch (Exception e) {
                        Status status = new Status(4, "org.teiid.datatools.connectivity.ui", Messages.getString("ExecutionPlanView.savePlanDialog.saveError"), (Throwable)e);
                        Activator.getDefault().getLog().log((IStatus)status);
                        pw.close();
                        try {
                            out.close();
                        }
                        catch (IOException iOException) {}
                        try {
                            fw.close();
                        }
                        catch (IOException iOException) {}
                        break block19;
                    }
                }
                catch (Throwable throwable) {
                    pw.close();
                    try {
                        out.close();
                    }
                    catch (IOException iOException) {}
                    try {
                        fw.close();
                    }
                    catch (IOException iOException) {}
                    throw throwable;
                }
                pw.close();
                try {
                    out.close();
                }
                catch (IOException iOException) {}
                try {
                    fw.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    private void handleReadPlanFromFile() {
        block25: {
            Shell shell = Activator.getDefault().getWorkbench().getActiveWorkbenchWindow().getShell();
            FileDialog dlg = new FileDialog(shell, 4096);
            dlg.setFilterExtensions(new String[]{"*.xml", "*.*"});
            dlg.setText(Messages.getString("ExecutionPlanView.importPlanDialog.title"));
            dlg.setFileName(Messages.getString("ExecutionPlanView.importPlanDialog.defaultFileName"));
            String fileStr = dlg.open();
            if (fileStr != null) {
                FileReader fr = null;
                BufferedReader in = null;
                try {
                    try {
                        String str;
                        fr = new FileReader(fileStr);
                        in = new BufferedReader(fr);
                        StringBuffer all = new StringBuffer();
                        while ((str = in.readLine()) != null) {
                            all.append(str);
                        }
                        String planText = all.toString();
                        String sqlStr = Messages.getString("ExecutionPlanView.readPlanFromFile.sql");
                        String descriptionStr = Messages.getString("ExecutionPlanView.readPlanFromFile.description");
                        this.updateContents(descriptionStr, sqlStr, planText);
                    }
                    catch (Exception e) {
                        Status status = new Status(4, "org.teiid.datatools.connectivity.ui", Messages.getString("ExecutionPlanView.importPlanDialog.error"), (Throwable)e);
                        Activator.getDefault().getLog().log((IStatus)status);
                        try {
                            if (fr != null) {
                                fr.close();
                            }
                        }
                        catch (IOException iOException) {}
                        try {
                            if (in != null) {
                                in.close();
                            }
                            break block25;
                        }
                        catch (IOException iOException) {}
                        break block25;
                    }
                }
                catch (Throwable throwable) {
                    try {
                        if (fr != null) {
                            fr.close();
                        }
                    }
                    catch (IOException iOException) {}
                    try {
                        if (in != null) {
                            in.close();
                        }
                    }
                    catch (IOException iOException) {}
                    throw throwable;
                }
                try {
                    if (fr != null) {
                        fr.close();
                    }
                }
                catch (IOException iOException) {}
                try {
                    if (in != null) {
                        in.close();
                    }
                }
                catch (IOException iOException) {}
            }
        }
    }

    private void displayNoExecPlanMessage() {
        if (this.visualisation == null) {
            return;
        }
        try {
            File noPlanFile = new File(ExecutionPlanConverter.TEMP_DIRECTORY, "NoExecutionPlan.html");
            if (!noPlanFile.exists()) {
                noPlanFile.createNewFile();
                PrintWriter writer = new PrintWriter(noPlanFile);
                writer.println("<html><body><div style=\"text-align:center; font-weight:bold; margin-top:4em;\">No Execution Plan Available</div></body></html>");
                writer.flush();
                writer.close();
            }
            noPlanFile.deleteOnExit();
            this.visualisation.setUrl(noPlanFile.toURI().toURL().toString());
        }
        catch (IOException ex) {
            Activator.log(ex);
        }
    }

    private void displayHTMLExecPlan(String execPlan) {
        if (this.visualisation == null) {
            return;
        }
        try {
            ExecutionPlanConverter converter = new ExecutionPlanConverter();
            String url = converter.convert(execPlan);
            this.visualisation.setUrl(url);
        }
        catch (Exception ex) {
            Activator.log(ex);
            this.displayNoExecPlanMessage();
        }
    }

    public void updateContents(String description, String sql, String planStr) {
        this.planString = planStr;
        if (description != null) {
            this.panelDescriptionLabel.setText(description);
        } else {
            this.panelDescriptionLabel.setText("");
        }
        if (sql != null) {
            this.sqlTextArea.setText(sql);
        } else {
            this.sqlTextArea.setText("");
        }
        if (planStr != null) {
            this.displayHTMLExecPlan(planStr);
        } else {
            this.displayNoExecPlanMessage();
        }
        if (planStr != null) {
            this.planTextArea.setText(planStr);
        } else {
            this.planTextArea.setText("");
        }
        ExecutionPlanParser planParser = new ExecutionPlanParser();
        if (planStr != null && !planStr.isEmpty()) {
            planParser.parse(planStr);
            ExecutionPlan executionPlan = planParser.getExecutionPlan();
            this.planTreeViewer.setInput((Object)executionPlan);
        } else {
            this.planTreeViewer.setInput(null);
        }
        this.planTreeViewer.refresh();
        this.planTreeViewer.expandToLevel(2);
        this.panelDescriptionLabel.pack();
        this.panelDescriptionLabel.getParent().layout();
        this.updateButtonEnablements();
    }

    private void updateButtonEnablements() {
        if (this.planString != null) {
            this.saveToFileAction.setEnabled(true);
            this.expandAll.setEnabled(true);
            this.collapseAll.setEnabled(true);
        } else {
            this.saveToFileAction.setEnabled(false);
            this.expandAll.setEnabled(false);
            this.collapseAll.setEnabled(false);
        }
    }

    public void preferenceChange(IEclipsePreferences.PreferenceChangeEvent event) {
        if (!this.panelPlansEnabledLabel.isDisposed()) {
            this.panelPlansEnabledLabel.setText(this.getPlansEnabledText());
            this.panelPlansEnabledLabel.getParent().layout();
        }
    }

    class PlanTreeContentProvider
    implements ITreeContentProvider {
        PlanTreeContentProvider() {
        }

        public void dispose() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }

        public Object getParent(Object element) {
            return ((PlanElement)element).getParent();
        }

        public Object[] getChildren(Object element) {
            if (element instanceof ExecutionPlan) {
                Object[] result = new Object[]{((ExecutionPlan)element).getRoot()};
                return result;
            }
            return ((PlanElement)element).getChildElements();
        }

        public Object[] getElements(Object inputElement) {
            return this.getChildren(inputElement);
        }

        public boolean hasChildren(Object element) {
            Object[] children = ((PlanElement)element).getChildElements();
            return children.length > 0;
        }
    }
}

