/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.sdt.types;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.xsd.XSDSimpleTypeDefinition;
import org.eclipse.xsd.XSDTypeDefinition;
import org.eclipse.xsd.XSDVariety;
import org.teiid.core.designer.ModelerCoreException;
import org.teiid.core.designer.id.IDGenerator;
import org.teiid.core.designer.id.ObjectID;
import org.teiid.core.designer.util.CoreArgCheck;
import org.teiid.designer.core.ModelerCore;
import org.teiid.designer.core.container.Container;
import org.teiid.designer.core.metamodel.aspect.AspectManager;
import org.teiid.designer.core.metamodel.aspect.sql.SqlAspect;
import org.teiid.designer.core.metamodel.aspect.sql.SqlDatatypeAspect;
import org.teiid.designer.core.types.DatatypeManager;
import org.teiid.designer.core.types.DatatypeManagerLifecycle;
import org.teiid.designer.core.workspace.ModelResource;
import org.teiid.designer.core.workspace.ModelUtil;
import org.teiid.designer.metamodels.xsd.aspects.sql.XsdSimpleTypeDefinitionAspect;
import org.teiid.designer.sdt.ModelerSdtPlugin;

public abstract class AbstractDatatypeManager
implements DatatypeManager,
DatatypeManagerLifecycle {
    private static SqlDatatypeAspect sqlDatatypeAspect;
    private static final Comparator TYPE_NAME_COMPARATOR;
    private ResourceSet container;

    static {
        TYPE_NAME_COMPARATOR = new DatatypeNameComparator();
    }

    public void initialize(ResourceSet container) throws ModelerCoreException {
        this.container = container;
        this.doInitialize();
    }

    protected abstract void doInitialize() throws ModelerCoreException;

    public ResourceSet getContainer() {
        return this.container;
    }

    protected static boolean containsUuidPattern(String id) {
        return id != null && id.indexOf("mmuuid") >= 0;
    }

    protected static String extractUuidString(String id) {
        if (AbstractDatatypeManager.containsUuidPattern(id)) {
            int beginIndex = id.indexOf("mmuuid");
            return id.substring(beginIndex);
        }
        return null;
    }

    protected static ObjectID getObjectIDFromString(String idString) throws ModelerCoreException {
        try {
            return IDGenerator.getInstance().stringToObject(idString);
        }
        catch (Throwable e) {
            throw new ModelerCoreException(e, ModelerSdtPlugin.Util.getString("DatatypeManagerImpl.Error_finding_the_EObject_with_UUID_11", (Object)idString));
        }
    }

    protected static void sortByName(List eObjs) {
        Collections.sort(eObjs, TYPE_NAME_COMPARATOR);
    }

    protected static SqlDatatypeAspect getSqlAspect(EObject eObject) {
        if (eObject != null && eObject instanceof XSDSimpleTypeDefinition) {
            if (ModelerCore.getPlugin() == null) {
                if (sqlDatatypeAspect == null) {
                    sqlDatatypeAspect = new XsdSimpleTypeDefinitionAspect(null);
                }
                return sqlDatatypeAspect;
            }
            SqlAspect sqlAspect = AspectManager.getSqlAspect((EObject)eObject);
            if (sqlAspect instanceof SqlDatatypeAspect) {
                return (SqlDatatypeAspect)sqlAspect;
            }
        }
        return null;
    }

    protected static void removeDuplicates(List eObjs) {
        ArrayList<EObject> tmp = new ArrayList<EObject>(eObjs.size());
        Iterator iter = eObjs.iterator();
        while (iter.hasNext()) {
            EObject eObj = (EObject)iter.next();
            if (!tmp.contains(eObj)) {
                tmp.add(eObj);
                continue;
            }
            iter.remove();
        }
    }

    protected List getDatatypeResources() {
        ResourceSet container = this.getContainer();
        if (container == null) {
            return Collections.EMPTY_LIST;
        }
        if (ModelerSdtPlugin.getDefault() != null && container instanceof Container && ModelerCore.isModelContainer((Container)((Container)container))) {
            ArrayList<Resource> lstResultResources = new ArrayList<Resource>();
            try {
                ModelResource[] mrResources = ModelerCore.getModelWorkspace().getModelResources();
                int i = 0;
                while (i < mrResources.length) {
                    Resource xsdResource;
                    ModelResource mrResource = mrResources[i];
                    IResource irResource = mrResource.getResource();
                    if (ModelUtil.isModelFile((IResource)irResource) && irResource.exists() && ModelUtil.isXsdFile((IResource)irResource) && (xsdResource = mrResource.getEmfResource()) != null) {
                        lstResultResources.add(xsdResource);
                    }
                    ++i;
                }
            }
            catch (CoreException ce) {
                ModelerCore.Util.log((Throwable)ce);
            }
            return lstResultResources;
        }
        EList resources = container.getResources();
        ArrayList<Resource> datatypeResources = new ArrayList<Resource>();
        for (Resource resource : resources) {
            if (!ModelUtil.isXsdFile((Resource)resource)) continue;
            datatypeResources.add(resource);
        }
        return datatypeResources;
    }

    public EObject[] getTypeHierarchy(EObject type) {
        CoreArgCheck.isInstanceOf(XSDSimpleTypeDefinition.class, (Object)type);
        if (((XSDSimpleTypeDefinition)type).getVariety() != XSDVariety.ATOMIC_LITERAL) {
            return new EObject[]{type};
        }
        ArrayList<EObject> tmp = new ArrayList<EObject>();
        tmp.add(type);
        try {
            EObject simpleType = type;
            while (simpleType != this.getAnySimpleType()) {
                EObject baseType = this.getBaseType(simpleType);
                if (baseType != null && baseType != this.getAnyType() && simpleType != baseType) {
                    tmp.add(baseType);
                    simpleType = baseType;
                    continue;
                }
                break;
            }
        }
        catch (ModelerCoreException e) {
            ModelerSdtPlugin.Util.log(4, (Throwable)e, e.getMessage());
        }
        return tmp.toArray(new EObject[tmp.size()]);
    }

    protected static class DatatypeNameComparator
    implements Comparator {
        protected DatatypeNameComparator() {
        }

        public int compare(Object obj1, Object obj2) {
            if (obj1 == null && obj2 == null) {
                return 0;
            }
            if (obj1 == null && obj2 != null) {
                return -1;
            }
            if (obj1 != null && obj2 == null) {
                return 1;
            }
            XSDTypeDefinition dt1 = (XSDTypeDefinition)obj1;
            XSDTypeDefinition dt2 = (XSDTypeDefinition)obj2;
            String value1 = dt1.getName();
            String value2 = dt2.getName();
            return value1.compareToIgnoreCase(value2);
        }
    }
}

