/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.bpel.validator.factory;

import java.util.HashMap;
import java.util.Locale;
import javax.xml.namespace.QName;
import org.eclipse.bpel.model.adapters.AdapterRegistry;
import org.eclipse.bpel.validator.Activator;
import org.eclipse.bpel.validator.helpers.DOMNodeAdapter;
import org.eclipse.bpel.validator.model.INode;
import org.eclipse.bpel.validator.model.IProblem;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IAdapterFactory;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.wst.validation.internal.provisional.core.IMessage;
import org.w3c.dom.Element;

public class AdapterFactory
implements IAdapterFactory {
    public static boolean DEBUG = false;
    Class<?>[] adapterList = new Class[]{IMarker.class, IResource.class, INode.class, IMessage.class};

    public Object getAdapter(Object adaptableObject, Class adapterType) {
        Object adapter;
        if (adaptableObject instanceof EObject && (adapter = AdapterRegistry.INSTANCE.adapt(adaptableObject, adapterType, false)) != null) {
            return adapter;
        }
        if (adapterType == IMarker.class) {
            if (adaptableObject instanceof IProblem) {
                return this.adapt_IProblem2IMarker((IProblem)adaptableObject);
            }
        } else if (adapterType == IResource.class) {
            if (adaptableObject instanceof EObject) {
                return this.adapt_EObject2IResource((EObject)adaptableObject);
            }
            if (adaptableObject instanceof Element) {
                return this.adapt_Element2IResource((Element)adaptableObject);
            }
        } else if (adapterType == INode.class) {
            if (adaptableObject instanceof Element) {
                Element elm = (Element)adaptableObject;
                Object adapter2 = elm.getUserData(DOMNodeAdapter.KEY);
                if (adapter2 instanceof DOMNodeAdapter) {
                    return adapterType.cast(adapter2);
                }
                adapter2 = new DOMNodeAdapter(elm);
                elm.setUserData(DOMNodeAdapter.KEY, adapter2, null);
                return adapterType.cast(adapter2);
            }
        } else if (adapterType == IMessage.class && adaptableObject instanceof IProblem) {
            return this.adapt_IProblem2IMessage((IProblem)adaptableObject);
        }
        return null;
    }

    IResource adapt_EObject2IResource(EObject eObj) {
        if (eObj == null) {
            return null;
        }
        Resource r = eObj.eResource();
        if (r == null) {
            return null;
        }
        if (r.getURI() == null) {
            return null;
        }
        return this.getFileFromURI(r.getURI());
    }

    IResource adapt_Element2IResource(Element elm) {
        Element top = elm.getOwnerDocument().getDocumentElement();
        IResource result = null;
        if (top != null) {
            EObject eObj = (EObject)top.getUserData("emf.model");
            if (eObj == null) {
                eObj = (EObject)elm.getUserData("emf.model");
            }
            result = this.adapt_EObject2IResource(eObj);
        }
        return result;
    }

    IMarker adapt_IProblem2IMarker(IProblem problem) {
        IResource resource = null;
        INode node = (INode)problem.getAttribute("node");
        if (node != null) {
            resource = (IResource)this.getAdapter(node.nodeValue(), IResource.class);
        } else {
            Resource modelResource = (Resource)problem.getAttribute("eResource");
            resource = this.getFileFromURI(modelResource.getURI());
        }
        HashMap<String, Object> props = new HashMap<String, Object>();
        String msg = (String)problem.getAttribute("message");
        String rule = (String)problem.getAttribute("ruleName");
        if (rule != null) {
            props.put("bpel.validation.rule", rule);
        }
        if (DEBUG) {
            StringBuilder emsg = new StringBuilder(msg);
            Throwable t = (Throwable)problem.getAttribute("exception");
            if (rule != null || t != null) {
                emsg.append("(DEBUG: ");
                if (rule != null) {
                    emsg.append("rule=" + rule);
                }
                if (t != null) {
                    if (rule != null) {
                        emsg.append("; ");
                    }
                    emsg.append("stack=");
                    int count = 0;
                    StackTraceElement[] stackTraceElementArray = t.getStackTrace();
                    int n = stackTraceElementArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        StackTraceElement e = stackTraceElementArray[n2];
                        emsg.append("[" + count + "]");
                        emsg.append(String.valueOf(e.getClassName()) + ".");
                        emsg.append(String.valueOf(e.getMethodName()) + "@" + e.getLineNumber());
                        if (++count > 2) break;
                        emsg.append("/");
                        ++n2;
                    }
                }
                emsg.append(")");
            }
            props.put("message", emsg.toString());
        } else {
            props.put("message", msg);
        }
        int lineNo = problem.getAttribute("lineNumber", -1);
        props.put("lineNumber", lineNo);
        props.put("charEnd", problem.getAttribute("charEnd", -1));
        props.put("charStart", problem.getAttribute("charStart", -1));
        if (lineNo < 0) {
            props.put("location", problem.getAttribute("location"));
        }
        switch (problem.getAttribute("severity", 2)) {
            case 1: {
                props.put("severity", 1);
                break;
            }
            case 0: {
                props.put("severity", 0);
                break;
            }
            default: {
                props.put("severity", 2);
            }
        }
        props.put("address.model", problem.getAttribute("address.model"));
        props.put("address.xpath", problem.getAttribute("address.xpath"));
        Object context = problem.getAttribute("context.name");
        if (context instanceof QName) {
            QName qname = (QName)context;
            props.put("href.context", qname.getLocalPart());
        } else {
            props.put("href.context", problem.getAttribute("context.name"));
        }
        IMarker marker = null;
        try {
            marker = resource.createMarker("org.eclispe.bpel.validator.marker");
            marker.setAttributes(props);
        }
        catch (Exception ex) {
            Activator.log(ex);
            return null;
        }
        return marker;
    }

    IMessage adapt_IProblem2IMessage(IProblem problem) {
        return new Message(problem);
    }

    public Class<?>[] getAdapterList() {
        return this.adapterList;
    }

    IFile getFileFromURI(URI uri) {
        if (uri != null) {
            if (uri.isFile()) {
                return this.getFileFromDeviceURI(uri);
            }
            return this.getFileFromPlatformURI(uri);
        }
        return null;
    }

    IFile getFileFromDeviceURI(URI uri) {
        String device = uri.device();
        StringBuilder path = new StringBuilder();
        String[] stringArray = uri.segments();
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String segment = stringArray[n2];
            path.append("/").append(segment);
            ++n2;
        }
        return ResourcesPlugin.getWorkspace().getRoot().getFileForLocation((IPath)new Path(device, path.toString()));
    }

    IFile getFileFromPlatformURI(URI uri) {
        String[] segs = uri.segments();
        Object path = null;
        int i = 1;
        while (i < segs.length) {
            path = path == null ? new Path(segs[i]) : path.append(segs[i]);
            ++i;
        }
        return ResourcesPlugin.getWorkspace().getRoot().getFile(path);
    }

    static class Message
    implements IMessage {
        static String GENERAL = "general";
        IProblem fProblem;
        protected String fMarkerId;

        Message(IProblem problem) {
            this.fProblem = problem;
        }

        public Object getAttribute(String attributeName) {
            return this.fProblem.getAttribute(attributeName);
        }

        public HashMap getAttributes() {
            return (HashMap)this.fProblem.getAttributes();
        }

        public String getBundleName() {
            return (String)this.fProblem.getAttribute("bundleName");
        }

        public String getGroupName() {
            return GENERAL;
        }

        public String getId() {
            return (String)this.fProblem.getAttribute("message.id");
        }

        public int getLength() {
            int offset = (Integer)this.fProblem.getAttribute("charStart");
            int offsetEnd = (Integer)this.fProblem.getAttribute("charEnd");
            int length = offsetEnd - offset + 1;
            if (length < 0) {
                return -1;
            }
            return length;
        }

        public int getLineNumber() {
            return (Integer)this.fProblem.getAttribute("lineNumber");
        }

        public String getMarkerId() {
            return this.fMarkerId;
        }

        public int getOffset() {
            int offset = (Integer)this.fProblem.getAttribute("charStart");
            if (offset < 0) {
                return -1;
            }
            return offset;
        }

        public String[] getParams() {
            return (String[])this.fProblem.getAttribute("message.args");
        }

        public int getSeverity() {
            int severity = (Integer)this.fProblem.getAttribute("severity");
            switch (severity) {
                case 2: {
                    return 1;
                }
                case 0: 
                case 1: {
                    return 4;
                }
            }
            return 4;
        }

        public Object getTargetObject() {
            INode node = (INode)this.fProblem.getAttribute("node");
            if (node == null) {
                return null;
            }
            return node;
        }

        public String getText() {
            return (String)this.fProblem.getAttribute("message");
        }

        public String getText(ClassLoader classLoader) {
            return (String)this.fProblem.getAttribute("message");
        }

        public String getText(Locale locale) {
            return (String)this.fProblem.getAttribute("message");
        }

        public String getText(Locale locale, ClassLoader classLoader) {
            return (String)this.fProblem.getAttribute("message");
        }

        public void setAttribute(String attributeName, Object value) {
        }

        public void setBundleName(String bundleName) {
        }

        public void setGroupName(String name) {
        }

        public void setId(String newId) {
        }

        public void setLength(int length) {
        }

        public void setLineNo(int lineNumber) {
        }

        public void setMarkerId(String markerId) {
            this.fMarkerId = markerId;
        }

        public void setOffset(int offset) {
        }

        public void setParams(String[] newParams) {
        }

        public void setSeverity(int newSeverity) {
        }

        public void setTargetObject(Object obj) {
        }
    }
}

