/*
 * Decompiled with CFR 0.152.
 */
package org.guvnor.tools;

import java.net.MalformedURLException;
import java.net.URL;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.ImageRegistry;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.guvnor.tools.GuvnorLocationManager;
import org.guvnor.tools.Messages;
import org.guvnor.tools.ResourceChangeListener;
import org.osgi.framework.BundleContext;

public class Activator
extends AbstractUIPlugin {
    public static final String PLUGIN_ID = "org.drools.guvnor";
    private static Activator plugin;
    private static GuvnorLocationManager locManager;
    private ResourceChangeListener rcListner = new ResourceChangeListener();
    public static final String IMG_GUVCONTROLLED = "guvnor_controlled.gif";
    public static final String IMG_GUVLOCADD = "guvnor_rep_add.gif";
    public static final String IMG_GUVREPWIZBAN = "guvnor_rep_wizban.gif";
    public static final String IMG_GUVREP = "guvnor_rep.gif";
    public static final String IMG_GUVPACK = "package.gif";
    public static final String IMG_GUVFOLDER = "chart_organisation.gif";
    public static final String IMG_GUVSNAPPACK = "snapshot_small.gif";
    public static final String IMG_GUVSNAPSHOT = "details.gif";

    public static GuvnorLocationManager getLocationManager() {
        if (locManager == null) {
            locManager = new GuvnorLocationManager();
        }
        return locManager;
    }

    public void start(BundleContext context) throws Exception {
        super.start(context);
        plugin = this;
        this.getWorkspace().addResourceChangeListener((IResourceChangeListener)this.rcListner);
    }

    public void stop(BundleContext context) throws Exception {
        plugin = null;
        super.stop(context);
        this.getWorkspace().removeResourceChangeListener((IResourceChangeListener)this.rcListner);
    }

    public static Activator getDefault() {
        return plugin;
    }

    public IWorkspace getWorkspace() {
        return ResourcesPlugin.getWorkspace();
    }

    private IStatus createStatus(int severity, String msg, Throwable t) {
        return new Status(severity, PLUGIN_ID, msg, t);
    }

    public void writeLog(int severity, String msg, Throwable t) {
        super.getLog().log(this.createStatus(severity, msg, t));
    }

    public void writeLog(IStatus status) {
        super.getLog().log(status);
    }

    public void displayMessage(final int severity, final String msg) {
        final Display display = PlatformUI.getWorkbench().getDisplay();
        display.syncExec(new Runnable(){

            @Override
            public void run() {
                switch (severity) {
                    case 4: {
                        MessageDialog.openError((Shell)display.getActiveShell(), (String)Messages.getString("error"), (String)msg);
                        break;
                    }
                    case 2: {
                        MessageDialog.openWarning((Shell)display.getActiveShell(), (String)Messages.getString("warning"), (String)msg);
                    }
                }
            }
        });
    }

    public void displayError(int severity, String msg, Throwable t, boolean shouldLog) {
        final IStatus status = this.createStatus(severity, msg, t);
        if (shouldLog) {
            this.writeLog(status);
        }
        final Display display = PlatformUI.getWorkbench().getDisplay();
        display.syncExec(new Runnable(){

            @Override
            public void run() {
                ErrorDialog.openError((Shell)display.getActiveShell(), null, (String)Messages.getString("error"), (IStatus)status);
            }
        });
    }

    protected void initializeImageRegistry(ImageRegistry reg) {
        super.initializeImageRegistry(reg);
        reg.put(IMG_GUVCONTROLLED, Activator.loadImageDescriptor(IMG_GUVCONTROLLED));
        reg.put(IMG_GUVLOCADD, Activator.loadImageDescriptor(IMG_GUVLOCADD));
        reg.put(IMG_GUVCONTROLLED, Activator.loadImageDescriptor(IMG_GUVREPWIZBAN));
        reg.put(IMG_GUVREP, Activator.loadImageDescriptor(IMG_GUVREP));
        reg.put(IMG_GUVPACK, Activator.loadImageDescriptor(IMG_GUVPACK));
        reg.put(IMG_GUVFOLDER, Activator.loadImageDescriptor(IMG_GUVFOLDER));
        reg.put(IMG_GUVSNAPPACK, Activator.loadImageDescriptor(IMG_GUVSNAPPACK));
        reg.put(IMG_GUVSNAPSHOT, Activator.loadImageDescriptor(IMG_GUVSNAPSHOT));
    }

    public static ImageDescriptor getImageDescriptor(String id) {
        ImageDescriptor retVal = Activator.getDefault().getImageRegistry().getDescriptor(id);
        if (retVal == null) {
            retVal = Activator.loadImageDescriptor(id);
            Activator.getDefault().getImageRegistry().put(id, retVal);
        }
        return retVal;
    }

    private static ImageDescriptor loadImageDescriptor(String id) {
        String iconPath = "icons/";
        try {
            URL installURL = Activator.getDefault().getBundle().getEntry("/");
            URL url = new URL(installURL, String.valueOf(iconPath) + id);
            return ImageDescriptor.createFromURL((URL)url);
        }
        catch (MalformedURLException malformedURLException) {
            return ImageDescriptor.getMissingImageDescriptor();
        }
    }

    public boolean useDebugHttpClient() {
        return Boolean.parseBoolean(Platform.getDebugOption((String)"org.guvnor.tools/debugHttpClient"));
    }
}

