/*
 * Decompiled with CFR 0.152.
 */
package org.fusesource.ide.branding.wizards.project;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jface.dialogs.DialogSettings;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Combo;
import org.fusesource.ide.branding.Activator;
import org.fusesource.ide.branding.wizards.WizardMessages;

public abstract class AbstractFuseWizardPage
extends WizardPage {
    protected static final int MAX_HISTORY = 15;
    protected IDialogSettings dialogSettings;
    private Map<String, List<Combo>> fieldsWithHistory = new HashMap<String, List<Combo>>();
    private boolean isHistoryLoaded = false;

    protected AbstractFuseWizardPage(String pageName) {
        super(pageName);
        this.initDialogSettings();
    }

    public void setVisible(boolean visible) {
        if (visible) {
            if (!this.isHistoryLoaded) {
                this.loadInputHistory();
                this.isHistoryLoaded = true;
            } else {
                this.saveInputHistory();
            }
        }
        super.setVisible(visible);
    }

    public void dispose() {
        this.saveInputHistory();
        super.dispose();
    }

    private void initDialogSettings() {
        Object pluginSettings = Activator.getDefault() == null ? new DialogSettings("Workbench") : Activator.getDefault().getDialogSettings();
        this.dialogSettings = pluginSettings.getSection(this.getName());
        if (this.dialogSettings == null) {
            this.dialogSettings = pluginSettings.addNewSection(this.getName());
            pluginSettings.addSection(this.dialogSettings);
        }
    }

    private void loadInputHistory() {
        for (Map.Entry<String, List<Combo>> e : this.fieldsWithHistory.entrySet()) {
            String id = e.getKey();
            String[] items = this.dialogSettings.getArray(id);
            if (items == null) continue;
            for (Combo combo : e.getValue()) {
                String text = combo.getText();
                combo.setItems(items);
                if (text.length() <= 0) continue;
                combo.setText(text);
            }
        }
    }

    private void saveInputHistory() {
        for (Map.Entry<String, List<Combo>> e : this.fieldsWithHistory.entrySet()) {
            Combo combo2;
            String id = e.getKey();
            LinkedHashSet<String> history = new LinkedHashSet<String>(15);
            for (Combo combo2 : e.getValue()) {
                String lastValue = combo2.getText();
                if (lastValue == null || lastValue.trim().length() <= 0) continue;
                history.add(lastValue);
            }
            combo2 = e.getValue().iterator().next();
            String[] items = combo2.getItems();
            int j = 0;
            while (j < items.length && history.size() < 15) {
                history.add(items[j]);
                ++j;
            }
            this.dialogSettings.put(id, history.toArray(new String[history.size()]));
        }
    }

    protected void addFieldWithHistory(String id, Combo combo) {
        if (combo != null) {
            List<Combo> combos = this.fieldsWithHistory.get(id);
            if (combos == null) {
                combos = new ArrayList<Combo>();
                this.fieldsWithHistory.put(id, combos);
            }
            combos.add(combo);
        }
    }

    protected String validateArtifactIdInput(String text) {
        return this.validateIdInput(text, true);
    }

    protected String validateGroupIdInput(String text) {
        return this.validateIdInput(text, false);
    }

    private String validateIdInput(String text, boolean artifact) {
        if (text == null || text.length() == 0) {
            return artifact ? WizardMessages.wizardProjectPageMaven2ValidatorArtifactID : WizardMessages.wizardProjectPageMaven2ValidatorGroupID;
        }
        if (text.contains(" ")) {
            return artifact ? WizardMessages.wizardProjectPageMaven2ValidatorArtifactIDnospaces : WizardMessages.wizardProjectPageMaven2ValidatorGroupIDnospaces;
        }
        IStatus nameStatus = ResourcesPlugin.getWorkspace().validateName(text, 4);
        if (!nameStatus.isOK()) {
            return NLS.bind((String)(artifact ? WizardMessages.wizardProjectPageMaven2ValidatorArtifactIDinvalid : WizardMessages.wizardProjectPageMaven2ValidatorGroupIDinvalid), (Object)nameStatus.getMessage());
        }
        if (!text.matches("[A-Za-z0-9_\\-.]+")) {
            return NLS.bind((String)(artifact ? WizardMessages.wizardProjectPageMaven2ValidatorArtifactIDinvalid : WizardMessages.wizardProjectPageMaven2ValidatorGroupIDinvalid), (Object)text);
        }
        return null;
    }
}

