/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.bpmn2.modeler.runtime.jboss.jbpm5.util;

import java.util.Hashtable;
import java.util.List;
import org.eclipse.bpmn2.BaseElement;
import org.eclipse.bpmn2.CatchEvent;
import org.eclipse.bpmn2.Definitions;
import org.eclipse.bpmn2.ExtensionAttributeValue;
import org.eclipse.bpmn2.Import;
import org.eclipse.bpmn2.Interface;
import org.eclipse.bpmn2.ItemDefinition;
import org.eclipse.bpmn2.ItemKind;
import org.eclipse.bpmn2.Process;
import org.eclipse.bpmn2.Property;
import org.eclipse.bpmn2.Relationship;
import org.eclipse.bpmn2.SequenceFlow;
import org.eclipse.bpmn2.Task;
import org.eclipse.bpmn2.ThrowEvent;
import org.eclipse.bpmn2.UserTask;
import org.eclipse.bpmn2.modeler.core.adapters.ExtendedPropertiesProvider;
import org.eclipse.bpmn2.modeler.core.adapters.ObjectPropertyProvider;
import org.eclipse.bpmn2.modeler.core.model.Bpmn2ModelerFactory;
import org.eclipse.bpmn2.modeler.core.model.ModelDecorator;
import org.eclipse.bpmn2.modeler.core.utils.ImportUtil;
import org.eclipse.bpmn2.modeler.core.utils.ModelUtil;
import org.eclipse.bpmn2.modeler.runtime.jboss.jbpm5.drools.process.core.datatype.DataType;
import org.eclipse.bpmn2.modeler.runtime.jboss.jbpm5.model.bpsim.BPSimDataType;
import org.eclipse.bpmn2.modeler.runtime.jboss.jbpm5.model.bpsim.BpsimFactory;
import org.eclipse.bpmn2.modeler.runtime.jboss.jbpm5.model.bpsim.BpsimPackage;
import org.eclipse.bpmn2.modeler.runtime.jboss.jbpm5.model.bpsim.ControlParameters;
import org.eclipse.bpmn2.modeler.runtime.jboss.jbpm5.model.bpsim.CostParameters;
import org.eclipse.bpmn2.modeler.runtime.jboss.jbpm5.model.bpsim.DistributionParameter;
import org.eclipse.bpmn2.modeler.runtime.jboss.jbpm5.model.bpsim.ElementParameters;
import org.eclipse.bpmn2.modeler.runtime.jboss.jbpm5.model.bpsim.FloatingParameterType;
import org.eclipse.bpmn2.modeler.runtime.jboss.jbpm5.model.bpsim.NormalDistributionType;
import org.eclipse.bpmn2.modeler.runtime.jboss.jbpm5.model.bpsim.Parameter;
import org.eclipse.bpmn2.modeler.runtime.jboss.jbpm5.model.bpsim.PoissonDistributionType;
import org.eclipse.bpmn2.modeler.runtime.jboss.jbpm5.model.bpsim.ResourceParameters;
import org.eclipse.bpmn2.modeler.runtime.jboss.jbpm5.model.bpsim.Scenario;
import org.eclipse.bpmn2.modeler.runtime.jboss.jbpm5.model.bpsim.ScenarioParameters;
import org.eclipse.bpmn2.modeler.runtime.jboss.jbpm5.model.bpsim.TimeParameters;
import org.eclipse.bpmn2.modeler.runtime.jboss.jbpm5.model.bpsim.TimeUnit;
import org.eclipse.bpmn2.modeler.runtime.jboss.jbpm5.model.bpsim.UniformDistributionType;
import org.eclipse.bpmn2.modeler.runtime.jboss.jbpm5.model.drools.DroolsFactory;
import org.eclipse.bpmn2.modeler.runtime.jboss.jbpm5.model.drools.DroolsPackage;
import org.eclipse.bpmn2.modeler.runtime.jboss.jbpm5.model.drools.GlobalType;
import org.eclipse.bpmn2.modeler.runtime.jboss.jbpm5.model.drools.ImportType;
import org.eclipse.bpmn2.modeler.runtime.jboss.jbpm5.util.Messages;
import org.eclipse.bpmn2.modeler.ui.adapters.properties.ItemDefinitionPropertiesAdapter;
import org.eclipse.bpmn2.modeler.ui.property.dialogs.DefaultSchemaImportDialog;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.util.FeatureMap;
import org.eclipse.emf.transaction.RecordingCommand;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.IType;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;

public class JbpmModelUtil {
    public static IType showImportDialog(EObject object) {
        Object[] result;
        Shell shell = Display.getDefault().getActiveShell();
        DefaultSchemaImportDialog dialog = new DefaultSchemaImportDialog(shell, 8);
        if (dialog.open() == 0 && (result = dialog.getResult()).length == 1 && result[0] instanceof IType) {
            return (IType)result[0];
        }
        return null;
    }

    public static ImportType addImport(IType type, EObject object) {
        return JbpmModelUtil.addImport(type, object, true, false);
    }

    public static ImportType addImport(final IType type, final EObject object, final boolean recursive, final boolean createVariables) {
        if (type == null) {
            return null;
        }
        final Definitions definitions = ModelUtil.getDefinitions((Object)object);
        if (definitions == null) {
            return null;
        }
        Process process = null;
        if (object instanceof Process) {
            process = (Process)object;
        } else {
            process = (Process)ModelUtil.findNearestAncestor((EObject)object, (Class[])new Class[]{Process.class});
            if (process == null) {
                List processes = ModelUtil.getAllRootElements((Definitions)definitions, Process.class);
                if (processes.size() > 1) {
                    process = (Process)processes.get(0);
                } else if (processes.size() == 1) {
                    process = (Process)processes.get(0);
                } else {
                    if (recursive) {
                        Shell shell = Display.getDefault().getActiveShell();
                        MessageDialog.openError((Shell)shell, (String)Messages.JbpmModelUtil_No_Process_Title, (String)Messages.JbpmModelUtil_No_Process_Message);
                    }
                    return null;
                }
            }
        }
        final String className = type.getFullyQualifiedName('.');
        List allImports = ModelDecorator.getAllExtensionAttributeValues((EObject)process, ImportType.class);
        for (ImportType it : allImports) {
            if (!className.equals(it.getName())) continue;
            if (recursive) {
                Shell shell = Display.getDefault().getActiveShell();
                MessageDialog.openWarning((Shell)shell, (String)Messages.JbpmModelUtil_Duplicate_Import_Title, (String)NLS.bind((String)Messages.JbpmModelUtil_Duplicate_Import_Message, (Object)className));
            }
            return null;
        }
        final Process fProcess = process;
        final ImportType newImport = (ImportType)DroolsFactory.eINSTANCE.create(DroolsPackage.eINSTANCE.getImportType());
        newImport.setName(className);
        TransactionalEditingDomain domain = ModelUtil.getEditor((EObject)object).getEditingDomain();
        domain.getCommandStack().execute((Command)new RecordingCommand(domain){

            protected void doExecute() {
                ImportHandler importer = new ImportHandler();
                importer.setCreateVariables(createVariables);
                ModelDecorator.addExtensionAttributeValue((EObject)fProcess, (EStructuralFeature)DroolsPackage.eINSTANCE.getDocumentRoot_ImportType(), (Object)newImport);
                if (recursive) {
                    if (object instanceof ItemDefinition) {
                        ItemDefinition oldItemDef = (ItemDefinition)object;
                        oldItemDef.setItemKind(ItemKind.INFORMATION);
                        EObject structureRef = ModelUtil.createStringWrapper((String)className);
                        oldItemDef.setStructureRef((Object)structureRef);
                    } else {
                        importer.createItemDefinition(definitions, null, type);
                    }
                }
            }
        });
        return newImport;
    }

    public static void removeImport(ImportType importType) {
        Definitions definitions = ModelUtil.getDefinitions((Object)importType);
        Import imp = (Import)Bpmn2ModelerFactory.create(Import.class);
        imp.setImportType("http://www.java.com/javaTypes");
        imp.setLocation(importType.getName());
        definitions.getImports().add(imp);
        ImportHandler.removeImport((Import)imp);
    }

    public static Hashtable<String, Object> getChoiceOfValues(EObject object) {
        return ItemDefinitionPropertiesAdapter.getChoiceOfValues((EObject)object);
    }

    public static String getDataType(Object value) {
        String stringValue = null;
        if (value instanceof String) {
            stringValue = (String)value;
        } else if (value instanceof GlobalType) {
            stringValue = ((GlobalType)value).getType();
        } else if (value instanceof DataType) {
            stringValue = ((DataType)value).getStringType();
        } else if (value instanceof ImportType) {
            stringValue = ((ImportType)value).getName();
        } else if (value instanceof ItemDefinition) {
            stringValue = ExtendedPropertiesProvider.getTextValue((EObject)((ItemDefinition)value));
        }
        return stringValue;
    }

    public static ItemDefinition getDataType(EObject context, Object value) {
        ItemDefinition itemDef = null;
        if (value instanceof String) {
            itemDef = JbpmModelUtil.findOrCreateItemDefinition(context, (String)value);
        } else if (value instanceof GlobalType) {
            itemDef = JbpmModelUtil.findOrCreateItemDefinition(context, ((GlobalType)value).getType());
        } else if (value instanceof DataType) {
            itemDef = JbpmModelUtil.findOrCreateItemDefinition(context, ((DataType)value).getStringType());
        } else if (value instanceof ImportType) {
            itemDef = JbpmModelUtil.findOrCreateItemDefinition(context, ((ImportType)value).getName());
        } else if (value instanceof ItemDefinition) {
            itemDef = (ItemDefinition)value;
        }
        return itemDef;
    }

    public static ItemDefinition findOrCreateItemDefinition(EObject context, String structureRef) {
        ItemDefinition itemDef = null;
        Resource resource = ObjectPropertyProvider.getResource((EObject)context);
        Definitions definitions = ModelUtil.getDefinitions((Object)resource);
        List itemDefs = ModelUtil.getAllRootElements((Definitions)definitions, ItemDefinition.class);
        for (ItemDefinition id : itemDefs) {
            String s = ModelUtil.getStringWrapperTextValue((Object)id.getStructureRef());
            if (s == null || !s.equals(structureRef)) continue;
            itemDef = id;
            break;
        }
        if (itemDef == null) {
            itemDef = (ItemDefinition)Bpmn2ModelerFactory.create((Resource)resource, ItemDefinition.class);
            itemDef.setStructureRef((Object)ModelUtil.createStringWrapper((String)structureRef));
            itemDef.setItemKind(ItemKind.INFORMATION);
            ModelUtil.setID((EObject)itemDef);
        }
        return itemDef;
    }

    public static BPSimDataType getBPSimData(EObject object) {
        BPSimDataType processAnalysisData = null;
        Relationship rel = null;
        Resource resource = ObjectPropertyProvider.getResource((EObject)object);
        Definitions definitions = ModelUtil.getDefinitions((Object)object);
        List relationships = definitions.getRelationships();
        if (relationships.size() == 0) {
            rel = (Relationship)Bpmn2ModelerFactory.create((Resource)resource, Relationship.class);
            definitions.getRelationships().add(rel);
            rel.getSources().add(definitions);
            rel.getTargets().add(definitions);
            rel.setType(Messages.JbpmModelUtil_Simulation);
            ModelUtil.setID((EObject)rel);
        } else {
            rel = (Relationship)relationships.get(0);
        }
        block0: for (ExtensionAttributeValue v : ModelDecorator.getExtensionAttributeValues((EObject)rel)) {
            for (FeatureMap.Entry entry : v.getValue()) {
                if (!(entry.getValue() instanceof BPSimDataType)) continue;
                processAnalysisData = (BPSimDataType)entry.getValue();
                continue block0;
            }
        }
        if (processAnalysisData == null) {
            processAnalysisData = BpsimFactory.eINSTANCE.createBPSimDataType();
            ModelDecorator.addExtensionAttributeValue((EObject)rel, (EStructuralFeature)BpsimPackage.eINSTANCE.getDocumentRoot_BPSimData(), (Object)processAnalysisData);
        }
        if (processAnalysisData.getScenario().size() == 0) {
            Scenario scenario = BpsimFactory.eINSTANCE.createScenario();
            ModelUtil.setID((EObject)scenario, (Resource)resource);
            scenario.setName(Messages.JbpmModelUtil_Scenario_Name);
            ScenarioParameters scenarioParams = BpsimFactory.eINSTANCE.createScenarioParameters();
            scenarioParams.setBaseTimeUnit(TimeUnit.MS);
            scenario.setScenarioParameters(scenarioParams);
            processAnalysisData.getScenario().add((Object)scenario);
        }
        return processAnalysisData;
    }

    public static ElementParameters getElementParameters(BaseElement be) {
        ElementParameters elementParams = null;
        Resource resource = be.eResource();
        BPSimDataType processAnalysisData = JbpmModelUtil.getBPSimData((EObject)be);
        Scenario scenario = (Scenario)processAnalysisData.getScenario().get(0);
        String id = be.getId();
        for (ElementParameters ep : scenario.getElementParameters()) {
            if (!id.equals(ep.getElementRef())) continue;
            elementParams = ep;
            break;
        }
        if (elementParams == null) {
            TimeParameters timeParams;
            elementParams = BpsimFactory.eINSTANCE.createElementParameters();
            elementParams.setElementRef(id);
            ModelUtil.setID((EObject)elementParams, (Resource)resource);
            if (be instanceof Task) {
                timeParams = JbpmModelUtil.createTimeParameters(DistributionType.Uniform, 0.0, 1.0, TimeUnit.S);
                elementParams.setTimeParameters(timeParams);
                CostParameters costParams = BpsimFactory.eINSTANCE.createCostParameters();
                costParams.setUnitCost(JbpmModelUtil.createParameter(0L));
                elementParams.setCostParameters(costParams);
            }
            if (be instanceof UserTask) {
                ResourceParameters resourceParams = BpsimFactory.eINSTANCE.createResourceParameters();
                resourceParams.setQuantity(JbpmModelUtil.createParameter(0.0));
                resourceParams.setAvailability(JbpmModelUtil.createParameter(0.0));
                elementParams.setResourceParameters(resourceParams);
            } else if (be instanceof CatchEvent) {
                timeParams = JbpmModelUtil.createTimeParameters(1.0, TimeUnit.S);
                elementParams.setTimeParameters(timeParams);
            } else if (be instanceof ThrowEvent) {
                timeParams = JbpmModelUtil.createTimeParameters(DistributionType.Uniform, 0.0, 1.0, TimeUnit.S);
                elementParams.setTimeParameters(timeParams);
            } else if (be instanceof SequenceFlow) {
                ControlParameters controlParams = BpsimFactory.eINSTANCE.createControlParameters();
                controlParams.setProbability(JbpmModelUtil.createParameter(100.0));
                elementParams.setControlParameters(controlParams);
            }
            scenario.getElementParameters().add((Object)elementParams);
        }
        return elementParams;
    }

    public static Parameter createParameter(double f) {
        Parameter param = BpsimFactory.eINSTANCE.createParameter();
        FloatingParameterType value = BpsimFactory.eINSTANCE.createFloatingParameterType();
        value.setValue(f);
        param.getParameterValue().add((Object)value);
        return param;
    }

    public static Parameter createParameter(long i) {
        Parameter param = BpsimFactory.eINSTANCE.createParameter();
        FloatingParameterType value = BpsimFactory.eINSTANCE.createFloatingParameterType();
        value.setValue(i);
        param.getParameterValue().add((Object)value);
        return param;
    }

    public static Parameter createParameter(DistributionType distType, double v1, double v2) {
        Parameter param = BpsimFactory.eINSTANCE.createParameter();
        DistributionParameter value = null;
        switch (distType) {
            case Uniform: {
                value = BpsimFactory.eINSTANCE.createUniformDistributionType();
                value.setMin(v1);
                ((UniformDistributionType)value).setMax(v2);
                break;
            }
            case Normal: {
                value = BpsimFactory.eINSTANCE.createNormalDistributionType();
                ((NormalDistributionType)value).setMean(v1);
                ((NormalDistributionType)value).setStandardDeviation(v2);
                break;
            }
            case Poisson: {
                value = BpsimFactory.eINSTANCE.createPoissonDistributionType();
                ((PoissonDistributionType)value).setMean(v1);
            }
        }
        param.getParameterValue().add((Object)value);
        return param;
    }

    public static TimeParameters createTimeParameters(double t, TimeUnit tu) {
        TimeParameters timeParams = BpsimFactory.eINSTANCE.createTimeParameters();
        Parameter param = BpsimFactory.eINSTANCE.createParameter();
        FloatingParameterType value = BpsimFactory.eINSTANCE.createFloatingParameterType();
        value.setValue(t);
        param.getParameterValue().add((Object)value);
        timeParams.setWaitTime(param);
        return timeParams;
    }

    public static TimeParameters createTimeParameters(DistributionType dt, double v1, double v2, TimeUnit tu) {
        TimeParameters timeParams = BpsimFactory.eINSTANCE.createTimeParameters();
        timeParams.setProcessingTime(JbpmModelUtil.createParameter(dt, v1, v2));
        return timeParams;
    }

    public static enum DistributionType {
        Normal,
        Uniform,
        Poisson;

    }

    public static class ImportHandler
    extends ImportUtil {
        private boolean createVariables = false;
        private IType importedType = null;

        public Interface createInterface(Definitions definitions, Import imp, IType type, IMethod[] methods) {
            this.importedType = type;
            return super.createInterface(definitions, imp, type, methods);
        }

        public ItemDefinition createItemDefinition(Definitions definitions, Import imp, IType clazz) {
            ItemDefinition itemDef = null;
            if (clazz != this.importedType && (itemDef = ImportHandler.findItemDefinition((Definitions)definitions, (Import)imp, (IType)clazz)) == null) {
                List processes;
                itemDef = super.createItemDefinition(definitions, imp, clazz);
                JbpmModelUtil.addImport(clazz, (EObject)itemDef, false, this.createVariables);
                if (this.createVariables && (processes = ModelUtil.getAllRootElements((Definitions)definitions, Process.class)).size() > 0) {
                    boolean done;
                    Process process = (Process)processes.get(0);
                    String structName = clazz.getElementName();
                    int index = structName.lastIndexOf(".");
                    if (index > 0) {
                        structName = structName.substring(index + 1);
                    }
                    String varName = String.valueOf(structName) + "Var";
                    index = 1;
                    block0: do {
                        done = true;
                        for (Property p : process.getProperties()) {
                            if (!varName.equals(p.getName())) continue;
                            varName = String.valueOf(structName) + "Var" + index++;
                            done = false;
                            continue block0;
                        }
                    } while (!done);
                    Property var = (Property)Bpmn2ModelerFactory.createFeature((EObject)((EObject)processes.get(0)), (String)"properties");
                    var.setName(varName);
                    var.setId(varName);
                    var.setItemSubjectRef(itemDef);
                }
            }
            return itemDef;
        }

        public void setCreateVariables(boolean createVariables) {
            this.createVariables = createVariables;
        }
    }
}

