/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.bpmn2.modeler.runtime.jboss.jbpm5.property.extensions;

import org.eclipse.bpmn2.Assignment;
import org.eclipse.bpmn2.Bpmn2Package;
import org.eclipse.bpmn2.DataInput;
import org.eclipse.bpmn2.DataInputAssociation;
import org.eclipse.bpmn2.Expression;
import org.eclipse.bpmn2.FormalExpression;
import org.eclipse.bpmn2.InputOutputSpecification;
import org.eclipse.bpmn2.InputSet;
import org.eclipse.bpmn2.ItemAwareElement;
import org.eclipse.bpmn2.Task;
import org.eclipse.bpmn2.modeler.core.model.Bpmn2ModelerFactory;
import org.eclipse.bpmn2.modeler.core.utils.ModelUtil;
import org.eclipse.bpmn2.modeler.runtime.jboss.jbpm5.property.extensions.NotificationType;
import org.eclipse.bpmn2.modeler.runtime.jboss.jbpm5.property.extensions.TaskExtensionsFactory;
import org.eclipse.bpmn2.modeler.runtime.jboss.jbpm5.property.extensions.TaskNotification;
import org.eclipse.core.runtime.Assert;
import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.common.util.BasicEList;
import org.eclipse.emf.ecore.EObject;

public class TaskNotificationList
extends BasicEList<EObject>
implements Adapter {
    protected Task task;

    public void add(String type, String string) {
        TaskNotification tn = TaskExtensionsFactory.eINSTANCE.createTaskNotification();
        tn.setType(NotificationType.get(type));
        this.add((EObject)tn);
        String tail = tn.fromString(string);
        while (tail != null) {
            tn = TaskExtensionsFactory.eINSTANCE.createTaskNotification();
            tn.setType(NotificationType.get(type));
            this.add((EObject)tn);
            tail = tn.fromString(tail);
        }
    }

    public boolean add(EObject object) {
        Assert.isTrue((boolean)(object instanceof TaskNotification));
        object.eAdapters().add((Object)this);
        ((TaskNotification)object).setTask(this.task);
        return super.add((Object)object);
    }

    public boolean replace(int index, String type, String string) {
        if (index >= 0 && index >= this.size()) {
            this.add(type, string);
            return true;
        }
        TaskNotification tn = this.get(index);
        String oldString = tn.toString();
        if (!tn.getType().getLiteral().equals(type) || !oldString.equals(string)) {
            tn.setType(NotificationType.get(type));
            tn.fromString(string);
            return true;
        }
        return false;
    }

    public EObject remove(int index) {
        EObject object = (EObject)super.remove(index);
        object.eAdapters().remove((Object)this);
        return object;
    }

    public TaskNotification get(int index) {
        return (TaskNotification)((Object)super.get(index));
    }

    public void setTask(Task task) {
        Assert.isTrue((task != null ? 1 : 0) != 0);
        InputOutputSpecification iospec = task.getIoSpecification();
        Assert.isTrue((iospec != null && iospec.getInputSets().size() > 0 ? 1 : 0) != 0);
        this.task = task;
    }

    public void updateTask() {
        FormalExpression expression;
        Assignment assignment;
        DataInput input;
        InputOutputSpecification iospec = this.task.getIoSpecification();
        DataInputAssociation notStarted = null;
        DataInputAssociation notCompleted = null;
        for (DataInputAssociation dia : this.task.getDataInputAssociations()) {
            if (!(dia.getTargetRef() instanceof DataInput)) continue;
            input = (DataInput)dia.getTargetRef();
            if (NotificationType.NOT_STARTED_NOTIFY.getLiteral().equals(input.getName())) {
                notStarted = dia;
                continue;
            }
            if (!NotificationType.NOT_COMPLETED_NOTIFY.getLiteral().equals(input.getName())) continue;
            notCompleted = dia;
        }
        String body = this.toString(NotificationType.NOT_STARTED_NOTIFY);
        if (body.isEmpty()) {
            if (notStarted != null) {
                iospec.getDataInputs().remove(notStarted.getTargetRef());
                ((InputSet)iospec.getInputSets().get(0)).getDataInputRefs().remove(notStarted.getTargetRef());
                this.task.getDataInputAssociations().remove(notStarted);
            }
        } else {
            if (notStarted == null) {
                input = (DataInput)Bpmn2ModelerFactory.eINSTANCE.create(Bpmn2Package.eINSTANCE.getDataInput());
                input.setName(NotificationType.NOT_STARTED_NOTIFY.getLiteral());
                iospec.getDataInputs().add(input);
                ((InputSet)iospec.getInputSets().get(0)).getDataInputRefs().add(input);
                notStarted = (DataInputAssociation)Bpmn2ModelerFactory.eINSTANCE.create(Bpmn2Package.eINSTANCE.getDataInputAssociation());
                notStarted.setTargetRef((ItemAwareElement)input);
                assignment = (Assignment)Bpmn2ModelerFactory.eINSTANCE.create(Bpmn2Package.eINSTANCE.getAssignment());
                expression = (FormalExpression)Bpmn2ModelerFactory.eINSTANCE.create(Bpmn2Package.eINSTANCE.getFormalExpression());
                ModelUtil.setID((EObject)input);
                expression.setBody(input.getId());
                assignment.setTo((Expression)expression);
                notStarted.getAssignment().add(assignment);
                this.task.getDataInputAssociations().add(notStarted);
                ModelUtil.setID((EObject)notStarted);
                ModelUtil.setID((EObject)assignment);
                ModelUtil.setID((EObject)expression);
            }
            if ((expression = (FormalExpression)(assignment = (Assignment)notStarted.getAssignment().get(0)).getFrom()) == null) {
                expression = (FormalExpression)Bpmn2ModelerFactory.eINSTANCE.create(Bpmn2Package.eINSTANCE.getFormalExpression());
                assignment.setFrom((Expression)expression);
                ModelUtil.setID((EObject)expression);
            }
            expression.setBody(body);
        }
        if ((body = this.toString(NotificationType.NOT_COMPLETED_NOTIFY)).isEmpty()) {
            if (notCompleted != null) {
                iospec.getDataInputs().remove(notCompleted.getTargetRef());
                ((InputSet)iospec.getInputSets().get(0)).getDataInputRefs().remove(notCompleted.getTargetRef());
                this.task.getDataInputAssociations().remove(notCompleted);
            }
        } else {
            if (notCompleted == null) {
                input = (DataInput)Bpmn2ModelerFactory.eINSTANCE.create(Bpmn2Package.eINSTANCE.getDataInput());
                input.setName(NotificationType.NOT_COMPLETED_NOTIFY.getLiteral());
                iospec.getDataInputs().add(input);
                ((InputSet)iospec.getInputSets().get(0)).getDataInputRefs().add(input);
                notCompleted = (DataInputAssociation)Bpmn2ModelerFactory.eINSTANCE.create(Bpmn2Package.eINSTANCE.getDataInputAssociation());
                notCompleted.setTargetRef((ItemAwareElement)input);
                assignment = (Assignment)Bpmn2ModelerFactory.eINSTANCE.create(Bpmn2Package.eINSTANCE.getAssignment());
                expression = (FormalExpression)Bpmn2ModelerFactory.eINSTANCE.create(Bpmn2Package.eINSTANCE.getFormalExpression());
                ModelUtil.setID((EObject)input);
                expression.setBody(input.getId());
                assignment.setTo((Expression)expression);
                notCompleted.getAssignment().add(assignment);
                this.task.getDataInputAssociations().add(notCompleted);
                ModelUtil.setID((EObject)notCompleted);
                ModelUtil.setID((EObject)assignment);
                ModelUtil.setID((EObject)expression);
            }
            if ((expression = (FormalExpression)(assignment = (Assignment)notCompleted.getAssignment().get(0)).getFrom()) == null) {
                expression = (FormalExpression)Bpmn2ModelerFactory.eINSTANCE.create(Bpmn2Package.eINSTANCE.getFormalExpression());
                assignment.setFrom((Expression)expression);
                ModelUtil.setID((EObject)expression);
            }
            expression.setBody(body);
        }
    }

    public String toString(NotificationType type) {
        String result = "";
        int i = 0;
        while (i < this.size()) {
            TaskNotification tn = this.get(i);
            if (tn.getType().equals((Object)type)) {
                if (!result.isEmpty()) {
                    result = String.valueOf(result) + "^";
                }
                result = String.valueOf(result) + tn.toString();
            }
            ++i;
        }
        return result;
    }

    public Notifier getTarget() {
        return null;
    }

    public void setTarget(Notifier newTarget) {
    }

    public boolean isAdapterForType(Object type) {
        return false;
    }

    public void notifyChanged(Notification notification) {
        this.updateTask();
    }
}

