/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.modelgenerator.ldap.ui.wizards.pages.definition;

import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import org.apache.directory.studio.connection.core.jobs.StudioConnectionRunnableWithProgress;
import org.apache.directory.studio.connection.ui.RunnableContextRunner;
import org.apache.directory.studio.ldapbrowser.core.jobs.FetchBaseDNsRunnable;
import org.apache.directory.studio.ldapbrowser.core.model.IBrowserConnection;
import org.apache.xerces.util.URI;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.datatools.connectivity.IConnectionProfile;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.operation.IRunnableContext;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.help.IWorkbenchHelpSystem;
import org.teiid.core.designer.event.IChangeListener;
import org.teiid.core.designer.event.IChangeNotifier;
import org.teiid.core.designer.util.StringConstants;
import org.teiid.designer.datatools.profiles.ldap.ILdapProfileConstants;
import org.teiid.designer.datatools.ui.dialogs.ConnectionProfileWorker;
import org.teiid.designer.datatools.ui.dialogs.IProfileChangedListener;
import org.teiid.designer.modelgenerator.ldap.ui.ModelGeneratorLdapUiConstants;
import org.teiid.designer.modelgenerator.ldap.ui.wizards.LdapImportWizard;
import org.teiid.designer.modelgenerator.ldap.ui.wizards.LdapImportWizardManager;
import org.teiid.designer.modelgenerator.ldap.ui.wizards.LdapPageUtils;
import org.teiid.designer.modelgenerator.ldap.ui.wizards.pages.definition.SourceModelPanel;
import org.teiid.designer.ui.common.util.UiUtil;
import org.teiid.designer.ui.common.util.WidgetFactory;
import org.teiid.designer.ui.common.util.WidgetUtil;
import org.teiid.designer.ui.common.util.WizardUtil;
import org.teiid.designer.ui.viewsupport.ModelNameUtil;

public class LdapDefinitionPage
extends WizardPage
implements IChangeListener,
IProfileChangedListener,
ModelGeneratorLdapUiConstants,
ModelGeneratorLdapUiConstants.Images,
ModelGeneratorLdapUiConstants.HelpContexts,
ILdapProfileConstants,
StringConstants {
    private static final String DIALOG_HEIGHT = "dialogHeight";
    private static final String DIALOG_WIDTH = "dialogWidth";
    private static final String DIALOG_X = "dialogX";
    private static final String DIALOG_Y = "dialogY";
    private static final String EMPTY_STR = "";
    private final LdapImportWizardManager importManager;
    private Button newCPButton;
    private Button editCPButton;
    private Combo connectionProfilesCombo;
    private ILabelProvider profileLabelProvider;
    private ConnectionProfileWorker profileWorker;
    private Text ldapURIText;
    private Combo baseDNCombo;
    private Button fetchBaseDnsButton;
    private SourceModelPanel sourceModelPanel;
    private boolean synchronising;

    public LdapDefinitionPage(LdapImportWizardManager theImportManager) {
        super(LdapDefinitionPage.class.getSimpleName(), LdapDefinitionPage.getString("title", new Object[0]), null);
        this.importManager = theImportManager;
        this.setImageDescriptor(LdapImportWizard.BANNER);
        this.importManager.addChangeListener(this);
    }

    private static String getString(String key, Object ... properties) {
        return ModelGeneratorLdapUiConstants.UTIL.getString(String.valueOf(LdapDefinitionPage.class.getSimpleName()) + "_" + key, properties);
    }

    private boolean isSynchronising() {
        return this.synchronising;
    }

    public void createControl(Composite theParent) {
        this.profileWorker = new ConnectionProfileWorker(this.getShell(), "org.teiid.designer.datatools.profiles.ldap.LDAPConnectionProfile", (IProfileChangedListener)this);
        Composite pnlMain = WidgetFactory.createPanel((Composite)theParent, (int)0, (int)1808);
        GridLayoutFactory.fillDefaults().numColumns(1).applyTo(pnlMain);
        this.setControl((Control)pnlMain);
        IWorkbenchHelpSystem helpSystem = UiUtil.getWorkbench().getHelpSystem();
        helpSystem.setHelp((Control)pnlMain, LDAP_SELECTION_PAGE);
        this.createSourceSelectionComposite(pnlMain);
        this.setPageStatus();
    }

    private void createSourceSelectionComposite(Composite theParent) {
        Composite pnl = WidgetFactory.createPanel((Composite)theParent, (int)4, (int)768);
        GridLayoutFactory.fillDefaults().applyTo(pnl);
        Group profileGroup = WidgetFactory.createGroup((Composite)pnl, (String)LdapDefinitionPage.getString("profileLabel_text", new Object[0]), (int)0, (int)2);
        GridLayoutFactory.fillDefaults().numColumns(3).margins(10, 5).applyTo((Composite)profileGroup);
        LdapPageUtils.setBackground((Control)profileGroup, pnl);
        GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)profileGroup);
        this.profileLabelProvider = new LabelProvider(){

            public String getText(Object source) {
                return ((IConnectionProfile)source).getName();
            }
        };
        this.connectionProfilesCombo = WidgetFactory.createCombo((Composite)profileGroup, (int)8, (int)768, (List)this.profileWorker.getProfiles(), (ILabelProvider)this.profileLabelProvider, (boolean)true);
        LdapPageUtils.blueForeground((Control)this.connectionProfilesCombo);
        this.connectionProfilesCombo.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                LdapDefinitionPage.this.handleConnectionProfileSelected();
            }
        });
        this.connectionProfilesCombo.setVisibleItemCount(10);
        this.newCPButton = WidgetFactory.createButton((Composite)profileGroup, (String)LdapDefinitionPage.getString("new_label", new Object[0]));
        this.newCPButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                LdapDefinitionPage.this.profileWorker.create();
            }
        });
        this.editCPButton = WidgetFactory.createButton((Composite)profileGroup, (String)LdapDefinitionPage.getString("edit_label", new Object[0]));
        this.editCPButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                LdapDefinitionPage.this.profileWorker.edit();
            }
        });
        Group ldapURIGroup = WidgetFactory.createGroup((Composite)pnl, (String)LdapDefinitionPage.getString("ldapLabel_title", new Object[0]), (int)4, (int)2);
        GridLayoutFactory.fillDefaults().numColumns(3).margins(10, 5).applyTo((Composite)ldapURIGroup);
        GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)ldapURIGroup);
        LdapPageUtils.setBackground((Control)ldapURIGroup, pnl);
        Label ldapURILabel = new Label((Composite)ldapURIGroup, 0);
        ldapURILabel.setText(LdapDefinitionPage.getString("ldapLabel_text", new Object[0]));
        LdapPageUtils.setBackground((Control)ldapURILabel, pnl);
        GridDataFactory.fillDefaults().grab(false, false).applyTo((Control)ldapURILabel);
        this.ldapURIText = new Text((Composite)ldapURIGroup, 2052);
        this.ldapURIText.setToolTipText(LdapDefinitionPage.getString("ldapURITextField_tooltip", new Object[0]));
        LdapPageUtils.blueForeground((Control)this.ldapURIText);
        this.ldapURIText.setEditable(false);
        GridDataFactory.fillDefaults().grab(true, false).span(2, 1).applyTo((Control)this.ldapURIText);
        Label dnLabel = new Label((Composite)ldapURIGroup, 0);
        dnLabel.setText(LdapDefinitionPage.getString("dnLabel_text", new Object[0]));
        LdapPageUtils.setBackground((Control)dnLabel, pnl);
        GridDataFactory.fillDefaults().grab(false, false).applyTo((Control)dnLabel);
        this.baseDNCombo = new Combo((Composite)ldapURIGroup, 4);
        this.baseDNCombo.setToolTipText(LdapDefinitionPage.getString("dnTextField_tooltip", new Object[0]));
        GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)this.baseDNCombo);
        this.baseDNCombo.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                IConnectionProfile profile = LdapDefinitionPage.this.importManager.getConnectionProfile();
                Properties properties = profile.getBaseProperties();
                properties.setProperty("baseDN", LdapDefinitionPage.this.baseDNCombo.getText());
                LdapDefinitionPage.this.importManager.resetBrowserConnection();
            }
        });
        this.fetchBaseDnsButton = new Button((Composite)ldapURIGroup, 8);
        this.fetchBaseDnsButton.setEnabled(false);
        this.fetchBaseDnsButton.setText(LdapDefinitionPage.getString("fetchBaseDNs", new Object[0]));
        GridDataFactory.fillDefaults().applyTo((Control)this.fetchBaseDnsButton);
        this.fetchBaseDnsButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                IBrowserConnection browserConnection = LdapDefinitionPage.this.importManager.getBrowserConnection();
                if (browserConnection == null) {
                    return;
                }
                FetchBaseDNsRunnable runnable = new FetchBaseDNsRunnable(browserConnection);
                IStatus status = RunnableContextRunner.execute((StudioConnectionRunnableWithProgress)runnable, (IRunnableContext)LdapDefinitionPage.this.getContainer(), (boolean)true);
                if (status.isOK()) {
                    if (!runnable.getBaseDNs().isEmpty()) {
                        List baseDNs = runnable.getBaseDNs();
                        LdapDefinitionPage.this.baseDNCombo.setItems(baseDNs.toArray(new String[baseDNs.size()]));
                        LdapDefinitionPage.this.baseDNCombo.select(0);
                    } else {
                        MessageDialog.openWarning((Shell)Display.getDefault().getActiveShell(), (String)LdapDefinitionPage.getString("fetchBaseDNs", new Object[0]), (String)LdapDefinitionPage.getString("noBaseDNReturnedFromServer", new Object[0]));
                        LdapDefinitionPage.this.baseDNCombo.setItems(new String[0]);
                    }
                }
            }
        });
        this.sourceModelPanel = new SourceModelPanel(pnl, this.importManager);
    }

    private void handleConnectionProfileSelected() {
        String name;
        if (this.isSynchronising()) {
            return;
        }
        int selIndex = this.connectionProfilesCombo.getSelectionIndex();
        if (selIndex >= 0 && (name = this.connectionProfilesCombo.getItem(selIndex)) != null) {
            IConnectionProfile profile = this.profileWorker.getProfile(name);
            this.profileWorker.setSelection(profile);
            this.setConnectionProfileInternal(profile);
        }
        this.notifyChanged();
    }

    public void dispose() {
        this.saveState();
    }

    protected IDialogSettings getDialogSettings() {
        IDialogSettings settings = super.getDialogSettings();
        if (settings != null) {
            IDialogSettings temp = settings.getSection("ModelGeneratorLdapUi");
            settings = temp == null ? settings.addNewSection("ModelGeneratorLdapUi") : temp;
        }
        return settings;
    }

    public boolean isValidUri(String str) {
        try {
            new URI(str);
        }
        catch (URI.MalformedURIException malformedURIException) {
            return false;
        }
        return true;
    }

    private void saveState() {
        Shell shell;
        IDialogSettings settings = this.getDialogSettings();
        if (settings != null && this.getContainer() != null && (shell = this.getContainer().getShell()) != null) {
            Rectangle r = shell.getBounds();
            settings.put(DIALOG_X, r.x);
            settings.put(DIALOG_Y, r.y);
            settings.put(DIALOG_WIDTH, r.width);
            settings.put(DIALOG_HEIGHT, r.height);
        }
    }

    private void refreshUiFromManager() {
        this.synchronising = true;
        try {
            if (this.importManager == null) {
                return;
            }
            if (this.connectionProfilesCombo.getItems() == null || this.connectionProfilesCombo.getItems().length == 0) {
                if (this.profileWorker.getProfiles().isEmpty()) {
                    this.setErrorMessage(LdapDefinitionPage.getString("no_profiles_configured", new Object[0]));
                    this.ldapURIText.setText(EMPTY_STR);
                    this.baseDNCombo.setText(EMPTY_STR);
                    return;
                }
                this.setErrorMessage(null);
                this.setMessage(LdapDefinitionPage.getString("select_profile", new Object[0]));
                return;
            }
            if (this.connectionProfilesCombo.getSelectionIndex() < 0) {
                return;
            }
            String profileName = this.connectionProfilesCombo.getText();
            IConnectionProfile profile = this.profileWorker.getProfile(profileName);
            if (profile == null) {
                this.setMessage(null);
                this.setErrorMessage(LdapDefinitionPage.getString("no_profile_match", profileName));
                return;
            }
            Properties props = profile.getBaseProperties();
            this.ldapURIText.setText(props.getProperty("LdapUrl"));
            this.setErrorMessage(null);
            this.setMessage(LdapDefinitionPage.getString("select_profile", new Object[0]));
        }
        finally {
            this.synchronising = false;
        }
    }

    public void profileChanged(IConnectionProfile profile) {
        this.resetCPComboItems();
        this.selectConnectionProfile(profile.getName());
        this.setConnectionProfileInternal(profile);
        this.notifyChanged();
    }

    private void setPageStatus() {
        IStatus status;
        IConnectionProfile connectionProfile = this.importManager.getConnectionProfile();
        if (connectionProfile == null) {
            WizardUtil.setPageComplete((WizardPage)this, (String)LdapDefinitionPage.getString("no_profile_selected", new Object[0]), (int)3);
            return;
        }
        if (this.isCurrentPage()) {
            block13: {
                status = null;
                try {
                    status = connectionProfile.connectWithoutJob();
                    if (status.isOK()) break block13;
                    WizardUtil.setPageComplete((WizardPage)this, (String)LdapDefinitionPage.getString("no_connection_made", new Object[0]), (int)3);
                }
                catch (Throwable throwable) {
                    if (status != null && status.isOK()) {
                        Job job = new Job("Disconnect connection profile"){

                            protected IStatus run(IProgressMonitor monitor) {
                                IConnectionProfile connProfile = LdapDefinitionPage.this.importManager.getConnectionProfile();
                                if (connProfile != null) {
                                    connProfile.disconnect();
                                }
                                return Status.OK_STATUS;
                            }
                        };
                        job.setSystem(true);
                        job.setUser(false);
                        job.schedule();
                    }
                    throw throwable;
                }
                if (status != null && status.isOK()) {
                    Job job = new /* invalid duplicate definition of identical inner class */;
                    job.setSystem(true);
                    job.setUser(false);
                    job.schedule();
                }
                return;
            }
            if (status != null && status.isOK()) {
                Job job = new /* invalid duplicate definition of identical inner class */;
                job.setSystem(true);
                job.setUser(false);
                job.schedule();
            }
        }
        if (this.importManager.getSourceModelName() == null || this.importManager.getSourceModelName().length() == 0) {
            WizardUtil.setPageComplete((WizardPage)this, (String)LdapDefinitionPage.getString("statusSourceModelNameCannotBeNullOrEmpty", new Object[0]), (int)3);
            return;
        }
        status = ModelNameUtil.validate((String)this.importManager.getSourceModelName(), (String)".xmi", null, (int)1);
        if (status.getSeverity() == 4) {
            WizardUtil.setPageComplete((WizardPage)this, (String)(String.valueOf(ModelNameUtil.MESSAGES.INVALID_MODEL_NAME) + status.getMessage()), (int)3);
            return;
        }
        if (this.sourceModelPanel.sourceModelExists()) {
            if (!this.sourceModelPanel.sourceModelHasConnectionProfile()) {
                WizardUtil.setPageComplete((WizardPage)this, (String)LdapDefinitionPage.getString("statusExistingSourceModelHasNoProfile", this.importManager.getSourceModelName()), (int)3);
                return;
            }
            if (!this.sourceModelPanel.sourceModelHasSameConnectionProfile()) {
                WizardUtil.setPageComplete((WizardPage)this, (String)LdapDefinitionPage.getString("statusExistingSourceModelHasWrongProfile", this.importManager.getSourceModelName()), (int)3);
                return;
            }
        } else {
            WizardUtil.setPageComplete((WizardPage)this, (String)LdapDefinitionPage.getString("statusSourceModelDoesNotExistAndWillBeCreated", this.importManager.getSourceModelName()), (int)1);
            return;
        }
        WizardUtil.setPageComplete((WizardPage)this);
    }

    void resetCPComboItems() {
        if (this.connectionProfilesCombo != null) {
            ArrayList<IConnectionProfile> profileList = new ArrayList<IConnectionProfile>();
            for (IConnectionProfile prof : this.profileWorker.getProfiles()) {
                profileList.add(prof);
            }
            WidgetUtil.setComboItems((Combo)this.connectionProfilesCombo, profileList, (ILabelProvider)this.profileLabelProvider, (boolean)true);
        }
    }

    public boolean selectConnectionProfile(String name) {
        if (name == null) {
            return false;
        }
        int cpIndex = -1;
        int i = 0;
        String[] stringArray = this.connectionProfilesCombo.getItems();
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String item = stringArray[n2];
            if (item != null && item.length() > 0 && item.toUpperCase().equalsIgnoreCase(name.toUpperCase())) {
                cpIndex = i;
                break;
            }
            ++i;
            ++n2;
        }
        boolean profileChanged = false;
        if (cpIndex > -1) {
            this.connectionProfilesCombo.select(cpIndex);
            IConnectionProfile profile = this.profileWorker.getProfile(this.connectionProfilesCombo.getText());
            this.profileWorker.setSelection(profile);
            IConnectionProfile currentProfile = this.importManager.getConnectionProfile();
            if (profile != currentProfile) {
                profileChanged = true;
                this.setConnectionProfileInternal(profile);
            }
        }
        return profileChanged;
    }

    private void setConnectionProfileInternal(IConnectionProfile profile) {
        this.importManager.setConnectionProfile(profile);
        this.fetchBaseDnsButton.setEnabled(this.importManager.getConnectionProfile() != null);
    }

    public void setVisible(boolean visible) {
        super.setVisible(visible);
        if (!visible) {
            return;
        }
        if (this.importManager.getConnectionProfile() == null) {
            return;
        }
        boolean profileChanged = false;
        if (this.connectionProfilesCombo.getItemCount() > 0) {
            if (this.connectionProfilesCombo.getText() != null && this.connectionProfilesCombo.getText().equals(this.importManager.getConnectionProfile().getName())) {
                profileChanged = this.selectConnectionProfile(this.importManager.getConnectionProfile().getName());
            }
        } else if (this.connectionProfilesCombo.getSelectionIndex() < 0) {
            this.connectionProfilesCombo.select(0);
            profileChanged = true;
        }
        this.refreshUiFromManager();
        if (profileChanged) {
            this.handleConnectionProfileSelected();
        }
        if (this.sourceModelPanel != null) {
            this.sourceModelPanel.refresh();
        }
        this.setPageStatus();
    }

    public void stateChanged(IChangeNotifier theSource) {
        this.setPageStatus();
    }

    private void notifyChanged() {
        this.refreshUiFromManager();
        this.importManager.notifyChanged();
    }
}

