/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.modelgenerator.ldap.ui.wizards.pages.columns;

import java.util.ArrayList;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.viewers.CheckStateChangedEvent;
import org.eclipse.jface.viewers.CheckboxTreeViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICheckStateListener;
import org.eclipse.jface.viewers.ICheckStateProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.custom.ViewForm;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Text;
import org.teiid.core.designer.event.IChangeListener;
import org.teiid.core.designer.event.IChangeNotifier;
import org.teiid.designer.modelgenerator.ldap.ui.ModelGeneratorLdapUiConstants;
import org.teiid.designer.modelgenerator.ldap.ui.wizards.ILdapAttributeNode;
import org.teiid.designer.modelgenerator.ldap.ui.wizards.ILdapEntryNode;
import org.teiid.designer.modelgenerator.ldap.ui.wizards.LdapImportWizard;
import org.teiid.designer.modelgenerator.ldap.ui.wizards.LdapImportWizardManager;
import org.teiid.designer.modelgenerator.ldap.ui.wizards.LdapPageUtils;
import org.teiid.designer.modelgenerator.ldap.ui.wizards.pages.columns.LdapEntryContentProvider;
import org.teiid.designer.modelgenerator.ldap.ui.wizards.pages.columns.LdapEntryLabelProvider;
import org.teiid.designer.ui.common.InternalUiConstants;
import org.teiid.designer.ui.common.util.WidgetFactory;
import org.teiid.designer.ui.common.util.WizardUtil;

public class LdapColumnsPage
extends WizardPage
implements IChangeListener,
ModelGeneratorLdapUiConstants,
ModelGeneratorLdapUiConstants.Images,
ModelGeneratorLdapUiConstants.HelpContexts {
    private static final String NULL_STRING = "";
    private static final int[] SPLITTER_WEIGHTS = new int[]{40, 60};
    private final LdapImportWizardManager importManager;
    private IContentProvider contentProvider;
    private ILabelProvider labelProvider;
    private SashForm splitter;
    private CheckboxTreeViewer treeViewer;
    private Text columnNameText;
    private Text columnSourceNameText;
    private Text columnDVCountText;
    private Text columnNVCountText;
    private Text columnMaxValueText;
    private Button validateButton;
    private boolean dirty;

    public LdapColumnsPage(LdapImportWizardManager theImportManager) {
        super(LdapColumnsPage.class.getSimpleName(), LdapColumnsPage.getString("title", new Object[0]), null);
        this.importManager = theImportManager;
        this.setDescription(LdapColumnsPage.getString("description", new Object[0]));
        this.setImageDescriptor(LdapImportWizard.BANNER);
        this.importManager.addChangeListener(this);
        this.contentProvider = new LdapEntryContentProvider(this.importManager);
        this.labelProvider = new LdapEntryLabelProvider(this.importManager);
    }

    private static String getString(String key, Object ... properties) {
        return ModelGeneratorLdapUiConstants.UTIL.getString(String.valueOf(LdapColumnsPage.class.getSimpleName()) + "_" + key, properties);
    }

    private boolean isDirty() {
        return this.dirty;
    }

    private void setDirty(boolean dirty) {
        this.dirty = dirty;
    }

    private void nodeSelected(Object node) {
        if (node instanceof ILdapAttributeNode) {
            ILdapAttributeNode attributeNode = (ILdapAttributeNode)node;
            this.columnNameText.setText(attributeNode.getLabel());
            this.columnNameText.setEditable(true);
            this.columnSourceNameText.setText(attributeNode.getId());
            this.columnDVCountText.setText(Integer.toString(attributeNode.getDistinctValueCount()));
            this.columnNVCountText.setText(Integer.toString(attributeNode.getNullValueCount()));
            this.columnMaxValueText.setText(Integer.toString(attributeNode.getMaximumValueLength()));
        } else {
            this.columnNameText.setText(NULL_STRING);
            this.columnNameText.setEditable(false);
            this.columnSourceNameText.setText(NULL_STRING);
            this.columnDVCountText.setText(NULL_STRING);
            this.columnNVCountText.setText(NULL_STRING);
            this.columnMaxValueText.setText(NULL_STRING);
        }
    }

    private void nodeChecked(ILdapAttributeNode attrNode, boolean selected) {
        if (attrNode == null) {
            return;
        }
        this.importManager.setSynchronising(true);
        if (selected) {
            this.importManager.addAttribute(attrNode);
        } else {
            this.importManager.removeAttribute(attrNode);
        }
        this.importManager.setSynchronising(false);
    }

    private void deselectAllButtonSelected() {
        ArrayList<ILdapAttributeNode> oldSelection = new ArrayList<ILdapAttributeNode>();
        oldSelection.addAll(this.importManager.getSelectedAttributes());
        for (ILdapAttributeNode node : oldSelection) {
            this.treeViewer.setChecked((Object)node, false);
            this.nodeChecked(node, false);
        }
        this.setPageStatus();
    }

    private void setNonEditable(Text control) {
        if (control == null) {
            return;
        }
        LdapPageUtils.blueForeground((Control)control);
        LdapPageUtils.greyBackground((Control)control);
        control.setEditable(false);
    }

    public void createControl(Composite parent) {
        Composite pg = new Composite(parent, 0){

            public Point computeSize(int widthHint, int heightHint, boolean changed) {
                Point size = super.computeSize(widthHint, heightHint, changed);
                size.x = 800;
                return size;
            }
        };
        GridLayoutFactory.fillDefaults().applyTo(pg);
        this.setControl((Control)pg);
        this.splitter = WidgetFactory.createSplitter((Composite)pg);
        Group treeComposite = new Group((Composite)this.splitter, 2048);
        treeComposite.setText(LdapColumnsPage.getString("attrTreeTitle", new Object[0]));
        treeComposite.setFont(JFaceResources.getBannerFont());
        GridLayoutFactory.fillDefaults().margins(10, 5).applyTo((Composite)treeComposite);
        this.treeViewer = new CheckboxTreeViewer((Composite)treeComposite, 2052);
        this.treeViewer.setUseHashlookup(true);
        GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)this.treeViewer.getTree());
        this.treeViewer.setContentProvider(this.contentProvider);
        this.treeViewer.setLabelProvider((IBaseLabelProvider)this.labelProvider);
        this.treeViewer.setCheckStateProvider(new ICheckStateProvider(){

            public boolean isGrayed(Object element) {
                return element instanceof ILdapEntryNode;
            }

            public boolean isChecked(Object element) {
                return element instanceof ILdapEntryNode;
            }
        });
        this.treeViewer.addCheckStateListener(new ICheckStateListener(){

            public void checkStateChanged(CheckStateChangedEvent event) {
                Object element = event.getElement();
                if (!(element instanceof ILdapAttributeNode)) {
                    event.getCheckable().setChecked(element, true);
                    return;
                }
                ILdapAttributeNode node = (ILdapAttributeNode)element;
                LdapColumnsPage.this.nodeChecked(node, event.getChecked());
            }
        });
        this.treeViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                ISelection selection = event.getSelection();
                if (selection.isEmpty()) {
                    return;
                }
                if (!(selection instanceof IStructuredSelection)) {
                    return;
                }
                IStructuredSelection sselection = (IStructuredSelection)selection;
                LdapColumnsPage.this.importManager.setSynchronising(true);
                try {
                    for (Object object : sselection) {
                        if (!(object instanceof ILdapAttributeNode)) continue;
                        LdapColumnsPage.this.nodeSelected(object);
                    }
                }
                finally {
                    LdapColumnsPage.this.importManager.setSynchronising(false);
                }
            }
        });
        this.treeViewer.getTree().addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseDoubleClick(MouseEvent e) {
                IStructuredSelection selection = (IStructuredSelection)LdapColumnsPage.this.treeViewer.getSelection();
                if (selection.isEmpty()) {
                    return;
                }
                Object node = selection.getFirstElement();
                LdapColumnsPage.this.treeViewer.setExpandedState(node, !LdapColumnsPage.this.treeViewer.getExpandedState(node));
            }
        });
        ViewForm detailsView = new ViewForm((Composite)this.splitter, 2048);
        Group detailsGroup = WidgetFactory.createGroup((Composite)detailsView, (String)LdapColumnsPage.getString("columnAttributesTitle", new Object[0]), (int)0, (int)2);
        GridLayoutFactory.fillDefaults().numColumns(2).margins(10, 10).applyTo((Composite)detailsGroup);
        LdapPageUtils.setBackground((Control)detailsGroup, (Composite)this.splitter);
        GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)detailsGroup);
        detailsView.setContent((Control)detailsGroup);
        Label columnNameLabel = new Label((Composite)detailsGroup, 0);
        columnNameLabel.setText(LdapColumnsPage.getString("detailColumnNameLabel", new Object[0]));
        this.columnNameText = new Text((Composite)detailsGroup, 2052);
        GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)this.columnNameText);
        this.columnNameText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                LdapColumnsPage.this.setDirty(true);
                IStructuredSelection selection = (IStructuredSelection)LdapColumnsPage.this.treeViewer.getSelection();
                if (selection.isEmpty()) {
                    return;
                }
                if (selection.getFirstElement() instanceof ILdapAttributeNode) {
                    ILdapAttributeNode node = (ILdapAttributeNode)selection.getFirstElement();
                    String colNameText = LdapColumnsPage.this.columnNameText.getText();
                    if (!colNameText.equals(node.getLabel())) {
                        node.setLabel(colNameText);
                    }
                }
                LdapColumnsPage.this.setPageStatus();
            }
        });
        Label columnSourceNameLabel = new Label((Composite)detailsGroup, 0);
        columnSourceNameLabel.setText(LdapColumnsPage.getString("detailColumnSourceNameLabel", new Object[0]));
        this.columnSourceNameText = new Text((Composite)detailsGroup, 2052);
        GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)this.columnSourceNameText);
        this.setNonEditable(this.columnSourceNameText);
        Label columnDVCountLabel = new Label((Composite)detailsGroup, 0);
        columnDVCountLabel.setText(LdapColumnsPage.getString("detailColumnDVCountLabel", new Object[0]));
        this.columnDVCountText = new Text((Composite)detailsGroup, 2052);
        GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)this.columnDVCountText);
        this.setNonEditable(this.columnDVCountText);
        Label columnNVCountLabel = new Label((Composite)detailsGroup, 0);
        columnNVCountLabel.setText(LdapColumnsPage.getString("detailColumnNVCountLabel", new Object[0]));
        this.columnNVCountText = new Text((Composite)detailsGroup, 2052);
        GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)this.columnNVCountText);
        this.setNonEditable(this.columnNVCountText);
        Label maxValueLabel = new Label((Composite)detailsGroup, 0);
        maxValueLabel.setText(LdapColumnsPage.getString("detailMaxValueLabel", new Object[0]));
        this.columnMaxValueText = new Text((Composite)detailsGroup, 2052);
        GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)this.columnMaxValueText);
        this.setNonEditable(this.columnMaxValueText);
        this.validateButton = new Button((Composite)detailsGroup, 8);
        this.validateButton.setText(LdapColumnsPage.getString("validateButtonLabel", new Object[0]));
        GridDataFactory.swtDefaults().span(2, 1).align(3, 2).applyTo((Control)this.validateButton);
        this.validateButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                LdapColumnsPage.this.setDirty(false);
                LdapColumnsPage.this.notifyChanged();
            }
        });
        this.splitter.setWeights(SPLITTER_WEIGHTS);
        Button deselectAllButton = WidgetFactory.createButton((Composite)pg, (String)InternalUiConstants.Widgets.DESELECT_ALL_BUTTON);
        deselectAllButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                LdapColumnsPage.this.deselectAllButtonSelected();
            }
        });
    }

    private void setPageStatus() {
        if (this.getControl() != null && !this.getControl().isVisible()) {
            return;
        }
        if (this.isDirty()) {
            WizardUtil.setPageComplete((WizardPage)this, (String)LdapColumnsPage.getString("needsValidating", new Object[0]), (int)3);
            return;
        }
        if (this.importManager.getError() != null) {
            ModelGeneratorLdapUiConstants.UTIL.log((Throwable)this.importManager.getError());
            WizardUtil.setPageComplete((WizardPage)this, (String)this.importManager.getError().getLocalizedMessage(), (int)3);
            return;
        }
        if (!this.importManager.hasAttributesForEachSelectedEntry()) {
            WizardUtil.setPageComplete((WizardPage)this, (String)LdapColumnsPage.getString("sourceColumnsIncomplete", new Object[0]), (int)3);
            return;
        }
        WizardUtil.setPageComplete((WizardPage)this);
    }

    public void setVisible(boolean visible) {
        super.setVisible(visible);
        if (!visible) {
            return;
        }
        if (this.importManager.getConnectionProfile() == null) {
            return;
        }
        this.treeViewer.setInput((Object)this.importManager);
        this.treeViewer.expandToLevel(2);
        this.setPageStatus();
    }

    public void stateChanged(IChangeNotifier theSource) {
        if (this.treeViewer != null && this.treeViewer.getInput() != null) {
            Object[] checkedElements = this.treeViewer.getCheckedElements();
            this.treeViewer.refresh(true);
            this.treeViewer.setCheckedElements(checkedElements);
        }
        this.setPageStatus();
    }

    private void notifyChanged() {
        this.importManager.notifyChanged();
    }
}

