/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.modelgenerator.ldap.ui.wizards;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.swt.graphics.Image;
import org.teiid.designer.modelgenerator.ldap.ui.wizards.LdapImportWizardManager;

public abstract class AbstractLdapLabelProvider
extends LabelProvider {
    private final LdapImportWizardManager importManager;
    private Map<ImageDescriptor, Image> imgRegistry = new HashMap<ImageDescriptor, Image>();

    public AbstractLdapLabelProvider(LdapImportWizardManager manager) {
        this.importManager = manager;
    }

    public LdapImportWizardManager getImportManager() {
        return this.importManager;
    }

    protected Image getImage(ImageDescriptor descriptor) {
        if (descriptor == null) {
            return null;
        }
        Image img = this.imgRegistry.get(descriptor);
        if (img == null) {
            img = descriptor.createImage();
            this.imgRegistry.put(descriptor, img);
        }
        return img;
    }

    public void dispose() {
        super.dispose();
        for (Image img : this.imgRegistry.values()) {
            img.dispose();
        }
        this.imgRegistry.clear();
    }
}

