/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.extension.properties;

import java.util.Locale;
import org.eclipse.osgi.util.NLS;
import org.teiid.core.designer.HashCodeUtil;
import org.teiid.core.designer.util.CoreArgCheck;
import org.teiid.core.designer.util.CoreStringUtil;
import org.teiid.designer.extension.ExtensionConstants;
import org.teiid.designer.extension.Messages;

public class Translation
implements Comparable<Translation>,
Cloneable {
    private Locale locale;
    private String translation;

    public Translation(Locale locale, String translation) {
        CoreArgCheck.isNotNull((Object)locale, (String)"locale is null");
        this.locale = locale;
        this.translation = translation;
    }

    public Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new Error("should never happen");
        }
    }

    @Override
    public int compareTo(Translation that) {
        return ExtensionConstants.LOCALE_COMPARATOR.compare(this.getLocale(), that.getLocale());
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || !this.getClass().equals(object.getClass())) {
            return false;
        }
        Translation other = (Translation)object;
        return this.locale.equals(other.locale) && CoreStringUtil.equals((String)this.translation, (String)other.translation);
    }

    public Locale getLocale() {
        return this.locale;
    }

    public String getTranslation() {
        return this.translation;
    }

    public int hashCode() {
        int result = HashCodeUtil.hashCode((int)0, (Object[])new Object[]{this.locale});
        if (this.translation != null) {
            result = HashCodeUtil.hashCode((int)result, (Object[])new Object[]{this.translation});
        }
        return result;
    }

    public void setLocale(Locale newLocale) {
        CoreArgCheck.isNotNull((Object)newLocale, (String)"newLocale is null");
        if (!this.locale.equals(newLocale)) {
            this.locale = newLocale;
        }
    }

    public void setTranslation(String newTranslation) {
        this.translation = newTranslation;
    }

    public String toString() {
        return NLS.bind((String)Messages.translationToString, (Object)this.locale.getDisplayLanguage());
    }
}

