/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.extension.definition;

import java.io.File;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.eclipse.osgi.util.NLS;
import org.teiid.core.designer.util.CoreArgCheck;
import org.teiid.core.designer.util.I18nUtil;
import org.teiid.designer.extension.Messages;
import org.teiid.designer.extension.definition.ModelExtensionAssistant;
import org.teiid.designer.extension.definition.ModelExtensionDefinition;
import org.teiid.designer.extension.properties.ModelExtensionPropertyDefinition;
import org.teiid.designer.extension.properties.Translation;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.helpers.DefaultHandler;

public class ModelExtensionDefinitionParser {
    private static final boolean DEBUG_MODE = false;
    static final Locale LOCALE = Locale.getDefault();
    private final File definitionSchemaFile;
    private Handler handler;
    private SAXParser parser;

    public ModelExtensionDefinitionParser(File medSchema) throws IllegalStateException {
        try {
            SAXParserFactory factory = SAXParserFactory.newInstance();
            factory.setNamespaceAware(true);
            factory.setValidating(true);
            this.parser = factory.newSAXParser();
            this.parser.setProperty("http://java.sun.com/xml/jaxp/properties/schemaLanguage", "http://www.w3.org/2001/XMLSchema");
            this.definitionSchemaFile = medSchema;
            if (this.definitionSchemaFile == null || !this.definitionSchemaFile.exists()) {
                throw new IllegalStateException(Messages.definitionSchemaFileNotFoundInFilesystem);
            }
            this.parser.setProperty("http://java.sun.com/xml/jaxp/properties/schemaSource", this.definitionSchemaFile);
        }
        catch (Exception e) {
            IllegalStateException error = null;
            error = e instanceof IllegalStateException ? (IllegalStateException)e : new IllegalStateException(e);
            throw error;
        }
    }

    public Collection<String> getErrors() {
        if (this.handler == null) {
            return null;
        }
        return this.handler.getErrors();
    }

    public Collection<String> getFatalErrors() {
        if (this.handler == null) {
            return null;
        }
        return this.handler.getFatalErrors();
    }

    public Collection<String> getInfos() {
        if (this.handler == null) {
            return null;
        }
        return this.handler.getInfos();
    }

    public Collection<String> getWarnings() {
        if (this.handler == null) {
            return null;
        }
        return this.handler.getWarnings();
    }

    public ModelExtensionDefinition parse(InputStream definitionStream, ModelExtensionAssistant assistant) throws Exception {
        CoreArgCheck.isNotNull((Object)definitionStream, (String)"definitionStream is null");
        this.handler = new Handler(assistant);
        this.parser.parse(definitionStream, (DefaultHandler)this.handler);
        return this.handler.getModelExtensionDefinition();
    }

    class Handler
    extends DefaultHandler {
        private final Collection<String> fatals;
        private final Collection<String> errors;
        private final Collection<String> infos;
        private final Collection<String> warnings;
        private String advanced;
        private StringBuilder allowedValue = new StringBuilder();
        private Set<String> allowedValues = new HashSet<String>();
        private final ModelExtensionAssistant assistant;
        private String defaultValue;
        private ModelExtensionDefinition definition;
        private StringBuilder description = new StringBuilder();
        private final Stack<String> elements;
        private String fixedValue;
        private String id;
        private String index;
        private String masked;
        private String metaclassName;
        private String metamodelUri;
        private StringBuilder modelType = new StringBuilder();
        private String namespacePrefix;
        private String namespaceUri;
        private ModelExtensionPropertyDefinition propDefn;
        private final Map<String, Collection<ModelExtensionPropertyDefinition>> properties;
        private String required;
        private String type;
        private String version;
        private Set<Translation> descriptions = new HashSet<Translation>();
        private String currentDescriptionLocale;
        private StringBuilder currentDescriptionText = new StringBuilder();
        private Set<Translation> displayNames = new HashSet<Translation>();
        private String currentDisplayNameLocale;
        private StringBuilder currentDisplayNameText = new StringBuilder();

        public Handler(ModelExtensionAssistant assistant) {
            CoreArgCheck.isNotNull((Object)assistant, (String)"assistant is null");
            this.assistant = assistant;
            this.properties = new HashMap<String, Collection<ModelExtensionPropertyDefinition>>();
            this.elements = new Stack();
            this.fatals = new ArrayList<String>();
            this.errors = new ArrayList<String>();
            this.infos = new ArrayList<String>();
            this.warnings = new ArrayList<String>();
        }

        @Override
        public void characters(char[] ch, int start, int length) throws SAXException {
            String value = new String(ch, start, length);
            if ("description".equals(this.getCurrentElement())) {
                if ("modelExtension".equals(this.getPreviousElement())) {
                    this.description.append(value);
                } else if ("property".equals(this.getPreviousElement())) {
                    this.currentDescriptionText.append(value);
                } else assert (false) : "Unexpected previous tag of " + this.getPreviousElement() + " while processing the " + "description" + " tag";
            } else if ("display".equals(this.getCurrentElement())) {
                if ("property".equals(this.getPreviousElement())) {
                    this.currentDisplayNameText.append(value);
                } else assert (false) : "Unexpected previous tag of " + this.getPreviousElement() + " while processing the " + "display" + " tag";
            } else if ("allowedValue".equals(this.getCurrentElement())) {
                this.allowedValue.append(value);
            } else if ("modelType".equals(this.getCurrentElement())) {
                this.modelType.append(value);
            }
            super.characters(ch, start, length);
        }

        @Override
        public void endElement(String uri, String localName, String qName) throws SAXException {
            if ("display".equals(localName)) {
                if (this.currentDisplayNameLocale != null) {
                    Locale locale = I18nUtil.parseLocaleString((String)this.currentDisplayNameLocale);
                    this.displayNames.add(new Translation(locale, this.currentDisplayNameText.toString()));
                }
                this.currentDisplayNameLocale = null;
                this.currentDisplayNameText.setLength(0);
            } else if ("description".equals(localName)) {
                if (this.currentDescriptionLocale != null) {
                    Locale locale = I18nUtil.parseLocaleString((String)this.currentDescriptionLocale);
                    this.descriptions.add(new Translation(locale, this.currentDescriptionText.toString()));
                }
                this.currentDescriptionLocale = null;
                this.currentDescriptionText.setLength(0);
            } else if ("property".equals(localName)) {
                this.savePropertyDefinition();
                this.id = null;
                this.type = null;
                this.required = null;
                this.defaultValue = null;
                this.fixedValue = null;
                this.advanced = null;
                this.masked = null;
                this.index = null;
                this.allowedValue.setLength(0);
                this.allowedValues.clear();
                this.propDefn = null;
                this.descriptions.clear();
                this.displayNames.clear();
                this.currentDescriptionLocale = null;
                this.currentDescriptionText.setLength(0);
                this.currentDisplayNameLocale = null;
                this.currentDisplayNameText.setLength(0);
            } else if ("extendedMetaclass".equals(localName)) {
                if (this.metaclassName != null && !this.metaclassName.isEmpty()) {
                    this.definition.addMetaclass(this.metaclassName);
                }
                this.metaclassName = null;
            } else if ("allowedValue".equals(localName)) {
                this.allowedValues.add(this.allowedValue.toString());
                this.allowedValue.setLength(0);
            } else if ("modelExtension".equals(localName)) {
                if (this.definition != null) {
                    this.definition.setDescription(this.description.toString());
                }
                this.saveModelExtensionDefinitionProperties();
            } else if ("modelType".equals(localName)) {
                this.assistant.addSupportedModelType(this.modelType.toString());
                this.modelType.setLength(0);
            }
            this.elements.pop();
            super.endElement(uri, localName, qName);
        }

        @Override
        public void error(SAXParseException e) {
            this.errors.add(e.getLocalizedMessage());
        }

        @Override
        public void fatalError(SAXParseException e) {
            this.fatals.add(e.getLocalizedMessage());
        }

        private String getCurrentElement() {
            if (this.elements.empty()) {
                return null;
            }
            return this.elements.peek();
        }

        Collection<String> getErrors() {
            return this.errors;
        }

        Collection<String> getFatalErrors() {
            return this.fatals;
        }

        Collection<String> getInfos() {
            return this.infos;
        }

        ModelExtensionDefinition getModelExtensionDefinition() {
            return this.definition;
        }

        private String getPreviousElement() {
            if (this.elements.size() > 1) {
                return (String)this.elements.get(this.elements.size() - 2);
            }
            return null;
        }

        Collection<String> getWarnings() {
            return this.warnings;
        }

        private void saveModelExtensionDefinitionProperties() {
            for (Map.Entry<String, Collection<ModelExtensionPropertyDefinition>> entry : this.properties.entrySet()) {
                String extendedMetaclassName = entry.getKey();
                for (ModelExtensionPropertyDefinition propDefn : entry.getValue()) {
                    this.assistant.addPropertyDefinition(extendedMetaclassName, propDefn);
                }
            }
        }

        private void savePropertyDefinition() {
            this.propDefn = this.assistant.createPropertyDefinition(this.id, this.type, this.required, this.defaultValue, this.fixedValue, this.advanced, this.masked, this.index, this.allowedValues, this.descriptions, this.displayNames);
            assert (this.metaclassName != null) : "metaclassName is null";
            Collection<ModelExtensionPropertyDefinition> props = this.properties.get(this.metaclassName);
            if (props == null) {
                props = new ArrayList<ModelExtensionPropertyDefinition>();
                this.properties.put(this.metaclassName, props);
            }
            props.add(this.propDefn);
        }

        @Override
        public void skippedEntity(String name) {
            this.infos.add(NLS.bind((String)Messages.parserFoundUnparsedEntityDeclaration, (Object)name));
        }

        @Override
        public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
            this.elements.push(localName);
            if ("modelExtension".equals(this.getCurrentElement())) {
                this.namespacePrefix = attributes.getValue("namespacePrefix");
                this.namespaceUri = attributes.getValue("namespaceUri");
                this.metamodelUri = attributes.getValue("metamodelUri");
                this.version = attributes.getValue("version");
                this.definition = this.assistant.createModelExtensionDefinition(this.namespacePrefix, this.namespaceUri, this.metamodelUri, null, this.description.toString(), this.version);
            } else if ("extendedMetaclass".equals(this.getCurrentElement())) {
                this.metaclassName = attributes.getValue("name");
            } else if ("property".equals(this.getCurrentElement())) {
                this.id = attributes.getValue("name");
                this.type = attributes.getValue("type");
                this.required = attributes.getValue("required");
                this.defaultValue = attributes.getValue("defaultValue");
                this.fixedValue = attributes.getValue("fixedValue");
                this.advanced = attributes.getValue("advanced");
                this.masked = attributes.getValue("masked");
                this.index = attributes.getValue("index");
            } else if ("display".equals(this.getCurrentElement())) {
                this.currentDisplayNameLocale = attributes.getValue("locale");
            } else if ("description".equals(this.getCurrentElement()) && "property".equals(this.getPreviousElement())) {
                this.currentDescriptionLocale = attributes.getValue("locale");
            }
            super.startElement(uri, localName, qName, attributes);
        }

        @Override
        public void warning(SAXParseException e) {
            this.warnings.add(e.getLocalizedMessage());
        }

        @Override
        public void unparsedEntityDecl(String name, String publicId, String systemId, String notationName) {
            this.infos.add(NLS.bind((String)Messages.parserFoundUnparsedEntityDeclaration, (Object)name));
        }
    }
}

