/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.extension.definition;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArrayList;
import org.eclipse.osgi.util.NLS;
import org.teiid.core.designer.HashCodeUtil;
import org.teiid.core.designer.util.CoreArgCheck;
import org.teiid.core.designer.util.CoreStringUtil;
import org.teiid.designer.extension.ExtensionPlugin;
import org.teiid.designer.extension.Messages;
import org.teiid.designer.extension.definition.ModelExtensionDefinition;

public class ModelExtensionDefinitionHeader {
    public static final int DEFAULT_VERSION = 1;
    private String description;
    private final CopyOnWriteArrayList<PropertyChangeListener> listeners = new CopyOnWriteArrayList();
    private String metamodelUri;
    private Set<String> modelTypes;
    private String namespacePrefix;
    private String namespaceUri;
    private int version = 1;

    public ModelExtensionDefinitionHeader() {
    }

    public ModelExtensionDefinitionHeader(String namespacePrefix, String namespaceUri, String metamodelUri, Set<String> modelTypes, String description, int version) {
        this();
        this.namespacePrefix = namespacePrefix;
        this.namespaceUri = namespaceUri;
        this.metamodelUri = metamodelUri;
        this.modelTypes = modelTypes;
        this.description = description;
        this.version = version;
    }

    public boolean addListener(PropertyChangeListener listener) {
        CoreArgCheck.isNotNull((Object)listener, (String)"listener is null");
        return this.listeners.addIfAbsent(listener);
    }

    public boolean addModelType(String modelType) {
        boolean added;
        CoreArgCheck.isNotEmpty((String)modelType, (String)"modelType is empty");
        if (this.modelTypes == null) {
            this.modelTypes = new HashSet<String>(1);
        }
        if (added = this.modelTypes.add(modelType)) {
            this.notifyChangeListeners(ModelExtensionDefinition.PropertyName.MODEL_TYPES, null, modelType);
        }
        return added;
    }

    public void clearModelTypes() {
        if (this.modelTypes != null) {
            this.modelTypes.clear();
        }
    }

    public final boolean equals(Object object) {
        boolean otherEmpty;
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        ModelExtensionDefinitionHeader other = (ModelExtensionDefinitionHeader)object;
        boolean thisEmpty = this.modelTypes == null || this.modelTypes.isEmpty();
        boolean bl = otherEmpty = other.modelTypes == null || other.modelTypes.isEmpty();
        if (thisEmpty != otherEmpty) {
            return false;
        }
        if (!thisEmpty) {
            if (this.modelTypes.size() != other.modelTypes.size()) {
                return false;
            }
            for (String modelType : this.modelTypes) {
                if (other.modelTypes.contains(modelType)) continue;
                return false;
            }
        }
        return CoreStringUtil.valuesAreEqual((String)this.namespacePrefix, (String)other.namespacePrefix) && CoreStringUtil.valuesAreEqual((String)this.namespaceUri, (String)other.namespaceUri) && CoreStringUtil.valuesAreEqual((String)this.metamodelUri, (String)other.metamodelUri) && CoreStringUtil.valuesAreEqual((String)this.description, (String)other.description) && this.version == other.version;
    }

    public String getDescription() {
        return this.description;
    }

    public String getMetamodelUri() {
        return this.metamodelUri;
    }

    public String getNamespacePrefix() {
        return this.namespacePrefix;
    }

    public String getNamespaceUri() {
        return this.namespaceUri;
    }

    public Set<String> getSupportedModelTypes() {
        if (this.modelTypes == null) {
            return Collections.emptySet();
        }
        return Collections.unmodifiableSet(this.modelTypes);
    }

    public int getVersion() {
        return this.version;
    }

    public int hashCode() {
        int result = HashCodeUtil.hashCode((int)0, (int)this.getVersion());
        if (this.getNamespacePrefix() != null && !this.getNamespacePrefix().isEmpty()) {
            result = HashCodeUtil.hashCode((int)result, (Object[])new Object[]{this.getNamespacePrefix()});
        }
        if (this.getMetamodelUri() != null && !this.getMetamodelUri().isEmpty()) {
            result = HashCodeUtil.hashCode((int)result, (Object[])new Object[]{this.getMetamodelUri()});
        }
        if (this.getNamespaceUri() != null && !this.getNamespaceUri().isEmpty()) {
            result = HashCodeUtil.hashCode((int)result, (Object[])new Object[]{this.getNamespaceUri()});
        }
        if (this.getDescription() != null && !this.getDescription().isEmpty()) {
            result = HashCodeUtil.hashCode((int)result, (Object[])new Object[]{this.getDescription()});
        }
        if (this.modelTypes != null && !this.modelTypes.isEmpty()) {
            if (this.modelTypes.size() == 1) {
                result = HashCodeUtil.hashCode((int)result, (Object[])new Object[]{this.modelTypes.iterator().next()});
            } else {
                ArrayList<String> sortedModelTypes = new ArrayList<String>(this.modelTypes);
                Collections.sort(sortedModelTypes);
                for (String modelType : sortedModelTypes) {
                    result = HashCodeUtil.hashCode((int)result, (Object[])new Object[]{modelType});
                }
            }
        }
        return result;
    }

    private void notifyChangeListeners(ModelExtensionDefinition.PropertyName property, Object oldValue, Object newValue) {
        PropertyChangeEvent event = new PropertyChangeEvent(this, property.toString(), oldValue, newValue);
        Object[] objectArray = this.listeners.toArray();
        int n = objectArray.length;
        int n2 = 0;
        while (n2 < n) {
            Object listener = objectArray[n2];
            try {
                ((PropertyChangeListener)listener).propertyChange(event);
            }
            catch (Exception e) {
                ExtensionPlugin.Util.log((Throwable)e);
                this.listeners.remove(listener);
            }
            ++n2;
        }
    }

    public boolean removeListener(PropertyChangeListener listener) {
        CoreArgCheck.isNotNull((Object)listener, (String)"listener is null");
        return this.listeners.remove(listener);
    }

    public boolean removeModelType(String modelType) {
        CoreArgCheck.isNotEmpty((String)modelType, (String)"modelType is empty");
        boolean removed = false;
        if (this.modelTypes != null) {
            removed = this.modelTypes.remove(modelType);
        }
        if (removed) {
            this.notifyChangeListeners(ModelExtensionDefinition.PropertyName.MODEL_TYPES, modelType, null);
        }
        return removed;
    }

    public void setDescription(String newDescription) {
        String currentValue = this.getDescription();
        if (!CoreStringUtil.equals((String)currentValue, (String)newDescription)) {
            String oldValue = newDescription;
            this.description = newDescription;
            this.notifyChangeListeners(ModelExtensionDefinition.PropertyName.DESCRIPTION, oldValue, newDescription);
        }
    }

    public void setMetamodelUri(String newMetamodelUri) {
        String currentValue = this.getMetamodelUri();
        if (!CoreStringUtil.equals((String)currentValue, (String)newMetamodelUri)) {
            String oldValue = currentValue;
            this.metamodelUri = newMetamodelUri;
            this.notifyChangeListeners(ModelExtensionDefinition.PropertyName.METAMODEL_URI, oldValue, newMetamodelUri);
        }
    }

    public void setNamespacePrefix(String newNamespacePrefix) {
        String currentValue = this.getNamespacePrefix();
        if (!CoreStringUtil.equals((String)currentValue, (String)newNamespacePrefix)) {
            String oldValue = currentValue;
            this.namespacePrefix = newNamespacePrefix;
            this.notifyChangeListeners(ModelExtensionDefinition.PropertyName.NAMESPACE_PREFIX, oldValue, newNamespacePrefix);
        }
    }

    public void setNamespaceUri(String newNamespaceUri) {
        String currentValue = this.getNamespaceUri();
        if (!CoreStringUtil.equals((String)currentValue, (String)newNamespaceUri)) {
            String oldValue = currentValue;
            this.namespaceUri = newNamespaceUri;
            this.notifyChangeListeners(ModelExtensionDefinition.PropertyName.NAMESPACE_URI, oldValue, newNamespaceUri);
        }
    }

    public void setVersion(int newVersion) {
        int currentValue = this.getVersion();
        if (currentValue != newVersion) {
            if (newVersion < 1) {
                ExtensionPlugin.Util.log(4, NLS.bind((String)Messages.invalidDefinitionFileNewVersion, (Object[])new Object[]{this.getNamespacePrefix(), newVersion, currentValue}));
                return;
            }
            Integer oldValue = currentValue;
            this.version = newVersion;
            this.notifyChangeListeners(ModelExtensionDefinition.PropertyName.VERSION, oldValue, newVersion);
        }
    }

    public boolean supportsModelType(String modelType) {
        CoreArgCheck.isNotEmpty((String)modelType, (String)"modelType is empty");
        if (this.modelTypes == null || this.modelTypes.isEmpty()) {
            return true;
        }
        return this.modelTypes.contains(modelType);
    }

    public String toString() {
        StringBuilder text = new StringBuilder();
        text.append("Model Extension Definition Header: ");
        text.append("namespacePrefix=").append(this.getNamespacePrefix());
        text.append(", namespaceUri=").append(this.getNamespaceUri());
        text.append(", metamodelUri=").append(this.getMetamodelUri());
        text.append(", version=").append(this.getVersion());
        if (this.modelTypes != null) {
            for (String modelType : this.modelTypes) {
                text.append(", supported model type=").append(modelType);
            }
        }
        return text.toString();
    }
}

