/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.metamodels.relational.util;

import java.util.List;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.teiid.core.designer.ModelerCoreException;
import org.teiid.designer.core.ModelerCore;
import org.teiid.designer.core.util.ModelVisitor;
import org.teiid.designer.core.util.ModelVisitorProcessor;
import org.teiid.designer.extension.ExtensionPlugin;
import org.teiid.designer.extension.registry.ModelExtensionRegistry;
import org.teiid.designer.metamodels.relational.AccessPattern;
import org.teiid.designer.metamodels.relational.BaseTable;
import org.teiid.designer.metamodels.relational.Catalog;
import org.teiid.designer.metamodels.relational.Column;
import org.teiid.designer.metamodels.relational.ForeignKey;
import org.teiid.designer.metamodels.relational.Index;
import org.teiid.designer.metamodels.relational.PrimaryKey;
import org.teiid.designer.metamodels.relational.Procedure;
import org.teiid.designer.metamodels.relational.ProcedureParameter;
import org.teiid.designer.metamodels.relational.ProcedureResult;
import org.teiid.designer.metamodels.relational.RelationalPlugin;
import org.teiid.designer.metamodels.relational.Schema;
import org.teiid.designer.metamodels.relational.Table;
import org.teiid.designer.metamodels.relational.UniqueConstraint;
import org.teiid.designer.metamodels.relational.extension.RelationalModelExtensionAssistant;
import org.teiid.designer.metamodels.relational.extension.RelationalModelExtensionConstants;
import org.teiid.designer.metamodels.relational.util.BaseTableColumnFinder;
import org.teiid.designer.metamodels.relational.util.BaseTableFinder;
import org.teiid.designer.metamodels.relational.util.CatalogFinder;
import org.teiid.designer.metamodels.relational.util.ColumnFinder;
import org.teiid.designer.metamodels.relational.util.ForeignKeyFinder;
import org.teiid.designer.metamodels.relational.util.IndexFinder;
import org.teiid.designer.metamodels.relational.util.KeyFinder;
import org.teiid.designer.metamodels.relational.util.LogicalRelationshipEndFinder;
import org.teiid.designer.metamodels.relational.util.LogicalRelationshipFinder;
import org.teiid.designer.metamodels.relational.util.ProcedureFinder;
import org.teiid.designer.metamodels.relational.util.ProcedureParameterFinder;
import org.teiid.designer.metamodels.relational.util.RelationalEntityFinder;
import org.teiid.designer.metamodels.relational.util.SchemaFinder;
import org.teiid.designer.metamodels.relational.util.TableFinder;
import org.teiid.designer.metamodels.relational.util.UniqueKeyFinder;

public class RelationalUtil {
    private RelationalUtil() {
    }

    protected static void executeVisitor(Object container, ModelVisitor visitor, int depth) {
        ModelVisitorProcessor processor = new ModelVisitorProcessor(visitor);
        try {
            if (container instanceof Resource) {
                processor.walk((Resource)container, depth);
            } else if (container instanceof EObject) {
                processor.walk((EObject)container, depth);
            }
        }
        catch (ModelerCoreException e) {
            ModelerCore.Util.log((Throwable)e);
        }
    }

    public static List findUniqueKeys(Object container) {
        return RelationalUtil.findUniqueKeys(container, 2);
    }

    public static List findUniqueKeys(Object container, int depth) {
        UniqueKeyFinder finder = new UniqueKeyFinder();
        return RelationalUtil.findObjects(finder, container, depth);
    }

    public static List findForeignKeys(Object container) {
        return RelationalUtil.findForeignKeys(container, 2);
    }

    public static List findForeignKeys(Object container, int depth) {
        ForeignKeyFinder finder = new ForeignKeyFinder();
        return RelationalUtil.findObjects(finder, container, depth);
    }

    public static List findKeys(Object container) {
        return RelationalUtil.findKeys(container, 2);
    }

    public static List findKeys(Object container, int depth) {
        KeyFinder finder = new KeyFinder();
        return RelationalUtil.findObjects(finder, container, depth);
    }

    public static List findIndexes(Object container) {
        return RelationalUtil.findIndexes(container, 2);
    }

    public static List findIndexes(Object container, int depth) {
        IndexFinder finder = new IndexFinder();
        return RelationalUtil.findObjects(finder, container, depth);
    }

    public static List findTables(Object container) {
        return RelationalUtil.findTables(container, 2);
    }

    public static List findTables(Object container, int depth) {
        TableFinder finder = new TableFinder();
        return RelationalUtil.findObjects(finder, container, depth);
    }

    public static List findProcedures(Object container) {
        return RelationalUtil.findProcedures(container, 2);
    }

    public static List findProcedures(Object container, int depth) {
        ProcedureFinder finder = new ProcedureFinder();
        return RelationalUtil.findObjects(finder, container, depth);
    }

    public static List findProcedureParameters(Object container) {
        return RelationalUtil.findProcedureParameters(container, 2);
    }

    public static List findProcedureParameters(Object container, int depth) {
        ProcedureParameterFinder finder = new ProcedureParameterFinder();
        return RelationalUtil.findObjects(finder, container, depth);
    }

    public static List findBaseTables(Object container) {
        return RelationalUtil.findBaseTables(container, 2);
    }

    public static List findBaseTables(Object container, int depth) {
        BaseTableFinder finder = new BaseTableFinder();
        return RelationalUtil.findObjects(finder, container, depth);
    }

    public static List findColumns(Object container) {
        return RelationalUtil.findColumns(container, 2);
    }

    public static List findColumns(Object container, int depth) {
        ColumnFinder finder = new ColumnFinder();
        return RelationalUtil.findObjects(finder, container, depth);
    }

    public static List findBaseTableColumns(Object container) {
        return RelationalUtil.findBaseTableColumns(container, 2);
    }

    public static List findBaseTableColumns(Object container, int depth) {
        BaseTableColumnFinder finder = new BaseTableColumnFinder();
        return RelationalUtil.findObjects(finder, container, depth);
    }

    public static List findLogicalRelationships(Object container) {
        return RelationalUtil.findLogicalRelationships(container, 2);
    }

    public static List findLogicalRelationships(Object container, int depth) {
        LogicalRelationshipFinder finder = new LogicalRelationshipFinder();
        return RelationalUtil.findObjects(finder, container, depth);
    }

    public static List findLogicalRelationshipEnds(Object container) {
        return RelationalUtil.findLogicalRelationshipEnds(container, 2);
    }

    public static List findLogicalRelationshipEnds(Object container, int depth) {
        LogicalRelationshipEndFinder finder = new LogicalRelationshipEndFinder();
        return RelationalUtil.findObjects(finder, container, depth);
    }

    public static List findSchemas(Object container) {
        return RelationalUtil.findSchemas(container, 2);
    }

    public static List findSchemas(Object container, int depth) {
        SchemaFinder finder = new SchemaFinder();
        return RelationalUtil.findObjects(finder, container, depth);
    }

    public static List findCatalogs(Object container) {
        return RelationalUtil.findCatalogs(container, 2);
    }

    public static List findCatalogs(Object container, int depth) {
        CatalogFinder finder = new CatalogFinder();
        return RelationalUtil.findObjects(finder, container, depth);
    }

    private static List findObjects(RelationalEntityFinder finder, Object container, int depth) {
        RelationalUtil.executeVisitor(container, finder, depth);
        finder.removeContainer(container);
        return finder.getObjects();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static boolean addChildToParent(EObject child, EObject parent) {
        if (parent instanceof BaseTable) {
            if (child instanceof Column) {
                ((BaseTable)parent).getColumns().add((Object)child);
                return true;
            } else if (child instanceof PrimaryKey) {
                ((BaseTable)parent).setPrimaryKey((PrimaryKey)child);
                return true;
            } else if (child instanceof ForeignKey) {
                ((BaseTable)parent).getForeignKeys().add((Object)child);
                return true;
            } else if (child instanceof UniqueConstraint) {
                ((BaseTable)parent).getUniqueConstraints().add((Object)((UniqueConstraint)child));
                return true;
            } else {
                if (!(child instanceof AccessPattern)) return false;
                ((BaseTable)parent).getAccessPatterns().add((Object)child);
            }
            return true;
        } else if (parent instanceof Schema) {
            if (child instanceof Table) {
                ((Schema)parent).getTables().add((Object)child);
                return true;
            } else if (child instanceof Index) {
                ((Schema)parent).getIndexes().add((Object)child);
                return true;
            } else {
                if (!(child instanceof Procedure)) return false;
                ((Schema)parent).getProcedures().add((Object)child);
            }
            return true;
        } else if (parent instanceof Catalog) {
            if (child instanceof Table) {
                ((Catalog)parent).getTables().add((Object)child);
                return true;
            } else if (child instanceof Index) {
                ((Catalog)parent).getIndexes().add((Object)child);
                return true;
            } else if (child instanceof Schema) {
                ((Catalog)parent).getSchemas().add((Object)child);
                return true;
            } else {
                if (!(child instanceof Procedure)) return false;
                ((Schema)parent).getProcedures().add((Object)child);
            }
            return true;
        } else if (parent instanceof Procedure) {
            if (child instanceof ProcedureParameter) {
                ((Procedure)parent).getParameters().add((Object)child);
                return true;
            } else {
                if (!(child instanceof ProcedureResult)) return false;
                ((Procedure)parent).setResult((ProcedureResult)child);
            }
            return true;
        } else {
            if (!(parent instanceof ProcedureResult)) return false;
            if (!(child instanceof Column)) return false;
            ((ProcedureResult)parent).getColumns().add((Object)child);
        }
        return true;
    }

    public static boolean isGlobalTempTable(EObject eObject) {
        ModelExtensionRegistry registry = ExtensionPlugin.getInstance().getRegistry();
        String prefix = RelationalModelExtensionConstants.NAMESPACE_PROVIDER.getNamespacePrefix();
        RelationalModelExtensionAssistant assistant = (RelationalModelExtensionAssistant)registry.getModelExtensionAssistant(prefix);
        boolean result = false;
        if (assistant != null) {
            try {
                String resultString = assistant.getPropertyValue(eObject, RelationalModelExtensionConstants.PropertyIds.GLOBAL_TEMP_TABLE);
                if (resultString != null) {
                    result = Boolean.parseBoolean(resultString);
                }
            }
            catch (Exception ex) {
                RelationalPlugin.Util.log(4, (Throwable)ex, ex.getMessage());
            }
        }
        return result;
    }

    public static RelationalModelExtensionAssistant getRelationalExtensionAssistant() {
        ModelExtensionRegistry registry = ExtensionPlugin.getInstance().getRegistry();
        String prefix = RelationalModelExtensionConstants.NAMESPACE_PROVIDER.getNamespacePrefix();
        RelationalModelExtensionAssistant assistant = (RelationalModelExtensionAssistant)registry.getModelExtensionAssistant(prefix);
        return assistant;
    }
}

