/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.metamodels.relational.aspects.validation.rules;

import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.teiid.designer.core.validation.ValidationContext;
import org.teiid.designer.core.validation.ValidationResult;
import org.teiid.designer.core.validation.ValidationResultImpl;
import org.teiid.designer.core.validation.rules.CoreValidationRulesUtil;
import org.teiid.designer.core.validation.rules.StringNameRule;
import org.teiid.designer.core.validation.rules.StringNameValidator;
import org.teiid.designer.metamodels.relational.AccessPattern;
import org.teiid.designer.metamodels.relational.Catalog;
import org.teiid.designer.metamodels.relational.Column;
import org.teiid.designer.metamodels.relational.ForeignKey;
import org.teiid.designer.metamodels.relational.Index;
import org.teiid.designer.metamodels.relational.LogicalRelationship;
import org.teiid.designer.metamodels.relational.Procedure;
import org.teiid.designer.metamodels.relational.ProcedureParameter;
import org.teiid.designer.metamodels.relational.Schema;
import org.teiid.designer.metamodels.relational.Table;
import org.teiid.designer.metamodels.relational.UniqueKey;
import org.teiid.designer.metamodels.relational.aspects.validation.RelationalStringNameValidator;
import org.teiid.designer.metamodels.relational.util.RelationalUtil;

public class RelationalStringNameRule
extends StringNameRule {
    public RelationalStringNameRule(int featureID) {
        super(featureID);
    }

    public List getSiblingsForUniquenessCheck(EObject eObject) {
        EObject parent = eObject.eContainer();
        if (parent == null) {
            parent = eObject.eResource();
        }
        if (eObject instanceof Table) {
            return RelationalUtil.findTables(parent, 1);
        }
        if (eObject instanceof Procedure) {
            return RelationalUtil.findProcedures(parent, 1);
        }
        if (eObject instanceof ProcedureParameter) {
            return RelationalUtil.findProcedureParameters(parent, 1);
        }
        if (eObject instanceof Index) {
            return RelationalUtil.findIndexes(parent, 1);
        }
        if (eObject instanceof ForeignKey || eObject instanceof UniqueKey) {
            return RelationalUtil.findKeys(parent, 1);
        }
        if (eObject instanceof Column) {
            return RelationalUtil.findColumns(parent, 1);
        }
        if (eObject instanceof AccessPattern) {
            if (parent instanceof Table) {
                return ((Table)parent).getAccessPatterns();
            }
            return new LinkedList();
        }
        if (eObject instanceof LogicalRelationship) {
            return RelationalUtil.findLogicalRelationships(parent, 1);
        }
        if (eObject instanceof Schema) {
            return RelationalUtil.findSchemas(parent, 1);
        }
        if (eObject instanceof Catalog) {
            return RelationalUtil.findCatalogs(parent, 1);
        }
        return super.getSiblingsForUniquenessCheck(eObject);
    }

    public void validate(EStructuralFeature eStructuralFeature, EObject eObject, Object value, ValidationContext context) {
        if (eStructuralFeature.getFeatureID() != this.getFeatureID()) {
            return;
        }
        if (!(value instanceof String)) {
            return;
        }
        int status = this.getPreferenceStatus(context);
        boolean restrictChars = false;
        if (status != 0) {
            restrictChars = true;
        }
        String name = (String)value;
        ValidationResultImpl result = new ValidationResultImpl((Object)eObject);
        if (this.validateCharacters()) {
            RelationalStringNameValidator validator = new RelationalStringNameValidator(eObject instanceof Table, restrictChars);
            CoreValidationRulesUtil.validateStringNameChars((ValidationResult)result, (String)name, (StringNameValidator)validator, (int)status);
        }
        context.addResult((ValidationResult)result);
        String objType = eObject.eClass().getName();
        if (!context.hasRunRule(eObject, String.valueOf(this.getRuleName()) + objType) && this.validateUniqueness()) {
            List siblings = this.getSiblingsForUniquenessCheck(eObject);
            if (eObject instanceof Procedure) {
                siblings = this.removeDuplicateSourceProcs(siblings);
            } else if (eObject instanceof ProcedureParameter) {
                siblings = this.removeDuplicateSourceProcParms(siblings);
            }
            CoreValidationRulesUtil.validateUniqueness((ValidationContext)context, (List)siblings, (int)this.getFeatureID());
            context.recordRuleRun(eObject, String.valueOf(this.getRuleName()) + objType);
        }
    }

    private List removeDuplicateSourceProcs(List siblings) {
        ArrayList<Procedure> resultProcs = new ArrayList<Procedure>();
        ArrayList<String> sourceProcNames = new ArrayList<String>();
        for (Object proc : siblings) {
            if (proc == null || !(proc instanceof Procedure)) continue;
            Procedure theProc = (Procedure)proc;
            if (!theProc.isFunction()) {
                resultProcs.add(theProc);
                continue;
            }
            EStructuralFeature eFeature = theProc.eClass().getEStructuralFeature(this.getFeatureID());
            String nameUpper = ((String)theProc.eGet(eFeature)).toUpperCase();
            if (sourceProcNames.contains(nameUpper)) continue;
            sourceProcNames.add(nameUpper);
            resultProcs.add(theProc);
        }
        return resultProcs;
    }

    private List removeDuplicateSourceProcParms(List siblings) {
        ArrayList<ProcedureParameter> resultProcParams = new ArrayList<ProcedureParameter>();
        ArrayList<String> sourceProcParamNames = new ArrayList<String>();
        for (Object procParam : siblings) {
            EStructuralFeature eFeature;
            ProcedureParameter theProcParam;
            String nameUpper;
            if (procParam == null || !(procParam instanceof ProcedureParameter) || sourceProcParamNames.contains(nameUpper = ((String)(theProcParam = (ProcedureParameter)procParam).eGet(eFeature = theProcParam.eClass().getEStructuralFeature(this.getFeatureID()))).toUpperCase())) continue;
            sourceProcParamNames.add(nameUpper);
            resultProcParams.add(theProcParam);
        }
        return resultProcParams;
    }

    protected int getPreferenceStatus(ValidationContext context) {
        return context.getPreferenceStatus("relationalPreferences.nameCharacterRestriction", 0);
    }
}

