/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.metamodels.relational.aspects.validation.rules;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.ecore.EObject;
import org.teiid.core.designer.util.CoreStringUtil;
import org.teiid.designer.core.ModelerCore;
import org.teiid.designer.core.validation.ObjectValidationRule;
import org.teiid.designer.core.validation.ValidationContext;
import org.teiid.designer.core.validation.ValidationProblem;
import org.teiid.designer.core.validation.ValidationProblemImpl;
import org.teiid.designer.core.validation.ValidationResult;
import org.teiid.designer.core.validation.ValidationResultImpl;
import org.teiid.designer.metamodels.core.ModelAnnotation;
import org.teiid.designer.metamodels.core.ModelType;
import org.teiid.designer.metamodels.relational.Index;
import org.teiid.designer.metamodels.relational.Procedure;
import org.teiid.designer.metamodels.relational.RelationalEntity;
import org.teiid.designer.metamodels.relational.RelationalPlugin;
import org.teiid.designer.metamodels.relational.Table;
import org.teiid.designer.metamodels.relational.util.RelationalUtil;

public class RelationalChildrenNameValidationRule
implements ObjectValidationRule {
    private static final String nameFeatureName = RelationalPlugin.Util.getString("_UI_RelationalEntity_name_feature", new Object[0]);
    private static final String RULE_NAME = RelationalChildrenNameValidationRule.class.getName();

    public void validate(EObject eObject, ValidationContext context) {
        if (!this.shouldRun(eObject, context)) {
            return;
        }
        List siblings = this.getSiblingsForUniqueNameCheck(eObject);
        if (siblings.isEmpty()) {
            return;
        }
        int statusForCaseSensitive = this.getPreferenceStatus(context);
        int statusForCaseInsensitive = statusForCaseSensitive == 4 ? 2 : statusForCaseSensitive;
        ValidationResults validationResults = new ValidationResults(siblings.size());
        int i = 0;
        while (i < siblings.size()) {
            EObject siblingI = (EObject)siblings.get(i);
            String nameA = this.getName(siblingI);
            ValidationResult result = validationResults.get(i, siblingI);
            if (!CoreStringUtil.isEmpty((String)nameA)) {
                int j = i + 1;
                while (j < siblings.size()) {
                    EObject siblingJ = (EObject)siblings.get(j);
                    String nameB = this.getName(siblings.get(j));
                    if (!CoreStringUtil.isEmpty((String)nameB)) {
                        ValidationProblemImpl problemJ;
                        ValidationResult resultJ;
                        ValidationProblemImpl problem;
                        String msg;
                        Object[] params;
                        if (nameA.equals(nameB)) {
                            params = new Object[]{nameA, nameB, nameFeatureName};
                            msg = RelationalPlugin.Util.getString("RelationalChildrenNameValidationRule.failure_message_case_sensitive", params);
                            problem = new ValidationProblemImpl(0, statusForCaseSensitive, msg);
                            problem.setHasPreference(context.hasPreferences());
                            result.addProblem((ValidationProblem)problem);
                            resultJ = validationResults.get(j, siblingJ);
                            problemJ = new ValidationProblemImpl(0, statusForCaseSensitive, msg);
                            problemJ.setHasPreference(context.hasPreferences());
                            resultJ.addProblem((ValidationProblem)problemJ);
                        } else if (nameA.equalsIgnoreCase(nameB)) {
                            params = new Object[]{nameA, nameB, nameFeatureName};
                            msg = RelationalPlugin.Util.getString("RelationalChildrenNameValidationRule.failure_message_case_insensitive", params);
                            problem = new ValidationProblemImpl(0, statusForCaseInsensitive, msg);
                            problem.setHasPreference(context.hasPreferences());
                            result.addProblem((ValidationProblem)problem);
                            resultJ = validationResults.get(j, siblingJ);
                            problemJ = new ValidationProblemImpl(0, statusForCaseInsensitive, msg);
                            problemJ.setHasPreference(context.hasPreferences());
                            resultJ.addProblem((ValidationProblem)problemJ);
                        }
                    }
                    ++j;
                }
            }
            context.addResult(result);
            ++i;
        }
    }

    protected int getPreferenceStatus(ValidationContext context) {
        return context.getPreferenceStatus("relationalPreferences.siblingName", 0);
    }

    protected List getSiblingsForUniqueNameCheck(EObject eObject) {
        EObject parent = eObject.eContainer();
        if (parent == null) {
            parent = eObject.eResource();
        }
        if (eObject instanceof Table || eObject instanceof Procedure || eObject instanceof Index) {
            ArrayList siblings = new ArrayList();
            siblings.addAll(RelationalUtil.findTables(parent, 1));
            siblings.addAll(RelationalUtil.findProcedures(parent, 1));
            siblings.addAll(RelationalUtil.findIndexes(parent, 1));
            return siblings;
        }
        return Collections.EMPTY_LIST;
    }

    private String getName(Object sibling) {
        if (sibling instanceof RelationalEntity) {
            RelationalEntity entity = (RelationalEntity)sibling;
            return entity.getName();
        }
        return ModelerCore.getModelEditor().getModelRelativePathIncludingModel((EObject)sibling).toString();
    }

    private boolean shouldRun(EObject eObject, ValidationContext context) {
        if (this.getPreferenceStatus(context) == 0) {
            return false;
        }
        try {
            ModelAnnotation modelAnnotation = ModelerCore.getModelEditor().getModelAnnotation(eObject);
            int modelType = modelAnnotation.getModelType().getValue();
            if (modelType != ModelType.PHYSICAL) {
                return false;
            }
        }
        catch (Exception e) {
            RelationalPlugin.Util.log(4, (Throwable)e, e.getMessage());
        }
        String objType = eObject.eClass().getName();
        if (context.hasRunRule(eObject, String.valueOf(RULE_NAME) + objType)) {
            return false;
        }
        context.recordRuleRun(eObject, String.valueOf(RULE_NAME) + objType);
        return true;
    }

    protected class ValidationResults {
        private final ValidationResult[] results;

        public ValidationResults(int size) {
            this.results = new ValidationResult[size];
        }

        public ValidationResult get(int index, EObject object) {
            ValidationResult result = this.results[index];
            if (result == null) {
                this.results[index] = result = new ValidationResultImpl((Object)object);
            }
            return result;
        }
    }
}

