/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.metamodels.relational.aspects.validation.rules;

import org.eclipse.emf.ecore.EObject;
import org.teiid.core.designer.util.CoreArgCheck;
import org.teiid.designer.core.types.DatatypeManager;
import org.teiid.designer.core.validation.ObjectValidationRule;
import org.teiid.designer.core.validation.ValidationContext;
import org.teiid.designer.core.validation.ValidationProblem;
import org.teiid.designer.core.validation.ValidationProblemImpl;
import org.teiid.designer.core.validation.ValidationResult;
import org.teiid.designer.core.validation.ValidationResultImpl;
import org.teiid.designer.metamodels.relational.Column;
import org.teiid.designer.metamodels.relational.RelationalPlugin;

public class MissingColumnPrecisionRule
implements ObjectValidationRule {
    public void validate(EObject eObject, ValidationContext context) {
        CoreArgCheck.isInstanceOf(Column.class, (Object)eObject);
        Column column = (Column)eObject;
        if (column.getPrecision() > 0) {
            return;
        }
        int status = this.getPreferenceStatus(context);
        if (status == 0) {
            return;
        }
        EObject type = column.getType();
        DatatypeManager dtMgr = context.getDatatypeManager();
        if (type != null && dtMgr.isNumeric(type)) {
            ValidationResultImpl result = new ValidationResultImpl((Object)eObject);
            Object[] params = new Object[]{};
            String msg = RelationalPlugin.Util.getString("MissingColumnPrecisionRule.failure_message", params);
            ValidationProblemImpl problem = new ValidationProblemImpl(0, status, msg);
            problem.setHasPreference(context.hasPreferences());
            result.addProblem((ValidationProblem)problem);
            context.addResult((ValidationResult)result);
        }
    }

    protected int getPreferenceStatus(ValidationContext context) {
        return context.getPreferenceStatus("relationalPreferences.missingColumnPrecision", 2);
    }
}

