/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.metamodels.relational.aspects.validation.rules;

import org.eclipse.emf.ecore.EObject;
import org.teiid.core.designer.util.CoreArgCheck;
import org.teiid.designer.core.types.DatatypeManager;
import org.teiid.designer.core.validation.ObjectValidationRule;
import org.teiid.designer.core.validation.ValidationContext;
import org.teiid.designer.core.validation.ValidationProblem;
import org.teiid.designer.core.validation.ValidationProblemImpl;
import org.teiid.designer.core.validation.ValidationResult;
import org.teiid.designer.core.validation.ValidationResultImpl;
import org.teiid.designer.metamodels.relational.Column;
import org.teiid.designer.metamodels.relational.ProcedureParameter;
import org.teiid.designer.metamodels.relational.RelationalPlugin;

public class CharDatatypeLengthRule
implements ObjectValidationRule {
    public void validate(EObject theObject, ValidationContext theContext) {
        CoreArgCheck.isTrue((theObject instanceof Column || theObject instanceof ProcedureParameter ? 1 : 0) != 0, (String)RelationalPlugin.Util.getString("CharDatatypeLengthRule.illegalObjectError", new Object[0]));
        EObject dataType = null;
        int length = 0;
        if (theObject instanceof Column) {
            dataType = ((Column)theObject).getType();
            length = ((Column)theObject).getLength();
        } else {
            dataType = ((ProcedureParameter)theObject).getType();
            length = ((ProcedureParameter)theObject).getLength();
        }
        if (dataType == null) {
            return;
        }
        DatatypeManager dtMgr = theContext.getDatatypeManager();
        boolean isBuiltInType = dtMgr.isBuiltInDatatype(dataType);
        String typeName = dtMgr.getName(dataType);
        if (!isBuiltInType || typeName == null || !typeName.equals("char")) {
            return;
        }
        if (length > 1) {
            String message = RelationalPlugin.Util.getString("CharDatatypeLengthRule.lengthGreaterThanOneMessage", new Object[0]);
            ValidationResultImpl result = new ValidationResultImpl((Object)theObject);
            result.addProblem((ValidationProblem)new ValidationProblemImpl(0, 2, message));
            theContext.addResult((ValidationResult)result);
        }
    }
}

