/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.xsd.ui.editor;

import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.TableWrapData;
import org.teiid.designer.ui.forms.ComponentSetEvent;
import org.teiid.designer.ui.forms.ComponentSetMonitor;
import org.teiid.designer.ui.forms.DialogProvider;
import org.teiid.designer.ui.forms.FormUtil;
import org.teiid.designer.ui.forms.LinkedComponentSet;
import org.teiid.designer.xsd.ui.editor.AbstractFacetSet;

public class TextFacetSet
extends AbstractFacetSet {
    private final int myStyle;
    final DialogProvider provider;
    Text text;
    private MyModifyListener modList;

    public TextFacetSet(String id, String labelName, int style, DialogProvider dialogProvider, boolean needsDescription) {
        super(id, labelName, true, needsDescription);
        this.myStyle = style;
        this.provider = dialogProvider;
    }

    @Override
    protected void addMainControl(Composite parent, FormToolkit ftk, ComponentSetMonitor mon) {
        this.modList = new MyModifyListener();
        this.text = ftk.createText(parent, null, this.myStyle);
        TableWrapData twd = new TableWrapData(256, 256);
        this.text.setLayoutData((Object)twd);
        if ((this.myStyle & 2) != 0) {
            twd.heightHint = 50;
        }
        this.text.addModifyListener((ModifyListener)this.modList);
        Button b = ftk.createButton(parent, this.provider.getLaunchButtonText(), 0);
        b.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                TextFacetSet.this.provider.showDialog(TextFacetSet.this.text.getShell(), (Object)TextFacetSet.this.text.getText());
                if (!TextFacetSet.this.provider.wasCancelled()) {
                    TextFacetSet.this.setMainValue(TextFacetSet.this.provider.getValue());
                }
            }
        });
        twd = new TableWrapData(2, 16);
        b.setLayoutData((Object)twd);
        this.modList.mon = mon;
    }

    @Override
    protected void setMainValue(Object value) {
        if (value != null) {
            this.text.setText((String)value);
        } else {
            this.text.setText("");
        }
    }

    @Override
    public int getControlCount() {
        return super.getControlCount() + 1;
    }

    class MyModifyListener
    implements ModifyListener {
        public ComponentSetMonitor mon;
        private String lastVal;

        MyModifyListener() {
        }

        public void modifyText(ModifyEvent e) {
            String newVal;
            if (this.mon != null && !FormUtil.safeEquals((Object)(newVal = TextFacetSet.this.text.getText()), (Object)this.lastVal)) {
                this.mon.update(new ComponentSetEvent((LinkedComponentSet)TextFacetSet.this, false, (Object)newVal));
                this.lastVal = newVal;
            }
        }
    }
}

