/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.xsd.ui.editor;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.teiid.designer.ui.forms.ComponentSetEvent;
import org.teiid.designer.ui.forms.ComponentSetMonitor;
import org.teiid.designer.ui.forms.LinkedComponentSet;
import org.teiid.designer.xsd.ui.editor.AbstractFacetSet;

public class ComboFacetSet
extends AbstractFacetSet {
    private final String[] optionNames;
    private final String defaultID;
    private Map idToName = new HashMap();
    private Map nameToID = new HashMap();
    private Combo combo;
    private MySelectionListener selList;

    public ComboFacetSet(String id, String name, String[] option_ids, String[] option_names, String defaultID) {
        super(id, name, true, false);
        this.optionNames = option_names;
        this.defaultID = defaultID;
        int i = 0;
        while (i < option_names.length) {
            String oname = option_names[i];
            String oid = option_ids[i];
            this.nameToID.put(oname, oid);
            this.idToName.put(oid, oname);
            ++i;
        }
    }

    @Override
    protected void addMainControl(Composite parent, FormToolkit ftk, ComponentSetMonitor mon) {
        this.init();
        this.combo = new Combo(parent, 12);
        ftk.adapt((Composite)this.combo);
        this.combo.setItems(this.optionNames);
        this.setMainValue(this.defaultID);
        this.combo.addSelectionListener((SelectionListener)this.selList);
        this.selList.mon = mon;
    }

    @Override
    protected void setMainValue(Object value) {
        String newVal = (String)this.idToName.get(value);
        if (newVal != null) {
            this.combo.setText(newVal);
        } else {
            newVal = (String)this.idToName.get(this.defaultID);
            if (newVal != null) {
                this.combo.setText(this.defaultID);
            } else {
                this.combo.setText("");
            }
        }
    }

    private void init() {
        if (this.selList == null) {
            this.selList = new MySelectionListener();
        }
    }

    Object getValue() {
        return this.nameToID.get(this.combo.getText());
    }

    class MySelectionListener
    extends SelectionAdapter {
        public ComponentSetMonitor mon;

        MySelectionListener() {
        }

        public void widgetSelected(SelectionEvent e) {
            if (this.mon != null) {
                this.mon.update(new ComponentSetEvent((LinkedComponentSet)ComboFacetSet.this, false, ComboFacetSet.this.getValue()));
            }
        }
    }
}

