/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.transformation.ui.wizards.xmlfile;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.datatools.connectivity.IConnectionProfile;
import org.eclipse.swt.widgets.Shell;
import org.teiid.core.designer.ModelerCoreException;
import org.teiid.designer.core.workspace.ModelResource;
import org.teiid.designer.core.workspace.ModelWorkspaceException;
import org.teiid.designer.core.workspace.ModelWorkspaceItem;
import org.teiid.designer.core.workspace.ModelWorkspaceManager;
import org.teiid.designer.datatools.profiles.ws.WSConnectionInfoProvider;
import org.teiid.designer.datatools.profiles.xml.XmlFileConnectionInfoProvider;
import org.teiid.designer.datatools.profiles.xml.XmlUrlConnectionInfoProvider;
import org.teiid.designer.transformation.ui.wizards.file.FlatFileRelationalModelFactory;
import org.teiid.designer.transformation.ui.wizards.file.TeiidMetadataImportInfo;
import org.teiid.designer.transformation.ui.wizards.file.TeiidMetadataImportProcessor;
import org.teiid.designer.transformation.ui.wizards.xmlfile.TeiidXmlFileInfo;
import org.teiid.designer.transformation.ui.wizards.xmlfile.XmlFileViewModelFactory;
import org.teiid.designer.ui.editors.ModelEditor;
import org.teiid.designer.ui.editors.ModelEditorManager;

public class TeiidXmlFileImportProcessor
extends TeiidMetadataImportProcessor {
    public TeiidXmlFileImportProcessor(TeiidMetadataImportInfo info, Shell shell) {
        super(info, shell);
    }

    @Override
    protected ModelResource createViewsInExistingModel(String relationalModelName) throws ModelerCoreException {
        if (this.getInfo().getViewModelLocation() != null && this.getInfo().getViewModelName() != null) {
            ModelWorkspaceItem item;
            ModelEditor editor;
            IPath modelPath = this.getInfo().getViewModelLocation().append(this.getInfo().getViewModelName());
            if (!modelPath.toString().toUpperCase().endsWith(".XMI")) {
                modelPath = modelPath.addFileExtension("xmi");
            }
            if ((editor = ModelEditorManager.getModelEditorForFile((IFile)((IFile)(item = ModelWorkspaceManager.getModelWorkspaceManager().findModelWorkspaceItem(modelPath, 1)).getCorrespondingResource()), (boolean)true)) != null) {
                boolean isDirty = editor.isDirty();
                XmlFileViewModelFactory factory = new XmlFileViewModelFactory();
                for (TeiidXmlFileInfo info : this.getInfo().getXmlFileInfos()) {
                    if (!info.doProcess()) continue;
                    if (info.getViewProcedureName() != null && !info.getViewProcedureName().equals("")) {
                        factory.createViewProcedure(editor.getModelResource(), info, relationalModelName);
                        continue;
                    }
                    factory.createViewTable(editor.getModelResource(), info, relationalModelName);
                }
                editor.getModelResource().save(null, true);
                if (!isDirty && editor.isDirty()) {
                    editor.doSave((IProgressMonitor)new NullProgressMonitor());
                }
                return editor.getModelResource();
            }
        }
        return null;
    }

    @Override
    protected ModelResource createViewsInNewModel(String sourceModelName) throws ModelerCoreException {
        XmlFileViewModelFactory factory = new XmlFileViewModelFactory();
        String viewModelName = this.getInfo().getViewModelName();
        if (!viewModelName.toLowerCase().endsWith(".xmi")) {
            viewModelName = String.valueOf(viewModelName) + ".xmi";
        }
        ModelResource modelResource = factory.createViewRelationalModel(this.getInfo().getViewModelLocation(), viewModelName);
        for (TeiidXmlFileInfo info : this.getInfo().getXmlFileInfos()) {
            if (!info.doProcess()) continue;
            factory.createViewTable(modelResource, info, sourceModelName);
        }
        return modelResource;
    }

    @Override
    protected void addConnectionProfileInfoToModel(ModelResource sourceModel, IConnectionProfile profile) throws ModelWorkspaceException {
        if (profile != null) {
            Object provider = null;
            if (this.getInfo().isXmlLocalFileMode()) {
                provider = new XmlFileConnectionInfoProvider();
            } else if (this.getInfo().isXmlUrlFileMode()) {
                provider = "org.teiid.designer.datatools.profiles.ws.WSConnectionProfile".equalsIgnoreCase(profile.getProviderId()) ? new WSConnectionInfoProvider() : new XmlUrlConnectionInfoProvider();
            }
            if (provider != null) {
                provider.setConnectionInfo(sourceModel, profile);
            }
        }
    }

    @Override
    protected ModelResource addProcedureToRelationalSourceModel() throws ModelerCoreException {
        if (this.getInfo().isXmlLocalFileMode()) {
            return super.addProcedureToRelationalSourceModel();
        }
        if (this.getInfo().getSourceModelLocation() != null && this.getInfo().getSourceModelName() != null) {
            ModelWorkspaceItem item;
            ModelEditor editor;
            IPath modelPath = this.getInfo().getSourceModelLocation().append(this.getInfo().getSourceModelName());
            if (!modelPath.toString().toUpperCase().endsWith(".XMI")) {
                modelPath = modelPath.addFileExtension("xmi");
            }
            if ((editor = ModelEditorManager.getModelEditorForFile((IFile)((IFile)(item = ModelWorkspaceManager.getModelWorkspaceManager().findModelWorkspaceItem(modelPath, 1)).getCorrespondingResource()), (boolean)true)) != null) {
                ModelResource mr = editor.getModelResource();
                boolean isDirty = editor.isDirty();
                FlatFileRelationalModelFactory factory = new FlatFileRelationalModelFactory();
                factory.addMissingProcedure(mr, "invokeHttp");
                mr.save(null, true);
                if (!isDirty && editor.isDirty()) {
                    editor.doSave((IProgressMonitor)new NullProgressMonitor());
                }
                return mr;
            }
        }
        return null;
    }
}

