/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.transformation.ui.wizards.file;

import java.util.Properties;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.IImportWizard;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.teiid.core.designer.util.I18nUtil;
import org.teiid.designer.core.workspace.ModelResource;
import org.teiid.designer.core.workspace.ModelUtil;
import org.teiid.designer.transformation.ui.UiConstants;
import org.teiid.designer.transformation.ui.UiPlugin;
import org.teiid.designer.transformation.ui.wizards.file.TeiidFlatFileImportOptionsPage;
import org.teiid.designer.transformation.ui.wizards.file.TeiidMetadataImportFormatPage;
import org.teiid.designer.transformation.ui.wizards.file.TeiidMetadataImportInfo;
import org.teiid.designer.transformation.ui.wizards.file.TeiidMetadataImportOptionsPage;
import org.teiid.designer.transformation.ui.wizards.file.TeiidMetadataImportProcessor;
import org.teiid.designer.transformation.ui.wizards.file.TeiidMetadataImportSourcePage;
import org.teiid.designer.transformation.ui.wizards.file.TeiidMetadataImportViewModelPage;
import org.teiid.designer.ui.common.util.UiUtil;
import org.teiid.designer.ui.common.util.WidgetUtil;
import org.teiid.designer.ui.common.wizard.AbstractWizard;
import org.teiid.designer.ui.common.wizard.NoOpenProjectsWizardPage;
import org.teiid.designer.ui.viewsupport.DesignerPropertiesUtil;
import org.teiid.designer.ui.viewsupport.IPropertiesContext;
import org.teiid.designer.ui.viewsupport.ModelIdentifier;
import org.teiid.designer.ui.viewsupport.ModelerUiViewUtils;

public class TeiidMetadataImportWizard
extends AbstractWizard
implements IPropertiesContext,
IImportWizard,
UiConstants {
    private static final String I18N_PREFIX = I18nUtil.getPropertyPrefix(TeiidMetadataImportWizard.class);
    private static final String TITLE = TeiidMetadataImportWizard.getString("title");
    private static final ImageDescriptor IMAGE = UiPlugin.getDefault().getImageDescriptor("icons/full/wizban/importTeiidMetadataWiz.gif");
    private TeiidMetadataImportInfo filesInfo;
    private TeiidMetadataImportSourcePage sourcePage;
    IContainer folder = null;
    private Properties designerProperties;
    private boolean openProjectExists = true;
    private IProject newProject;

    private static String getString(String id) {
        return Util.getString(String.valueOf(I18N_PREFIX) + id, new Object[0]);
    }

    public TeiidMetadataImportWizard() {
        super((AbstractUIPlugin)UiPlugin.getDefault(), TITLE, IMAGE);
    }

    public TeiidMetadataImportWizard(AbstractUIPlugin plugin, String title, ImageDescriptor image) {
        super(plugin, title, image);
    }

    public void init(IWorkbench workbench, IStructuredSelection inputSelection) {
        IProject targetProject = null;
        IStructuredSelection finalSelection = inputSelection;
        this.openProjectExists = ModelerUiViewUtils.workspaceHasOpenModelProjects();
        if (!this.openProjectExists) {
            this.newProject = ModelerUiViewUtils.queryUserToCreateModelProject();
            if (this.newProject != null) {
                finalSelection = new StructuredSelection((Object)this.newProject);
                targetProject = this.newProject;
                this.openProjectExists = true;
            } else {
                this.addPage((IWizardPage)NoOpenProjectsWizardPage.getStandardPage());
                return;
            }
        }
        Object selectedObj = finalSelection.getFirstElement();
        if (targetProject == null && selectedObj instanceof IResource) {
            targetProject = ((IResource)selectedObj).getProject();
        }
        this.folder = null;
        boolean isViewRelationalModel = false;
        try {
            if (selectedObj instanceof IFile) {
                ModelResource modelResource = ModelUtil.getModelResource((IFile)((IFile)selectedObj), (boolean)false);
                isViewRelationalModel = ModelIdentifier.isRelationalViewModel((ModelResource)modelResource);
            }
        }
        catch (Exception e) {
            Util.log((Throwable)e);
        }
        if (!finalSelection.isEmpty()) {
            Object obj = finalSelection.getFirstElement();
            this.folder = ModelUtil.getContainer((Object)obj);
            try {
                if (this.folder != null && this.folder.getProject().getNature("org.teiid.designer.core.modelNature") == null) {
                    this.folder = null;
                }
            }
            catch (CoreException err) {
                Util.log((Throwable)err);
                WidgetUtil.showError((Throwable)err);
            }
        }
        this.filesInfo = new TeiidMetadataImportInfo();
        this.filesInfo.setFileMode(0);
        this.filesInfo.setTargetProject(targetProject);
        if (isViewRelationalModel) {
            this.filesInfo.setViewModelName(((IFile)selectedObj).getName());
            this.filesInfo.setViewModelLocation(((IFile)selectedObj).getFullPath().removeLastSegments(1));
            this.filesInfo.setViewModelExists(true);
            this.filesInfo.setSourceModelLocation(((IFile)selectedObj).getFullPath().removeLastSegments(1));
        }
        if (this.folder != null) {
            this.filesInfo.setSourceModelLocation(this.folder.getFullPath());
            this.filesInfo.setViewModelLocation(this.folder.getFullPath());
        }
    }

    public void addPages() {
        if (!this.openProjectExists) {
            return;
        }
        TeiidFlatFileImportOptionsPage flatFileImportOptionsPage = new TeiidFlatFileImportOptionsPage(this.getFileInfo());
        this.addPage((IWizardPage)flatFileImportOptionsPage);
        this.sourcePage = new TeiidMetadataImportSourcePage(this.getFileInfo());
        this.addPage((IWizardPage)this.sourcePage);
        TeiidMetadataImportFormatPage formatSelectionPage = new TeiidMetadataImportFormatPage(this.getFileInfo());
        this.addPage((IWizardPage)formatSelectionPage);
        TeiidMetadataImportOptionsPage optionsPage = new TeiidMetadataImportOptionsPage(this.getFileInfo());
        this.addPage((IWizardPage)optionsPage);
        TeiidMetadataImportViewModelPage viewModelPage = new TeiidMetadataImportViewModelPage(this.getFileInfo());
        this.addPage((IWizardPage)viewModelPage);
    }

    public void createPageControls(Composite pageContainer) {
        super.createPageControls(pageContainer);
        this.updateForProperties();
    }

    public boolean finish() {
        final TeiidMetadataImportProcessor processor = new TeiidMetadataImportProcessor(this.filesInfo, this.getShell());
        UiUtil.runInSwtThread((Runnable)new Runnable(){

            @Override
            public void run() {
                processor.execute();
            }
        }, (boolean)false);
        if (this.designerProperties != null) {
            DesignerPropertiesUtil.setSourceModelName((Properties)this.designerProperties, (String)this.getFileInfo().getSourceModelName());
            DesignerPropertiesUtil.setViewModelName((Properties)this.designerProperties, (String)this.getFileInfo().getViewModelName());
        }
        return true;
    }

    public TeiidMetadataImportInfo getFileInfo() {
        return this.filesInfo;
    }

    public void setProperties(Properties properties) {
        this.designerProperties = properties;
    }

    public Properties getDesignerProperties() {
        return this.designerProperties;
    }

    protected boolean openProjectExists() {
        return this.openProjectExists;
    }

    protected void updateForProperties() {
        String profileName;
        if (this.designerProperties == null || this.designerProperties.isEmpty()) {
            return;
        }
        if (this.folder == null) {
            IProject project = DesignerPropertiesUtil.getProject((Properties)this.designerProperties);
            IContainer srcFolderResrc = DesignerPropertiesUtil.getSourcesFolder((Properties)this.designerProperties);
            IContainer viewFolderResrc = DesignerPropertiesUtil.getViewsFolder((Properties)this.designerProperties);
            if (project != null) {
                this.getFileInfo().setTargetProject(project);
            }
            if (srcFolderResrc != null) {
                this.getFileInfo().setSourceModelLocation(srcFolderResrc.getFullPath());
            } else if (project != null) {
                this.getFileInfo().setSourceModelLocation(project.getFullPath());
            }
            if (viewFolderResrc != null) {
                this.getFileInfo().setViewModelLocation(viewFolderResrc.getFullPath());
            } else if (project != null) {
                this.getFileInfo().setViewModelLocation(project.getFullPath());
            }
        }
        if ((profileName = DesignerPropertiesUtil.getConnectionProfileName((Properties)this.designerProperties)) != null && !profileName.isEmpty()) {
            this.sourcePage.selectConnectionProfile(profileName);
        }
        if (!this.openProjectExists) {
            DesignerPropertiesUtil.setProjectStatus((Properties)this.designerProperties, (String)"noOpenProject");
        }
    }

    public boolean isOpenProjectExists() {
        return this.openProjectExists;
    }
}

