/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.transformation.ui.wizards;

import java.util.ArrayList;
import java.util.Collection;
import org.eclipse.core.resources.IFile;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.teiid.designer.core.metamodel.MetamodelDescriptor;
import org.teiid.designer.core.metamodel.aspect.sql.SqlAspect;
import org.teiid.designer.core.metamodel.aspect.sql.SqlAspectHelper;
import org.teiid.designer.core.metamodel.aspect.sql.SqlColumnAspect;
import org.teiid.designer.core.metamodel.aspect.sql.SqlProcedureAspect;
import org.teiid.designer.core.metamodel.aspect.sql.SqlProcedureParameterAspect;
import org.teiid.designer.core.metamodel.aspect.sql.SqlTableAspect;
import org.teiid.designer.core.workspace.ModelResource;
import org.teiid.designer.transformation.ui.UiConstants;
import org.teiid.designer.transformation.ui.wizards.TransformationCopyModelFeaturePopulator;
import org.teiid.designer.ui.common.widget.ICheckableController;
import org.teiid.designer.ui.wizards.StructuralCopyModelFeaturePopulator;
import org.teiid.designer.ui.wizards.TreeViewerWizardPanel;

public class TransformationTreeViewerWizardPanel
extends TreeViewerWizardPanel
implements ICheckableController {
    private static final String CLEAR_SUPPORTS_UPDATE = UiConstants.Util.getString("TransformationTreeViewerWizardPanel.clearSupportsUpdate", new Object[0]);
    private TransformationViewerFilter filter;
    private Collection unsupportedClasses = new ArrayList();
    private boolean useFilter = true;
    private Button clearSupportUpdate;

    public TransformationTreeViewerWizardPanel(Composite parent, WizardPage wizardPage, MetamodelDescriptor metamodelDescriptor, ModelResource selection, boolean sourceIsPhysical, boolean targetIsVirtual, boolean isTransform) {
        super(parent, wizardPage, metamodelDescriptor, selection, sourceIsPhysical, targetIsVirtual, isTransform);
        this.unsupportedClasses.add(SqlColumnAspect.class);
        this.unsupportedClasses.add(SqlProcedureParameterAspect.class);
        TreeViewer viewer = this.getViewer();
        this.filter = new TransformationViewerFilter();
        viewer.addFilter((ViewerFilter)this.filter);
    }

    protected void addOptions(Composite parent) {
        super.addOptions(parent);
        this.clearSupportUpdate = new Button((Composite)this, 32);
        this.clearSupportUpdate.setSelection(true);
        this.clearSupportUpdate.setLayoutData((Object)new GridData(4, 4, false, false));
        this.clearSupportUpdate.setText(CLEAR_SUPPORTS_UPDATE);
    }

    protected StructuralCopyModelFeaturePopulator getFeaturePopulator(IFile sourceFile) {
        return new TransformationCopyModelFeaturePopulator(sourceFile);
    }

    public boolean isClearSupportsUpdate() {
        return this.clearSupportUpdate.getSelection();
    }

    public boolean isEditable(Object theObject) {
        SqlAspect aspect;
        boolean result = true;
        if (theObject instanceof EObject && (aspect = SqlAspectHelper.getSqlAspect((EObject)((EObject)theObject))) != null) {
            for (Class c : this.unsupportedClasses) {
                if (!c.isInstance(aspect)) continue;
                result = false;
                break;
            }
        }
        return result;
    }

    protected boolean isUsingDefaultFilter() {
        return this.useFilter;
    }

    protected void setUseDefaultFilter(boolean theUseFlag) {
        if (theUseFlag && !this.useFilter) {
            this.getViewer().addFilter((ViewerFilter)this.filter);
        } else if (!theUseFlag) {
            this.getViewer().removeFilter((ViewerFilter)this.filter);
        }
        this.useFilter = theUseFlag;
    }

    static class TransformationViewerFilter
    extends ViewerFilter {
        TransformationViewerFilter() {
        }

        public boolean select(Viewer theViewer, Object theParentElement, Object theElement) {
            EObject parent;
            SqlAspect aspect;
            boolean result = true;
            if (theParentElement != null && theParentElement instanceof EObject && (aspect = SqlAspectHelper.getSqlAspect((EObject)(parent = (EObject)theParentElement))) != null) {
                if (aspect instanceof SqlTableAspect && theElement instanceof EObject) {
                    result = true;
                } else if (aspect instanceof SqlProcedureAspect && theElement instanceof EObject) {
                    result = SqlAspectHelper.getSqlAspect((EObject)((EObject)theElement)) instanceof SqlProcedureParameterAspect;
                }
            }
            return result;
        }
    }
}

