/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.transformation.ui.preferences;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.teiid.designer.core.ModelerCore;
import org.teiid.designer.transformation.TransformationPlugin;
import org.teiid.designer.transformation.ui.UiConstants;
import org.teiid.designer.ui.common.preferences.IEditorPreferencesComponent;
import org.teiid.designer.ui.common.preferences.IEditorPreferencesValidationListener;
import org.teiid.designer.ui.common.util.WidgetFactory;
import org.teiid.query.ui.UiPlugin;

public class TransformationEditorPreferencesComponent
implements IEditorPreferencesComponent {
    private Button startClausesOnNewLineButton;
    private Button indentClausesButton;
    private Button autoExpandSelectButton;
    private Text defaultStringLength;
    private Button showViewAndSourcesRadioButton;
    private Button showTreeLayoutRadioButton;
    private String name = TransformationEditorPreferencesComponent.getString("TransformationEditorPreferencesComponent.name");
    private String defaultStringMessage = TransformationEditorPreferencesComponent.getString("TransformationEditorPreferencesComponent.defaultStringLength");
    private String invalidNumberMessage = TransformationEditorPreferencesComponent.getString("TransformationEditorPreferencesComponent.invalidNumber");
    private static int MAX_NUMBER = 255;
    private static int MIN_NUMBER = 1;
    private List<IEditorPreferencesValidationListener> validationListeners = new ArrayList<IEditorPreferencesValidationListener>();

    private static String getString(String key) {
        return UiConstants.Util.getString(key, new Object[0]);
    }

    public String getName() {
        return this.name;
    }

    public String getTooltip() {
        return this.name;
    }

    public Composite createEditorPreferencesComponent(Composite parent) {
        Label label = null;
        Composite comp = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.marginHeight = 8;
        layout.marginWidth = 8;
        layout.numColumns = 1;
        comp.setLayout((Layout)layout);
        String clausesGroupHdr = TransformationEditorPreferencesComponent.getString("TransformationEditorPreferencesComponent.sqlClauses");
        Group clausesGroup = WidgetFactory.createGroup((Composite)comp, (String)clausesGroupHdr, (int)768, (int)1, (int)2);
        this.startClausesOnNewLineButton = new Button((Composite)clausesGroup, 32);
        String buttonText = TransformationEditorPreferencesComponent.getString("TransformationEditorPreferencesComponent.startClauses");
        this.startClausesOnNewLineButton.setText(buttonText);
        this.startClausesOnNewLineButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent ev) {
                TransformationEditorPreferencesComponent.this.setButtonEnabling();
            }
        });
        this.indentClausesButton = new Button((Composite)clausesGroup, 32);
        buttonText = TransformationEditorPreferencesComponent.getString("TransformationEditorPreferencesComponent.indentClause");
        this.indentClausesButton.setText(buttonText);
        this.indentClausesButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent ev) {
                TransformationEditorPreferencesComponent.this.setButtonEnabling();
            }
        });
        GridData buttonGridData = new GridData();
        buttonGridData.horizontalIndent = 6;
        this.indentClausesButton.setLayoutData((Object)buttonGridData);
        this.autoExpandSelectButton = new Button((Composite)clausesGroup, 32);
        buttonText = TransformationEditorPreferencesComponent.getString("TransformationEditorPreferencesComponent.autoExpandSelect");
        this.autoExpandSelectButton.setText(buttonText);
        this.autoExpandSelectButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent ev) {
                TransformationEditorPreferencesComponent.this.setButtonEnabling();
            }
        });
        buttonGridData = new GridData();
        buttonGridData.horizontalSpan = 2;
        this.autoExpandSelectButton.setLayoutData((Object)buttonGridData);
        String diagramLayoutHeader = TransformationEditorPreferencesComponent.getString("TransformationEditorPreferencesComponent.diagramLayout");
        Group grpDiagramLayout = WidgetFactory.createGroup((Composite)comp, (String)diagramLayoutHeader, (int)768);
        this.showViewAndSourcesRadioButton = WidgetFactory.createRadioButton((Composite)grpDiagramLayout, (String)TransformationEditorPreferencesComponent.getString("TransformationEditorPreferencesComponent.viewAndSources"));
        this.showTreeLayoutRadioButton = WidgetFactory.createRadioButton((Composite)grpDiagramLayout, (String)TransformationEditorPreferencesComponent.getString("TransformationEditorPreferencesComponent.treeLayout"));
        String miscHeader = TransformationEditorPreferencesComponent.getString("TransformationEditorPreferencesComponent.miscellaneous");
        Group grpMisc = WidgetFactory.createGroup((Composite)comp, (String)miscHeader, (int)768, (int)1, (int)2);
        label = new Label((Composite)grpMisc, 0);
        label.setText(this.defaultStringMessage);
        this.defaultStringLength = new Text((Composite)grpMisc, 2048);
        this.defaultStringLength.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                TransformationEditorPreferencesComponent.this.validate();
            }
        });
        this.setInitialButtonStates();
        return comp;
    }

    private void setInitialButtonStates() {
        boolean selected = this.getPreferenceStore().getBoolean("startClausesOnNewLine");
        this.startClausesOnNewLineButton.setSelection(selected);
        selected = this.getPreferenceStore().getBoolean("indentClauseContent");
        this.indentClausesButton.setSelection(selected);
        selected = TransformationPlugin.getDefault().getPreferences().getBoolean("org.teiid.designer.transformation.preferences.auto_expand_select", false);
        this.autoExpandSelectButton.setSelection(selected);
        this.defaultStringLength.setText(String.valueOf(ModelerCore.getTransformationPreferences().getDefaultStringLength()));
        boolean treeLayout = this.getPreferenceStore().getBoolean("treeDiagramLayout");
        this.showViewAndSourcesRadioButton.setSelection(!treeLayout);
        this.showTreeLayoutRadioButton.setSelection(treeLayout);
        this.setButtonEnabling();
    }

    public boolean performOk() {
        boolean isTreeLayout;
        Integer val;
        boolean isSet;
        boolean changeMade = false;
        boolean isSelected = this.startClausesOnNewLineButton.getEnabled() && this.startClausesOnNewLineButton.getSelection();
        if (isSelected != (isSet = this.getPreferenceStore().getBoolean("startClausesOnNewLine"))) {
            this.getPreferenceStore().setValue("startClausesOnNewLine", isSelected);
            changeMade = true;
        }
        if ((isSelected = this.indentClausesButton.getEnabled() && this.indentClausesButton.getSelection()) != (isSet = this.getPreferenceStore().getBoolean("indentClauseContent"))) {
            this.getPreferenceStore().setValue("indentClauseContent", isSelected);
            changeMade = true;
        }
        if ((isSelected = this.autoExpandSelectButton.getEnabled() && this.autoExpandSelectButton.getSelection()) != (isSet = TransformationPlugin.getDefault().getPreferences().getBoolean("org.teiid.designer.transformation.preferences.auto_expand_select", false))) {
            TransformationPlugin.getDefault().getPreferences().putBoolean("org.teiid.designer.transformation.preferences.auto_expand_select", isSelected);
            changeMade = true;
        }
        if ((val = new Integer(this.defaultStringLength.getText())).intValue() != ModelerCore.getTransformationPreferences().getDefaultStringLength()) {
            ModelerCore.getTransformationPreferences().setDefaultStringLength(val.intValue());
            changeMade = true;
        }
        if ((isTreeLayout = this.getPreferenceStore().getBoolean("treeDiagramLayout")) != this.showTreeLayoutRadioButton.getSelection()) {
            changeMade = true;
            this.getPreferenceStore().setValue("treeDiagramLayout", this.showTreeLayoutRadioButton.getSelection());
        }
        if (changeMade) {
            UiPlugin.getDefault().savePreferences();
        }
        return true;
    }

    public void performDefaults() {
        boolean select = this.getPreferenceStore().getDefaultBoolean("startClausesOnNewLine");
        this.startClausesOnNewLineButton.setSelection(select);
        select = this.getPreferenceStore().getDefaultBoolean("indentClauseContent");
        this.indentClausesButton.setSelection(select);
        this.indentClausesButton.setSelection(false);
        boolean treeLayout = this.getPreferenceStore().getDefaultBoolean("treeDiagramLayout");
        this.showViewAndSourcesRadioButton.setSelection(!treeLayout);
        this.showTreeLayoutRadioButton.setSelection(treeLayout);
        this.defaultStringLength.setText(String.valueOf(ModelerCore.getTransformationPreferences().getDefaultStringLengthDefault()));
        this.setButtonEnabling();
        this.validate();
    }

    void setButtonEnabling() {
        this.startClausesOnNewLineButton.setEnabled(true);
        this.indentClausesButton.setEnabled(this.startClausesOnNewLineButton.getSelection());
    }

    private IPreferenceStore getPreferenceStore() {
        return UiPlugin.getDefault().getPreferenceStore();
    }

    public void addValidationListener(IEditorPreferencesValidationListener listener) {
        this.validationListeners.add(listener);
    }

    public void removeValidationListener(IEditorPreferencesValidationListener listener) {
        this.validationListeners.remove(listener);
    }

    public void fireValidationStatus(boolean validationStatus, String message) {
        int i = 0;
        while (i < this.validationListeners.size()) {
            this.validationListeners.get(i).validationStatus(validationStatus, message);
            ++i;
        }
    }

    public void validate() {
        try {
            Integer val = new Integer(this.defaultStringLength.getText());
            if (val >= MIN_NUMBER && val <= MAX_NUMBER) {
                this.fireValidationStatus(true, null);
                return;
            }
        }
        catch (NumberFormatException numberFormatException) {}
        this.fireValidationStatus(false, this.invalidNumberMessage);
    }
}

