/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.transformation.ui.builder.util;

import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.Viewer;
import org.teiid.core.designer.util.CoreArgCheck;
import org.teiid.designer.query.sql.lang.ICompoundCriteria;
import org.teiid.designer.query.sql.lang.ICriteria;
import org.teiid.designer.query.sql.lang.IExpression;
import org.teiid.designer.query.sql.lang.ILanguageObject;
import org.teiid.designer.query.sql.lang.ILogicalCriteria;
import org.teiid.designer.query.sql.lang.INotCriteria;
import org.teiid.designer.query.sql.symbol.IFunction;
import org.teiid.designer.transformation.ui.UiConstants;
import org.teiid.designer.transformation.ui.builder.ILanguageObjectInputProvider;

public class LanguageObjectContentProvider
implements ITreeContentProvider,
UiConstants {
    private ILanguageObject langObj;
    private Object[] roots = new Object[0];

    public void dispose() {
    }

    public Object getChildAt(int theIndex, Object theParent) {
        Object[] kids = this.getChildren(theParent);
        return kids[theIndex];
    }

    public int getChildCount(Object theParent) {
        return this.getChildren(theParent).length;
    }

    public int getChildIndex(Object theChild) {
        int result = -1;
        Object parent = this.getParent(theChild);
        if (parent != null) {
            Object[] kids = this.getChildren(parent);
            int i = 0;
            while (i < kids.length) {
                if (kids[i] == theChild) {
                    result = i;
                    break;
                }
                ++i;
            }
        }
        return result;
    }

    private Object[] getChildren(ICriteria theCriteria) {
        Object[] result = null;
        if (theCriteria instanceof INotCriteria) {
            INotCriteria notCrit = (INotCriteria)theCriteria;
            ICriteria criteria = notCrit.getCriteria();
            if (criteria instanceof ILogicalCriteria) {
                result = this.getChildren(criteria);
            }
        } else if (theCriteria instanceof ICompoundCriteria) {
            ICompoundCriteria compoundCrit = (ICompoundCriteria)theCriteria;
            int size = compoundCrit.getCriteriaCount();
            result = new Object[size];
            int i = 0;
            while (i < size) {
                ICriteria criteria = compoundCrit.getCriteria(i);
                result[i] = criteria == null ? "<undefined>" : criteria;
                ++i;
            }
        }
        return result == null ? new Object[]{} : result;
    }

    private Object[] getChildren(IExpression theExpression) {
        Object[] result = null;
        if (theExpression != null && theExpression instanceof IFunction) {
            result = this.getChildren((IFunction)theExpression);
        }
        return result == null ? new Object[]{} : result;
    }

    private Object[] getChildren(IFunction theFunction) {
        Object[] result = null;
        if (theFunction.isImplicit()) {
            IExpression arg = theFunction.getArgs()[0];
            result = arg != null && arg instanceof IFunction ? this.getChildren((IFunction)arg) : this.getChildren(arg);
        } else {
            IExpression[] args = theFunction.getArgs();
            if (args != null && args.length > 0) {
                result = new Object[args.length];
                int i = 0;
                while (i < args.length) {
                    result[i] = args[i] == null ? "<undefined>" : args[i];
                    ++i;
                }
            }
        }
        return result == null ? new Object[]{} : result;
    }

    public Object[] getChildren(Object theParent) {
        Object[] result = null;
        if (theParent != null) {
            if (theParent instanceof ICriteria) {
                result = this.getChildren((ICriteria)theParent);
            } else if (theParent instanceof IExpression) {
                result = this.getChildren((IExpression)theParent);
            }
        }
        return result == null ? new Object[]{} : result;
    }

    public Object[] getElements(Object theInputElement) {
        return this.roots;
    }

    public Object getParent(Object theElement) {
        return this.getParent(this.langObj, theElement);
    }

    public Object getParent(Object theRoot, Object theChild) {
        Object result = null;
        if (theRoot != theChild) {
            Object[] kids = this.getChildren(theRoot);
            int i = 0;
            while (i < kids.length) {
                if (theChild == kids[i]) {
                    result = theRoot;
                    break;
                }
                result = this.getParent(kids[i], theChild);
                if (result != null) break;
                ++i;
            }
        }
        return result;
    }

    public Object getRoot() {
        return this.roots.length > 0 ? this.roots[0] : null;
    }

    public boolean hasChildren(Object theElement) {
        return this.getChildren(theElement).length > 0;
    }

    public void inputChanged(Viewer theViewer, Object theOldInput, Object theNewInput) {
        if (theNewInput != null) {
            CoreArgCheck.isInstanceOf(ILanguageObjectInputProvider.class, (Object)theNewInput, (String)ILanguageObjectInputProvider.class.getName());
            this.langObj = ((ILanguageObjectInputProvider)theNewInput).getLanguageObject();
            String root = this.langObj == null ? "<undefined>" : this.langObj;
            this.roots = new Object[]{root};
        }
    }
}

