/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.transformation.ui.builder.expression;

import java.util.List;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.TableLayout;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.teiid.core.designer.util.CoreArgCheck;
import org.teiid.core.designer.util.I18nUtil;
import org.teiid.designer.query.sql.lang.ILanguageObject;
import org.teiid.designer.query.sql.symbol.IFunction;
import org.teiid.designer.transformation.ui.builder.AbstractLanguageObjectEditor;
import org.teiid.query.ui.builder.model.FunctionEditorModel;
import org.teiid.query.ui.builder.model.ILanguageObjectEditorModel;
import org.teiid.query.ui.builder.model.ILanguageObjectEditorModelListener;
import org.teiid.query.ui.builder.model.LanguageObjectEditorModelEvent;

public class FunctionEditor
extends AbstractLanguageObjectEditor {
    private static final String PREFIX = I18nUtil.getPropertyPrefix(FunctionEditor.class);
    private static final String[] TBL_HDRS = new String[]{Util.getString(String.valueOf(PREFIX) + "argColumnHdr", new Object[0]), Util.getString(String.valueOf(PREFIX) + "valueColumnHdr", new Object[0])};
    private static final int ARG_INDEX = 0;
    private static final int VALUE_INDEX = 1;
    private ViewController controller = new ViewController();
    FunctionEditorModel model;
    private boolean processingEvents = true;
    private Combo cbxCategory;
    private Combo cbxFunction;
    private Composite pnlContent;
    private Table table;
    private TableViewer viewer;

    public FunctionEditor(Composite theParent, FunctionEditorModel theModel) {
        super(theParent, IFunction.class, (ILanguageObjectEditorModel)theModel);
        this.model = theModel;
        this.model.addModelListener((ILanguageObjectEditorModelListener)this.controller);
        this.viewer.setInput((Object)this.model);
        this.cbxCategory.setItems(this.model.getCategories());
        this.controller.initialize();
    }

    @Override
    public void acceptFocus() {
        this.cbxFunction.setFocus();
    }

    @Override
    protected void createUi(Composite theParent) {
        this.pnlContent = new Composite(theParent, 0);
        this.pnlContent.setLayoutData((Object)new GridData(1808));
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        this.pnlContent.setLayout((Layout)layout);
        Label lblCategory = new Label(this.pnlContent, 0);
        lblCategory.setLayoutData((Object)new GridData(128));
        lblCategory.setText(Util.getString(String.valueOf(PREFIX) + "lblCategory", new Object[0]));
        this.cbxCategory = new Combo(this.pnlContent, 2056);
        this.cbxCategory.setToolTipText(Util.getString(String.valueOf(PREFIX) + "cbxCategory.tip", new Object[0]));
        this.cbxCategory.setLayoutData((Object)new GridData(768));
        this.cbxCategory.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent theEvent) {
                FunctionEditor.this.handleCategorySelected();
            }
        });
        Label lblFunction = new Label(this.pnlContent, 0);
        lblFunction.setLayoutData((Object)new GridData(128));
        lblFunction.setText(Util.getString(String.valueOf(PREFIX) + "lblFunction", new Object[0]));
        this.cbxFunction = new Combo(this.pnlContent, 2056);
        this.cbxFunction.setToolTipText(Util.getString(String.valueOf(PREFIX) + "cbxFunction.tip", new Object[0]));
        this.cbxFunction.setLayoutData((Object)new GridData(768));
        this.cbxFunction.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent theEvent) {
                FunctionEditor.this.handleFunctionSelected();
            }
        });
        int style = 66312;
        this.viewer = new TableViewer(this.pnlContent, style);
        this.viewer.setContentProvider((IContentProvider)new TableContentProvider());
        this.viewer.setLabelProvider((IBaseLabelProvider)new TableLabelProvider());
        this.table = this.viewer.getTable();
        this.table.setHeaderVisible(true);
        this.table.setLinesVisible(true);
        this.table.setLayout((Layout)new TableLayout());
        GridData gd = new GridData(1808);
        gd.horizontalSpan = 2;
        this.table.setLayoutData((Object)gd);
        int i = 0;
        while (i < TBL_HDRS.length) {
            TableColumn argCol = new TableColumn(this.table, 0x1000000);
            argCol.setText(TBL_HDRS[i]);
            ++i;
        }
    }

    void displayCategoryChange() {
        String category = this.model.getCategory();
        if (category == null) {
            this.model.setCategory(this.model.getDefaultCategory());
        } else {
            String function;
            if (this.cbxCategory.getSelectionIndex() == -1 || !category.equals(this.cbxCategory.getText())) {
                this.cbxCategory.setText(category);
            }
            String[] functions = this.model.getFunctions();
            String[] items = this.cbxFunction.getItems();
            boolean loadItems = true;
            if (functions.length == items.length) {
                int i = 0;
                while (i < functions.length) {
                    if (!functions[i].equals(items[i])) {
                        loadItems = true;
                        break;
                    }
                    ++i;
                }
            }
            if (loadItems) {
                this.processingEvents = false;
                this.cbxFunction.setItems(functions);
                this.processingEvents = true;
            }
            if ((function = this.model.getFunctionName()) == null) {
                if (this.cbxFunction.getItemCount() > 0) {
                    this.model.setFunctionName(this.cbxFunction.getItem(0));
                } else {
                    Util.log(2, Util.getString(String.valueOf(PREFIX) + "noFunctionsFound", new Object[]{category}));
                }
            } else if (this.cbxFunction.getSelectionIndex() == -1 || !this.cbxFunction.getText().equals(function)) {
                this.processingEvents = false;
                this.model.setFunctionName(function);
                this.processingEvents = true;
            }
        }
    }

    void displayFunctionChange() {
        if (this.cbxFunction.getSelectionIndex() == -1 || !this.cbxFunction.getText().equals(this.model.getFunction().toString())) {
            this.cbxFunction.setText(this.model.getFunctionName());
            this.cbxFunction.setToolTipText(this.model.getFunctionDescription());
            this.viewer.refresh();
            int i = 0;
            while (i < TBL_HDRS.length) {
                this.table.getColumn(i++).pack();
            }
        }
    }

    void displayLanguageObjectChange() {
        this.displayCategoryChange();
        this.displayFunctionChange();
    }

    @Override
    public String getTitle() {
        return Util.getString(String.valueOf(PREFIX) + "title", new Object[0]);
    }

    @Override
    public String getToolTipText() {
        return Util.getString(String.valueOf(PREFIX) + "tip", new Object[0]);
    }

    void handleCategorySelected() {
        this.model.setCategory(this.cbxCategory.getText());
    }

    void handleFunctionSelected() {
        if (this.processingEvents) {
            this.model.setFunctionName(this.cbxFunction.getText());
        }
    }

    @Override
    public void setLanguageObject(ILanguageObject theLanguageObject) {
        if (theLanguageObject == null) {
            this.clear();
        } else {
            if (!(theLanguageObject instanceof IFunction)) {
                CoreArgCheck.isTrue((boolean)(theLanguageObject instanceof IFunction), (String)Util.getString(String.valueOf(PREFIX) + "invalidLanguageObject", new Object[]{theLanguageObject.getClass().getName()}));
            }
            this.model.setLanguageObject(theLanguageObject);
        }
    }

    class TableContentProvider
    implements IStructuredContentProvider {
        TableContentProvider() {
        }

        public void dispose() {
        }

        public Object[] getElements(Object theInputElement) {
            Object[] result = null;
            List args = FunctionEditor.this.model.getFunctionArgNames();
            if (args != null && !args.isEmpty()) {
                List argValues = FunctionEditor.this.model.getFunctionArgValues();
                int numRows = args.size();
                result = new Object[numRows];
                int i = 0;
                while (i < numRows) {
                    result[i] = new TableRow(args.get(i), argValues.get(i));
                    ++i;
                }
            }
            return args == null || args.isEmpty() ? new Object[]{} : result;
        }

        public void inputChanged(Viewer theViewer, Object theOldInput, Object theNewInput) {
        }
    }

    class TableLabelProvider
    extends LabelProvider
    implements ITableLabelProvider {
        TableLabelProvider() {
        }

        public Image getColumnImage(Object theElement, int theColumnIndex) {
            return null;
        }

        public String getColumnText(Object theElement, int theColumnIndex) {
            TableRow row = (TableRow)theElement;
            return row.getColumnText(theColumnIndex);
        }
    }

    class TableRow {
        private Object arg;
        private Object value;

        public TableRow(Object theArgName, Object theArgValue) {
            this.arg = theArgName;
            this.value = theArgValue;
        }

        public String getColumnText(int theIndex) {
            String result = "unknown";
            if (theIndex == 0) {
                result = this.arg.toString();
            } else if (theIndex == 1) {
                result = this.value == null ? "<undefined>" : this.value.toString();
            }
            return result;
        }
    }

    class ViewController
    implements ILanguageObjectEditorModelListener {
        ViewController() {
        }

        public void initialize() {
            Display.getDefault().asyncExec(new Runnable(){

                @Override
                public void run() {
                    ViewController.this.modelChanged(new LanguageObjectEditorModelEvent((ILanguageObjectEditorModel)((ViewController)ViewController.this).FunctionEditor.this.model, "CATEGORY"));
                }
            });
        }

        public void modelChanged(LanguageObjectEditorModelEvent theEvent) {
            String type = theEvent.getType();
            if (type.equals("CATEGORY")) {
                FunctionEditor.this.displayCategoryChange();
            } else if (type.equals("SELECTED_FUNCTION")) {
                FunctionEditor.this.displayFunctionChange();
            } else if (type.equals("SAVED")) {
                FunctionEditor.this.displayLanguageObjectChange();
            }
        }
    }
}

