/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.transformation.ui.builder.criteria;

import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.teiid.core.designer.util.CoreArgCheck;
import org.teiid.core.designer.util.I18nUtil;
import org.teiid.designer.query.sql.lang.IExpression;
import org.teiid.designer.query.sql.lang.IIsNullCriteria;
import org.teiid.designer.query.sql.lang.ILanguageObject;
import org.teiid.designer.transformation.ui.builder.criteria.AbstractPredicateCriteriaTypeEditor;
import org.teiid.designer.transformation.ui.builder.criteria.CriteriaExpressionEditor;
import org.teiid.query.ui.builder.model.AbstractPredicateCriteriaTypeEditorModel;
import org.teiid.query.ui.builder.model.ILanguageObjectEditorModel;
import org.teiid.query.ui.builder.model.ILanguageObjectEditorModelListener;
import org.teiid.query.ui.builder.model.IsNullCriteriaEditorModel;
import org.teiid.query.ui.builder.model.LanguageObjectEditorModelEvent;

public class IsNullCriteriaEditor
extends AbstractPredicateCriteriaTypeEditor {
    private static final String PREFIX = I18nUtil.getPropertyPrefix(IsNullCriteriaEditor.class);
    private CriteriaExpressionEditor editor;
    private Control component;
    private ViewController viewController;
    IsNullCriteriaEditorModel theModel;

    public IsNullCriteriaEditor(Composite parent, IsNullCriteriaEditorModel model) {
        super(parent, IIsNullCriteria.class, (AbstractPredicateCriteriaTypeEditorModel)model);
        this.theModel = model;
        this.viewController = new ViewController();
        this.theModel.addModelListener((ILanguageObjectEditorModelListener)this.viewController);
        this.viewController.initialize();
    }

    @Override
    public String getToolTipText() {
        String tip = Util.getString(String.valueOf(PREFIX) + "toolTipText", new Object[0]);
        return tip;
    }

    @Override
    public String getTitle() {
        String title = Util.getString(String.valueOf(PREFIX) + "title", new Object[0]);
        return title;
    }

    @Override
    public Control createLeftComponent(Composite parent) {
        this.editor = new CriteriaExpressionEditor(parent, this.theModel.getExpressionModel());
        this.component = this.editor.getUi();
        return this.component;
    }

    @Override
    public Control createRightComponent(Composite parent) {
        return null;
    }

    @Override
    public IExpression getLeftExpression() {
        IExpression leftExpression = this.theModel.getLeftExpression();
        return leftExpression;
    }

    @Override
    public IExpression getRightExpression() {
        return null;
    }

    @Override
    public void setLanguageObject(ILanguageObject obj) {
        CoreArgCheck.isInstanceOf(IIsNullCriteria.class, (Object)obj);
        this.theModel.setLanguageObject(obj);
    }

    @Override
    public String[] getOperators() {
        return this.theModel.getOperators();
    }

    @Override
    public void acceptFocus() {
        this.editor.acceptFocus();
    }

    @Override
    public void setOperator(String op) {
        this.theModel.setCurrentOperator(op);
    }

    @Override
    public String getCurrentOperator() {
        return this.theModel.getCurrentOperator();
    }

    void displayExpression() {
        IExpression langObj = this.theModel.getLeftExpression();
        this.editor.setLanguageObject((ILanguageObject)langObj);
    }

    void displayLanguageObjectChange() {
        this.displayExpression();
    }

    private class ViewController
    implements ILanguageObjectEditorModelListener {
        public void initialize() {
            Display.getDefault().asyncExec(new Runnable(){

                @Override
                public void run() {
                    ViewController.this.modelChanged(new LanguageObjectEditorModelEvent((ILanguageObjectEditorModel)((ViewController)ViewController.this).IsNullCriteriaEditor.this.theModel, "SAVED"));
                }
            });
        }

        public void modelChanged(LanguageObjectEditorModelEvent theEvent) {
            String type = theEvent.getType();
            if (type.equals("EXPRESSION")) {
                IsNullCriteriaEditor.this.displayExpression();
            } else if (type.equals("SAVED")) {
                IsNullCriteriaEditor.this.displayLanguageObjectChange();
            }
        }
    }
}

