/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.transformation.ui.actions;

import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Shell;
import org.teiid.core.designer.util.CoreArgCheck;
import org.teiid.designer.core.ModelerCore;
import org.teiid.designer.core.workspace.ModelResource;
import org.teiid.designer.core.workspace.ModelUtil;
import org.teiid.designer.core.workspace.ModelWorkspaceException;
import org.teiid.designer.metamodels.transformation.SqlTransformationMappingRoot;
import org.teiid.designer.transformation.ui.UiConstants;
import org.teiid.designer.transformation.ui.UiPlugin;
import org.teiid.designer.transformation.ui.textimport.VirtualTableRowObject;
import org.teiid.designer.transformation.ui.wizards.VirtualRelationalObjectProcessor;
import org.teiid.designer.transformation.util.TransformationHelper;
import org.teiid.designer.transformation.util.TransformationMappingHelper;
import org.teiid.designer.transformation.validation.TransformationValidator;
import org.teiid.designer.ui.actions.SortableSelectionAction;
import org.teiid.designer.ui.common.eventsupport.SelectionUtilities;
import org.teiid.designer.ui.common.util.WidgetUtil;
import org.teiid.designer.ui.common.widget.ListMessageDialog;
import org.teiid.designer.ui.viewsupport.ModelIdentifier;
import org.teiid.designer.ui.viewsupport.ModelUtilities;

public class ImportTransformationSqlFromTextAction
extends SortableSelectionAction
implements UiConstants {
    private static final String IMPORT_PROBLEM_KEY = "ImportTransformationSqlFromTextAction.importProb";
    private static final String IMPORT_SQL_DIALOG_TITLE_KEY = "ImportTransformationSqlFromTextAction.importSqlDialog.title";
    private static final String IMPORT_SQL_PROBLEM_DIALOG_TITLE_KEY = "ImportTransformationSqlFromTextAction.importSqlProblemDialog.title";
    private static final String UNUSED_SQL_DIALOG_TITLE_KEY = "ImportTransformationSqlFromTextAction.unusedSqlDialogTitle";
    private static final String UNUSED_SQL_DIALOG_MESSAGE_KEY = "ImportTransformationSqlFromTextAction.unusedSqlDialogMessage";
    private static final String MONITOR_MAIN_TASK_NAME_KEY = "ImportTransformationSqlFromTextAction.monitorMainTaskName";
    private static final String MONITOR_TASK_SETTING_SQL_KEY = "ImportTransformationSqlFromTextAction.monitorTaskSettingSql";
    private static final String MONITOR_TASK_RECONCILING_KEY = "ImportTransformationSqlFromTextAction.monitorTaskReconciling";
    private static final String MONITOR_TASK_VALIDATING_SQL_KEY = "ImportTransformationSqlFromTextAction.monitorTaskValidatingSql";
    static final String MONITOR_TASK_SAVING_MODEL = UiConstants.Util.getString("ImportTransformationSqlFromTextAction.monitorTaskSavingModel", new Object[0]);
    private static final String DELIMETER = "\\|";
    private boolean isTestingMode = false;
    private Collection anyLeftOverRows;

    public boolean isValidSelection(ISelection selection) {
        return this.virtualModelSelected(selection);
    }

    public void run() {
        Object selectedObj;
        ISelection cachedSelection = this.getSelection();
        if (cachedSelection != null && !cachedSelection.isEmpty() && (selectedObj = SelectionUtilities.getSelectedObject((ISelection)cachedSelection)) != null && selectedObj instanceof IFile) {
            ModelResource modelResource = null;
            try {
                String fileName;
                modelResource = ModelUtil.getModelResource((IFile)((IFile)selectedObj), (boolean)false);
                if (modelResource != null && (fileName = this.askUserForInputFilename()) != null) {
                    this.importSqlFromFile(fileName, modelResource);
                }
            }
            catch (ModelWorkspaceException e) {
                UiConstants.Util.log((Throwable)e);
            }
        }
        this.selectionChanged(null, (ISelection)new StructuredSelection());
    }

    public boolean isApplicable(ISelection selection) {
        return this.virtualModelSelected(selection);
    }

    private boolean virtualModelSelected(ISelection theSelection) {
        boolean result = false;
        List allObjs = SelectionUtilities.getSelectedObjects((ISelection)theSelection);
        if (!allObjs.isEmpty() && allObjs.size() == 1) {
            Iterator iter = allObjs.iterator();
            result = true;
            Object nextObj = null;
            while (iter.hasNext() && result) {
                nextObj = iter.next();
                result = nextObj instanceof IFile ? ModelIdentifier.isRelationalViewModel((IResource)((IFile)nextObj)) : false;
            }
        }
        return result;
    }

    public Collection getSqlRowsFromFile(String fileString) {
        CoreArgCheck.isNotNull((Object)fileString);
        CoreArgCheck.isNotEmpty((String)fileString);
        ArrayList<SqlRow> sqlRows = new ArrayList<SqlRow>();
        FileReader fileReader = null;
        BufferedReader bufferReader = null;
        try {
            try {
                String str;
                fileReader = new FileReader(fileString);
                bufferReader = new BufferedReader(fileReader);
                while ((str = bufferReader.readLine()) != null) {
                    SqlRow newRow = this.createSqlRow(str);
                    if (newRow == null) continue;
                    sqlRows.add(newRow);
                }
            }
            catch (Exception e) {
                String msg = UiConstants.Util.getString(IMPORT_PROBLEM_KEY, new Object[0]);
                UiConstants.Util.log(4, (Throwable)e, msg);
                String dialogMessage = String.valueOf(msg) + "\n" + e.getMessage();
                if (!this.isTestingMode) {
                    this.displayError(this.getShell(), UiConstants.Util.getString(IMPORT_SQL_PROBLEM_DIALOG_TITLE_KEY, new Object[0]), dialogMessage);
                }
                try {
                    if (fileReader != null) {
                        fileReader.close();
                    }
                }
                catch (IOException e2) {
                    UiConstants.Util.log(4, (Throwable)e2, UiConstants.Util.getString(IMPORT_PROBLEM_KEY, new Object[0]));
                }
                try {
                    if (bufferReader != null) {
                        bufferReader.close();
                    }
                }
                catch (IOException e3) {
                    UiConstants.Util.log(4, (Throwable)e3, UiConstants.Util.getString(IMPORT_PROBLEM_KEY, new Object[0]));
                }
            }
        }
        finally {
            try {
                if (fileReader != null) {
                    fileReader.close();
                }
            }
            catch (IOException e) {
                UiConstants.Util.log(4, (Throwable)e, UiConstants.Util.getString(IMPORT_PROBLEM_KEY, new Object[0]));
            }
            try {
                if (bufferReader != null) {
                    bufferReader.close();
                }
            }
            catch (IOException e) {
                UiConstants.Util.log(4, (Throwable)e, UiConstants.Util.getString(IMPORT_PROBLEM_KEY, new Object[0]));
            }
        }
        return sqlRows;
    }

    public Collection importSqlFromFile(String fileString, ModelResource modelResource) {
        Collection unusedSqlRows = Collections.EMPTY_LIST;
        CoreArgCheck.isNotNull((Object)fileString);
        CoreArgCheck.isNotNull((Object)modelResource);
        CoreArgCheck.isNotEmpty((String)fileString);
        Collection sqlRows = this.getSqlRowsFromFile(fileString);
        if (!sqlRows.isEmpty()) {
            unusedSqlRows = this.processRows(modelResource, sqlRows);
        }
        return unusedSqlRows;
    }

    private String askUserForInputFilename() {
        FileDialog dlg = new FileDialog(this.getShell(), 4096);
        dlg.setFilterExtensions(new String[]{"*.txt", "*.*"});
        dlg.setText(UiConstants.Util.getString(IMPORT_SQL_DIALOG_TITLE_KEY, new Object[0]));
        return dlg.open();
    }

    private Collection processRows(final ModelResource modelResource, final Collection sqlRows) {
        IRunnableWithProgress op = new IRunnableWithProgress(){

            public void run(IProgressMonitor monitor) throws InvocationTargetException {
                monitor.beginTask(UiConstants.Util.getString(ImportTransformationSqlFromTextAction.MONITOR_MAIN_TASK_NAME_KEY, (Object)modelResource.getItemName()), 10 * sqlRows.size() + 10);
                try {
                    ImportTransformationSqlFromTextAction.this.setTransformationSql(modelResource, sqlRows, monitor);
                }
                catch (ModelWorkspaceException theException) {
                    UiConstants.Util.log((Throwable)theException);
                }
                monitor.subTask(MONITOR_TASK_SAVING_MODEL);
                monitor.worked(5);
                try {
                    ModelUtilities.saveModelResource((ModelResource)modelResource, (IProgressMonitor)monitor, (boolean)false, (Object)this);
                }
                catch (Exception e) {
                    throw new InvocationTargetException(e);
                }
                monitor.worked(5);
            }
        };
        try {
            ProgressMonitorDialog dlg = new ProgressMonitorDialog(this.getShell());
            dlg.run(false, true, op);
            dlg.getProgressMonitor().isCanceled();
        }
        catch (InterruptedException interruptedException) {
        }
        catch (Exception err) {
            Throwable t = err;
            if (err instanceof InvocationTargetException) {
                t = err.getCause();
            }
            WidgetUtil.showError((Throwable)t);
        }
        ArrayList returnedRows = Collections.EMPTY_LIST;
        if (this.anyLeftOverRows != null) {
            returnedRows = new ArrayList(this.anyLeftOverRows);
            this.anyLeftOverRows = null;
        }
        return returnedRows;
    }

    private Shell getShell() {
        return UiPlugin.getDefault().getWorkbench().getActiveWorkbenchWindow().getShell();
    }

    private void displayError(final Shell shell, final String dialogTitle, final String message) {
        shell.getDisplay().syncExec(new Runnable(){

            @Override
            public void run() {
                MessageDialog.openError((Shell)shell, (String)dialogTitle, (String)message);
            }
        });
    }

    private void notifyUserOfLeftovers(final ModelResource modelResource, final List leftOverTables, final List<SqlRow> leftOverRows) {
        if (!this.isTestingMode && !leftOverTables.isEmpty()) {
            final Shell shell = this.getShell();
            shell.getDisplay().syncExec(new Runnable(){

                @Override
                public void run() {
                    boolean result = ListMessageDialog.openQuestion((Shell)shell, (String)UiConstants.Util.getString(ImportTransformationSqlFromTextAction.UNUSED_SQL_DIALOG_TITLE_KEY, new Object[0]), null, (String)UiConstants.Util.getString(ImportTransformationSqlFromTextAction.UNUSED_SQL_DIALOG_MESSAGE_KEY, new Object[0]), (List)leftOverTables, null);
                    if (result) {
                        VirtualRelationalObjectProcessor virtualRelationalObjectProcessor = new VirtualRelationalObjectProcessor();
                        ModelResource location = null;
                        for (SqlRow row : leftOverRows) {
                            ArrayList<VirtualTableRowObject> virtTableRows;
                            location = modelResource;
                            Path path = new Path(row.getPath());
                            String tableName = null;
                            if (path.segmentCount() == 2) {
                                virtTableRows = new ArrayList<VirtualTableRowObject>();
                                tableName = path.lastSegment();
                                String schemaName = path.segment(0);
                                location = virtualRelationalObjectProcessor.createSchema(modelResource, schemaName);
                                virtTableRows.add(new VirtualTableRowObject(tableName, null, row.getSql()));
                                virtualRelationalObjectProcessor.generateObjsFromRowObjs(modelResource, location, virtTableRows);
                                continue;
                            }
                            virtTableRows = new ArrayList();
                            tableName = path.toString();
                            virtTableRows.add(new VirtualTableRowObject(tableName, null, row.getSql()));
                            virtualRelationalObjectProcessor.generateObjsFromRowObjs(modelResource, location, virtTableRows);
                        }
                    }
                }
            });
        }
    }

    /*
     * Unable to fully structure code
     */
    private SqlRow createSqlRow(String rowString) {
        parsedString = rowString.split("\\|");
        sql = parsedString[2];
        sb = new StringBuilder();
        escaped = false;
        i = 0;
        while (i < sql.length()) {
            block5: {
                c = sql.charAt(i);
                if (!escaped) break block5;
                escaped = false;
                if (c == 110) {
                    c = 10;
                }
                ** GOTO lbl-1000
            }
            if (c == 92) {
                escaped = true;
            } else lbl-1000:
            // 2 sources

            {
                sb.append((char)c);
            }
            ++i;
        }
        if (escaped) {
            sb.append('\\');
        }
        return new SqlRow(this.getSqlTypeFromString(parsedString[1]), parsedString[0], sb.toString());
    }

    boolean setTransformationSql(ModelResource modelResource, Collection sqlRows, IProgressMonitor monitor) throws ModelWorkspaceException {
        boolean sqlChanged = false;
        HashSet<String> leftOverTables = new HashSet<String>();
        HashSet<SqlRow> leftOverRows = new HashSet<SqlRow>();
        String tableName = null;
        for (SqlRow nextRow : sqlRows) {
            EObject existingTable = null;
            Path tablePath = new Path(nextRow.getPath());
            tableName = tablePath.lastSegment();
            existingTable = ModelerCore.getModelEditor().findObjectByPath(modelResource.getEmfResource(), (IPath)tablePath);
            if (existingTable != null) {
                SqlTransformationMappingRoot root = (SqlTransformationMappingRoot)TransformationHelper.getTransformationMappingRoot((EObject)existingTable);
                if (root == null) continue;
                monitor.subTask(UiConstants.Util.getString(MONITOR_TASK_SETTING_SQL_KEY, (Object)nextRow.getPath()));
                TransformationValidator validator = new TransformationValidator(root);
                boolean changed = false;
                switch (nextRow.getType()) {
                    case 0: {
                        changed = TransformationHelper.setSqlString((Object)root, (String)nextRow.getSql(), (int)0, (boolean)false, (Object)this);
                        monitor.subTask(UiConstants.Util.getString(MONITOR_TASK_RECONCILING_KEY, (Object)tableName));
                        monitor.worked(3);
                        TransformationMappingHelper.reconcileMappingsOnSqlChange((EObject)root, (Object)this);
                        monitor.subTask(UiConstants.Util.getString(MONITOR_TASK_VALIDATING_SQL_KEY, (Object)tableName));
                        monitor.worked(3);
                        validator.validateSql(nextRow.getSql(), 0, true);
                        monitor.worked(4);
                        break;
                    }
                    case 1: {
                        changed = TransformationHelper.setSqlString((Object)root, (String)nextRow.getSql(), (int)1, (boolean)false, (Object)this);
                        monitor.subTask(UiConstants.Util.getString(MONITOR_TASK_VALIDATING_SQL_KEY, (Object)tableName));
                        monitor.worked(5);
                        validator.validateSql(nextRow.getSql(), 1, true);
                        monitor.worked(5);
                        break;
                    }
                    case 2: {
                        changed = TransformationHelper.setSqlString((Object)root, (String)nextRow.getSql(), (int)2, (boolean)false, (Object)this);
                        monitor.subTask(UiConstants.Util.getString(MONITOR_TASK_VALIDATING_SQL_KEY, (Object)tableName));
                        monitor.worked(5);
                        validator.validateSql(nextRow.getSql(), 2, true);
                        monitor.worked(5);
                        break;
                    }
                    case 3: {
                        changed = TransformationHelper.setSqlString((Object)root, (String)nextRow.getSql(), (int)3, (boolean)false, (Object)this);
                        monitor.worked(5);
                        monitor.subTask(UiConstants.Util.getString(MONITOR_TASK_VALIDATING_SQL_KEY, (Object)tableName));
                        validator.validateSql(nextRow.getSql(), 3, true);
                        monitor.worked(5);
                        break;
                    }
                }
                if (!changed) continue;
                sqlChanged = true;
                continue;
            }
            if (leftOverTables.contains(nextRow.getPath())) continue;
            leftOverTables.add(nextRow.getPath());
            leftOverRows.add(nextRow);
        }
        this.anyLeftOverRows = leftOverRows;
        this.notifyUserOfLeftovers(modelResource, new ArrayList(leftOverTables), new ArrayList<SqlRow>(leftOverRows));
        return sqlChanged;
    }

    private int getSqlTypeFromString(String typeString) {
        if (typeString.equalsIgnoreCase("SELECT")) {
            return 0;
        }
        if (typeString.equalsIgnoreCase("INSERT")) {
            return 1;
        }
        if (typeString.equalsIgnoreCase("UPDATE")) {
            return 2;
        }
        if (typeString.equalsIgnoreCase("DELETE")) {
            return 3;
        }
        return -1;
    }

    public boolean isTestingMode() {
        return this.isTestingMode;
    }

    public void setIsTestingMode(boolean theIsTestingMode) {
        this.isTestingMode = theIsTestingMode;
    }

    class SqlRow {
        private int type;
        private String path;
        private String sql;

        SqlRow(int sqlType, String relativePathAndName, String userSqlString) {
            this.type = sqlType;
            this.path = relativePathAndName;
            this.sql = userSqlString;
        }

        public String getPath() {
            return this.path;
        }

        public String getSql() {
            return this.sql;
        }

        public int getType() {
            return this.type;
        }
    }
}

