/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.jbpm.convert.b2j.translate;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.dom4j.Document;
import org.dom4j.Element;
import org.jboss.tools.jbpm.convert.b2j.translate.TranslateHelper;
import org.jboss.tools.jbpm.convert.bpmnto.translate.BPMNTranslator;
import org.jboss.tools.jbpm.convert.bpmnto.util.BPMNToUtil;
import org.jboss.tools.jbpm.convert.bpmnto.util.DomXmlWriter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BPMN2JPDL
extends BPMNTranslator {
    private Document bpmnDocument;
    private List<Document> processDefs = new ArrayList<Document>();
    private Map<String, Element> map = new HashMap<String, Element>();
    private Map<String, String> sourceMap = new HashMap<String, String>();
    private Map<String, String> targetMap = new HashMap<String, String>();

    public BPMN2JPDL() {
    }

    public BPMN2JPDL(String bpmnFileName, String bpmnFilePath) {
        super(bpmnFileName, bpmnFilePath, null);
    }

    public BPMN2JPDL(String bpmnFileName, String bpmnFilePath, Document bpmnDocument) {
        this(bpmnFileName, bpmnFilePath, null, bpmnDocument);
    }

    public BPMN2JPDL(String bpmnFileName, String bpmnFilePath, List<String> poolIDList, Document bpmnDocument) {
        super(bpmnFileName, bpmnFilePath, poolIDList);
        this.bpmnDocument = bpmnDocument;
    }

    public String[] translateToStrings() {
        this.translateDiagram();
        String[] strForProcessDefs = new String[this.processDefs.size()];
        int i = 0;
        for (Document def : this.processDefs) {
            try {
                strForProcessDefs[i] = DomXmlWriter.toString(def);
            }
            catch (IOException e) {
                this.errors.add("Error: Couldn't write process definition xml: " + e.getMessage());
            }
            ++i;
        }
        return strForProcessDefs;
    }

    public void translateToFiles(String fileLocation) {
        String[] strForProcessDefs = this.translateToStrings();
        String[] jpdlFileNames = new String[this.processDefs.size()];
        int i = 0;
        for (Document def : this.processDefs) {
            jpdlFileNames[i] = def.getName();
            ++i;
        }
        try {
            TranslateHelper.createFiles(fileLocation, this.bpmnFileName, strForProcessDefs, jpdlFileNames, "processdefinition.xml", false);
        }
        catch (Exception e) {
            this.errors.add("Error: Couldn't write process definition to a jpdl file: " + e.getMessage());
        }
    }

    @Override
    public void translateDiagram() {
        TranslateHelper.setNameMap(new HashMap<String, Integer>());
        if (this.bpmnDocument == null) {
            try {
                this.bpmnDocument = BPMNToUtil.parse(this.rootLocation, this.bpmnFileName);
            }
            catch (Exception e) {
                this.errors.add("Error: Couldn't read or parse the file to a DOM document:" + e.getMessage());
            }
        }
        Element diagram = this.bpmnDocument.getRootElement();
        if (this.poolIDList == null || this.poolIDList.size() == 0) {
            for (Object pool : diagram.elements("pools")) {
                this.translateGraph((Element)pool);
            }
        } else {
            for (Object pool : diagram.elements("pools")) {
                if (!this.poolIDList.contains(((Element)pool).attributeValue("iD"))) continue;
                this.translateGraph((Element)pool);
            }
        }
    }

    private Element translateGraph(Element graph) {
        Document processDef = TranslateHelper.createJpdlDomTree(true);
        Element processRoot = processDef.getRootElement();
        DomXmlWriter.addAttribute(processRoot, "name", TranslateHelper.generateProcessName(graph));
        processDef.setName(processRoot.attributeValue("name"));
        this.map.put(String.valueOf(graph.attributeValue("id")) + "pools", processRoot);
        for (Object activity : graph.elements()) {
            if (!"vertices".equals(((Element)activity).getName())) continue;
            this.translateActivity((Element)activity, processRoot);
            this.getSequenceFlowInfo((Element)activity);
        }
        this.translateSequenceFlows(graph, processRoot);
        this.processDefs.add(processDef);
        return processRoot;
    }

    private void getSequenceFlowInfo(Element activity) {
        int n;
        int n2;
        String[] stringArray;
        String id = activity.attributeValue("id");
        String ins = activity.attributeValue("incomingEdges");
        String outs = activity.attributeValue("outgoingEdges");
        String[] inArray = null;
        String[] outArray = null;
        if (ins != null) {
            stringArray = inArray = ins.split(" ");
            n2 = inArray.length;
            n = 0;
            while (n < n2) {
                String in = stringArray[n];
                this.targetMap.put(in, id);
                ++n;
            }
        }
        if (outs != null) {
            stringArray = outArray = outs.split(" ");
            n2 = outArray.length;
            n = 0;
            while (n < n2) {
                String out = stringArray[n];
                this.sourceMap.put(out, id);
                ++n;
            }
        }
    }

    private void translateActivity(Element activity, Element processRoot) {
        String type = activity.attributeValue("type");
        Element element = null;
        if ("bpmn:Activity".equals(type)) {
            String activityType = activity.attributeValue("activityType");
            if (activityType == null || "Task".equals(activityType)) {
                element = DomXmlWriter.addElement(processRoot, "node");
            } else if ("EventStartEmpty".equals(activityType) || "EventStartMessage".equals(activityType) || "EventStartRule".equals(activityType) || "EventStartTimer".equals(activityType) || "EventStartLink".equals(activityType) || "EventStartMultiple".equals(activityType) || "EventStartSignal".equals(activityType)) {
                element = DomXmlWriter.addElement(processRoot, "start-state");
                if (!"EventStartEmpty".equals(activityType)) {
                    this.warnings.add("Warning: The type of this bpmn element is not translated to corresponding jpdl element: " + activityType);
                }
            } else if ("EventIntermediateEmpty".equals(activityType) || "EventIntermediateMessage".equals(activityType) || "EventIntermediateTimer".equals(activityType) || "EventIntermediateError".equals(activityType) || "EventIntermediateCompensation".equals(activityType) || "EventIntermediateRule".equals(activityType) || "EventIntermediateMultiple".equals(activityType) || "EventIntermediateCancel".equals(activityType) || "EventIntermediateLink".equals(activityType) || "EventIntermediateSignal".equals(activityType)) {
                element = DomXmlWriter.addElement(processRoot, "state");
                if (!"EventIntermediateEmpty".equals(activityType)) {
                    this.warnings.add("Warning: The type of this bpmn element is not translated to corresponding jpdl element: " + activityType);
                }
            } else if ("EventEndEmpty".equals(activityType) || "EventEndMessage".equals(activityType) || "EventEndError".equals(activityType) || "EventEndCompensation".equals(activityType) || "EventEndTerminate".equals(activityType) || "EventEndLink".equals(activityType) || "EventEndMultiple".equals(activityType) || "EventEndCancel".equals(activityType) || "EventEndSignal".equals(activityType)) {
                element = DomXmlWriter.addElement(processRoot, "end-state");
                if (!"EventEndEmpty".equals(activityType)) {
                    this.warnings.add("Warning: The type of this bpmn element is not translated to corresponding jpdl element: " + activityType);
                }
            } else if ("GatewayDataBasedExclusive".equals(activityType) || "GatewayEventBasedExclusive".equals(activityType) || "GatewayComplex".equals(activityType)) {
                element = DomXmlWriter.addElement(processRoot, "decision");
                if (!"GatewayDataBasedExclusive".equals(activityType)) {
                    this.warnings.add("Warning: The type of this bpmn element is not translated to corresponding jpdl element: " + activityType);
                }
            } else if ("GatewayParallel".equals(activityType) || "GatewayDataBasedInclusive".equals(activityType)) {
                element = activity.attributeValue("incomingEdges") == null || activity.attributeValue("incomingEdges").split(" ").length == 1 ? DomXmlWriter.addElement(processRoot, "fork") : DomXmlWriter.addElement(processRoot, "join");
                if (!"GatewayDataBasedInclusive".equals(activityType)) {
                    this.warnings.add("Warning: The type of this bpmn element is not translated to corresponding jpdl element: " + activityType);
                }
            }
        } else if ("bpmn:SubProcess".equals(type)) {
            element = DomXmlWriter.addElement(processRoot, "process-state");
            this.translateSubprocess(activity, element);
        }
        if (!TranslateHelper.check_mapElementName(activity, element, false)) {
            this.warnings.add("Warning: The bpmn element's name is null or same to another element's name:" + activity.attributeValue("iD"));
        }
        this.map.put(activity.attributeValue("id"), element);
        if ("true".equals(activity.attributeValue("looping"))) {
            this.createMockLoop(activity, element);
        }
    }

    private void translateSubprocess(Element subProcess, Element element) {
        Element details;
        Element processRoot = this.translateGraph(subProcess);
        Element ele = DomXmlWriter.addElement(element, "sub-process");
        DomXmlWriter.mapAttribute(ele, "name", processRoot);
        Element eAnnot = subProcess.element("eAnnotations");
        if (eAnnot != null && (details = eAnnot.element("details")) != null && "true".equals(details.attributeValue("value"))) {
            this.translateTransaction(processRoot);
        }
    }

    private void translateTransaction(Element processRoot) {
        List<Element> lastEleList = TranslateHelper.locateLastElements(processRoot);
        if (lastEleList.size() == 0) {
            return;
        }
        Element decision = DomXmlWriter.addElement(processRoot, "decision");
        DomXmlWriter.addAttribute(decision, "name", "Successful?");
        String bpmnId = null;
        for (String key : this.map.keySet()) {
            if (this.map.get(key) != lastEleList.get(0)) continue;
            bpmnId = key;
            break;
        }
        this.map.put(String.valueOf(bpmnId) + "Decision", decision);
        for (Element ele : lastEleList) {
            Element transition = DomXmlWriter.addElement(ele, "transition");
            transition.addAttribute("name", String.valueOf(ele.attributeValue("name")) + "to" + "decision");
            transition.addAttribute("to", decision.attributeValue("name"));
        }
        Element complete = DomXmlWriter.addElement(processRoot, "node");
        DomXmlWriter.addAttribute(complete, "name", "Complete");
        this.map.put(String.valueOf(bpmnId) + "Complete", complete);
        Element cancel = DomXmlWriter.addElement(processRoot, "node");
        DomXmlWriter.addAttribute(cancel, "name", "Cancel");
        this.map.put(String.valueOf(bpmnId) + "Cancel", cancel);
        Element toComplete = DomXmlWriter.addElement(decision, "transition");
        toComplete.addAttribute("name", "true");
        toComplete.addAttribute("to", complete.attributeValue("name"));
        Element toCancel = DomXmlWriter.addElement(decision, "transition");
        toCancel.addAttribute("name", "false");
        toCancel.addAttribute("to", cancel.attributeValue("name"));
    }

    private void translateSequenceFlows(Element graph, Element processRoot) {
        for (Object edge : graph.elements("sequenceEdges")) {
            this.translateSequenceFlow((Element)edge, processRoot);
        }
    }

    private void translateSequenceFlow(Element edge, Element processRoot) {
        Element source = this.map.get(this.sourceMap.get(edge.attributeValue("id")));
        Element transition = null;
        transition = "true".equals(edge.attributeValue("isDefault")) && source.element("transition") != null ? DomXmlWriter.addElement(source, "transition", 0) : DomXmlWriter.addElement(source, "transition");
        transition.addAttribute("to", this.map.get(this.targetMap.get(edge.attributeValue("id"))).attributeValue("name"));
        if (!TranslateHelper.check_mapElementName(edge, transition, true)) {
            this.warnings.add("Warning: The bpmn element's name is null or same to another element's name:" + edge.attributeValue("iD"));
        }
    }

    private void createMockLoop(Element activity, Element element) {
        Element decision = DomXmlWriter.addElement(element.getParent(), "decision");
        String name = String.valueOf(TranslateHelper.generateElementName(activity)) + "_" + "Loop_Decition";
        DomXmlWriter.addAttribute(decision, "name", name);
        this.map.put(activity.attributeValue("id"), decision);
        this.map.put(String.valueOf(activity.attributeValue("id")) + "vertices", element);
        Element first = DomXmlWriter.addElement(element, "transition");
        first.addAttribute("name", "to_" + name);
        first.addAttribute("to", decision.attributeValue("name"));
        Element second = DomXmlWriter.addElement(decision, "transition");
        second.addAttribute("name", "to_" + element.attributeValue("name"));
        second.addAttribute("to", element.attributeValue("name"));
    }

    public List<Document> getProcessDefs() {
        return this.processDefs;
    }

    public void setProcessDefs(List<Document> processDefs) {
        this.processDefs = processDefs;
    }

    public Map<String, Element> getMap() {
        return this.map;
    }

    public void setMap(Map<String, Element> map) {
        this.map = map;
    }
}

