/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.bpmn2.modeler.core.validation.validators;

import org.eclipse.bpmn2.Activity;
import org.eclipse.bpmn2.AdHocSubProcess;
import org.eclipse.bpmn2.BoundaryEvent;
import org.eclipse.bpmn2.CatchEvent;
import org.eclipse.bpmn2.CompensateEventDefinition;
import org.eclipse.bpmn2.EventDefinition;
import org.eclipse.bpmn2.FlowNode;
import org.eclipse.bpmn2.SubProcess;
import org.eclipse.bpmn2.ThrowEvent;
import org.eclipse.bpmn2.modeler.core.preferences.Bpmn2Preferences;
import org.eclipse.bpmn2.modeler.core.validation.validators.AbstractBpmn2ElementValidator;
import org.eclipse.bpmn2.modeler.core.validation.validators.Messages;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.validation.IValidationContext;

public class FlowNodeValidator
extends AbstractBpmn2ElementValidator<FlowNode> {
    public FlowNodeValidator(IValidationContext ctx) {
        super(ctx);
    }

    public FlowNodeValidator(AbstractBpmn2ElementValidator parent) {
        super(parent);
    }

    @Override
    public IStatus validate(FlowNode object) {
        boolean needIncoming = true;
        boolean needOutgoing = true;
        if (object instanceof ThrowEvent) {
            needOutgoing = false;
        }
        if (object instanceof CatchEvent) {
            needIncoming = false;
        }
        if (object instanceof SubProcess && ((SubProcess)object).isTriggeredByEvent()) {
            if (object.getOutgoing().size() > 0) {
                this.addStatus((EObject)object, "outgoing", 4, Messages.FlowNodeValidator_EventSubProcess_Has_Outgoing, new Object[0]);
            }
            if (object.getIncoming().size() > 0) {
                this.addStatus((EObject)object, "incoming", 4, Messages.FlowNodeValidator_EventSubProcess_Has_Incoming, new Object[0]);
            }
            needIncoming = false;
            needOutgoing = false;
        }
        if (object instanceof Activity && ((Activity)object).isIsForCompensation()) {
            needIncoming = false;
            needOutgoing = false;
        }
        if (object instanceof BoundaryEvent) {
            for (EventDefinition ed : ((BoundaryEvent)object).getEventDefinitions()) {
                if (!(ed instanceof CompensateEventDefinition)) continue;
                needOutgoing = false;
                break;
            }
        }
        if (object.eContainer() instanceof AdHocSubProcess) {
            needIncoming = false;
            needOutgoing = false;
        }
        if (needOutgoing && (object.getOutgoing() == null || object.getOutgoing().size() < 1)) {
            this.addMissingFeatureStatus((EObject)object, "outgoing", 4);
        }
        if (needIncoming && (object.getIncoming() == null || object.getIncoming().size() < 1)) {
            this.addMissingFeatureStatus((EObject)object, "incoming", 4);
        }
        if (!Bpmn2Preferences.getInstance((EObject)object).getAllowMultipleConnections()) {
            if (object.getIncoming().size() > 1) {
                this.addStatus((EObject)object, 2, Messages.FlowNodeValidator_Only_One_Incoming_Allowed, object.eClass().getName());
            }
            if (object.getOutgoing().size() > 1) {
                this.addStatus((EObject)object, 2, Messages.FlowNodeValidator_Only_One_Outgoing_Allowed, object.eClass().getName());
            }
        }
        return this.getResult();
    }
}

