/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.bpmn2.modeler.core.validation.validators;

import java.util.HashSet;
import org.eclipse.bpmn2.BaseElement;
import org.eclipse.bpmn2.Bpmn2Package;
import org.eclipse.bpmn2.Definitions;
import org.eclipse.bpmn2.modeler.core.utils.ModelUtil;
import org.eclipse.bpmn2.modeler.core.validation.SyntaxCheckerUtils;
import org.eclipse.bpmn2.modeler.core.validation.validators.AbstractBpmn2ElementValidator;
import org.eclipse.bpmn2.modeler.core.validation.validators.Messages;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.validation.IValidationContext;

public class BaseElementValidator
extends AbstractBpmn2ElementValidator<BaseElement> {
    protected static HashSet<EClass> idOptional = new HashSet();

    static {
        idOptional.add(Bpmn2Package.eINSTANCE.getDefinitions());
    }

    public BaseElementValidator(IValidationContext ctx) {
        super(ctx);
    }

    public BaseElementValidator(AbstractBpmn2ElementValidator other) {
        super(other);
    }

    @Override
    public IStatus validate(BaseElement object) {
        if (!idOptional.contains(object.eClass())) {
            String id = object.getId();
            if (BaseElementValidator.isEmpty(id)) {
                this.addStatus((EObject)object, "id", 4, Messages.BaseElementValidator_ID_Is_Empty, object.eClass().getName());
            } else if (!SyntaxCheckerUtils.isNCName(id)) {
                this.addStatus((EObject)object, "id", 4, Messages.BaseElementValidator_ID_Is_Invalid, object.eClass().getName(), id);
            }
            Definitions definitions = ModelUtil.getDefinitions(object);
            TreeIterator iter = definitions.eAllContents();
            while (iter.hasNext()) {
                EObject o2 = (EObject)iter.next();
                if (!(o2 instanceof BaseElement) || object == o2) continue;
                String id2 = ((BaseElement)o2).getId();
                if (id == null || id2 == null || !id.equals(id2)) continue;
                this.addStatus((EObject)object, 4, Messages.BaseElementValidator_Duplicate_IDs, String.valueOf(this.getLabel((EObject)object)) + " " + this.getName((EObject)object), String.valueOf(this.getLabel(o2)) + " " + this.getName(o2));
            }
        }
        return this.getResult();
    }

    @Override
    public boolean doLiveValidation() {
        return true;
    }
}

