/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.bpmn2.modeler.core.features.event;

import org.eclipse.bpmn2.BaseElement;
import org.eclipse.bpmn2.Event;
import org.eclipse.bpmn2.modeler.core.features.AbstractBpmn2AddFeature;
import org.eclipse.bpmn2.modeler.core.features.label.AddShapeLabelFeature;
import org.eclipse.bpmn2.modeler.core.utils.FeatureSupport;
import org.eclipse.bpmn2.modeler.core.utils.ShapeDecoratorUtil;
import org.eclipse.bpmn2.modeler.core.utils.StyleUtil;
import org.eclipse.graphiti.features.IAddFeature;
import org.eclipse.graphiti.features.IFeatureProvider;
import org.eclipse.graphiti.features.context.IAddContext;
import org.eclipse.graphiti.features.context.ITargetContext;
import org.eclipse.graphiti.mm.PropertyContainer;
import org.eclipse.graphiti.mm.algorithms.Ellipse;
import org.eclipse.graphiti.mm.algorithms.GraphicsAlgorithm;
import org.eclipse.graphiti.mm.algorithms.Rectangle;
import org.eclipse.graphiti.mm.pictograms.AnchorContainer;
import org.eclipse.graphiti.mm.pictograms.ContainerShape;
import org.eclipse.graphiti.mm.pictograms.PictogramElement;
import org.eclipse.graphiti.mm.pictograms.Shape;

public abstract class AddEventFeature<T extends Event>
extends AbstractBpmn2AddFeature<T> {
    public AddEventFeature(IFeatureProvider fp) {
        super(fp);
    }

    @Override
    public IAddFeature getAddLabelFeature(IFeatureProvider fp) {
        return new AddShapeLabelFeature(fp);
    }

    public boolean canAdd(IAddContext context) {
        return FeatureSupport.isValidFlowElementTarget((ITargetContext)context);
    }

    public PictogramElement add(IAddContext context) {
        int height;
        Event businessObject = (Event)this.getBusinessObject(context);
        int width = this.getWidth(context);
        if (width != (height = this.getHeight(context))) {
            width = height = Math.min(width, height);
        }
        this.adjustLocation(context, width, height);
        int x = context.getX();
        int y = context.getY();
        ContainerShape containerShape = peService.createContainerShape(context.getTargetContainer(), true);
        Rectangle invisibleRect = gaService.createInvisibleRectangle((PictogramElement)containerShape);
        gaService.setLocationAndSize((GraphicsAlgorithm)invisibleRect, x, y, width, height);
        Shape ellipseShape = peService.createShape(containerShape, false);
        peService.setPropertyValue((PropertyContainer)ellipseShape, "event.graphics.element", "event.graphics.element.circle");
        peService.setPropertyValue((PropertyContainer)containerShape, "event.marker.container", Boolean.toString(true));
        Ellipse ellipse = ShapeDecoratorUtil.createEventShape(ellipseShape, width, height);
        StyleUtil.applyStyle((GraphicsAlgorithm)ellipse, (BaseElement)businessObject);
        boolean isImport = context.getProperty((Object)"is.importing") != null;
        this.createDIShape((Shape)containerShape, (BaseElement)businessObject, !isImport);
        this.decorateShape(context, containerShape, businessObject);
        peService.createChopboxAnchor((AnchorContainer)containerShape);
        this.splitConnection(context, containerShape);
        return containerShape;
    }
}

