/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.bpmn2.modeler.core.features.containers.participant;

import org.eclipse.bpmn2.BaseElement;
import org.eclipse.bpmn2.Bpmn2Package;
import org.eclipse.bpmn2.Participant;
import org.eclipse.bpmn2.SubProcess;
import org.eclipse.bpmn2.di.BPMNDiagram;
import org.eclipse.bpmn2.di.BPMNShape;
import org.eclipse.bpmn2.modeler.core.di.DIUtils;
import org.eclipse.bpmn2.modeler.core.features.AbstractBpmn2CreateFeature;
import org.eclipse.bpmn2.modeler.core.features.SubMenuCustomFeature;
import org.eclipse.bpmn2.modeler.core.features.containers.participant.Messages;
import org.eclipse.bpmn2.modeler.core.utils.BusinessObjectUtil;
import org.eclipse.dd.di.DiagramElement;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.graphiti.features.ICreateFeature;
import org.eclipse.graphiti.features.IFeature;
import org.eclipse.graphiti.features.IFeatureProvider;
import org.eclipse.graphiti.features.context.IAreaContext;
import org.eclipse.graphiti.features.context.IContext;
import org.eclipse.graphiti.features.context.ICreateContext;
import org.eclipse.graphiti.features.context.ICustomContext;
import org.eclipse.graphiti.features.context.impl.CreateContext;
import org.eclipse.graphiti.features.custom.AbstractCustomFeature;
import org.eclipse.graphiti.mm.pictograms.ContainerShape;
import org.eclipse.graphiti.mm.pictograms.Diagram;
import org.eclipse.graphiti.mm.pictograms.PictogramElement;
import org.eclipse.graphiti.tb.ContextMenuEntry;
import org.eclipse.graphiti.tb.IContextMenuEntry;

public class CreateParticipantReferenceFeature
extends AbstractCustomFeature {
    protected boolean changesDone = false;

    public CreateParticipantReferenceFeature(IFeatureProvider fp) {
        super(fp);
    }

    public String getDescription() {
        return Messages.CreateParticipantReferenceFeature_Create_Pool_Reference_In_Main_Diagram;
    }

    public String getName() {
        return Messages.CreateParticipantReferenceFeature_Create_Pool_Reference;
    }

    public boolean canExecute(ICustomContext context) {
        CreateContext createContext = CreateParticipantReferenceFeature.prepareCreateContext(context);
        if (createContext == null) {
            return false;
        }
        BPMNDiagram thisDiagram = this.getBPMNDiagram(context);
        String key = "context.menu.entry." + this.getName();
        IContextMenuEntry contextMenuEntry = (IContextMenuEntry)context.getProperty((Object)key);
        if (contextMenuEntry != null) {
            if (contextMenuEntry.getChildren().length == 0) {
                for (BPMNDiagram mainDiagram : DIUtils.getBPMNDiagrams((EObject)thisDiagram, 1)) {
                    for (DiagramElement de : mainDiagram.getPlane().getPlaneElement()) {
                        BaseElement bpmnElement;
                        if (!(de instanceof BPMNShape) || !((bpmnElement = ((BPMNShape)de).getBpmnElement()) instanceof Participant)) continue;
                        Participant pool = (Participant)bpmnElement;
                        CreateReferenceFeature feature = new CreateReferenceFeature(this.getFeatureProvider(), (BPMNShape)de, pool);
                        SubMenuCustomFeature submenuFeature = new SubMenuCustomFeature(this, (ICreateFeature)feature);
                        ContextMenuEntry cme = new ContextMenuEntry((IFeature)submenuFeature, (IContext)context);
                        cme.setText(pool.getName());
                        contextMenuEntry.add((IContextMenuEntry)cme);
                    }
                }
            }
            return contextMenuEntry.getChildren().length > 0;
        }
        return true;
    }

    public boolean isAvailable(IContext context) {
        if (context instanceof ICustomContext) {
            return this.getBPMNDiagram((ICustomContext)context) != null;
        }
        return false;
    }

    private BPMNDiagram getBPMNDiagram(ICustomContext context) {
        BPMNDiagram bpmnDiagram;
        PictogramElement[] pes = context.getPictogramElements();
        if (pes.length == 1 && pes[0] instanceof Diagram && (bpmnDiagram = (BPMNDiagram)BusinessObjectUtil.getBusinessObjectForPictogramElement(pes[0])).getPlane().getBpmnElement() instanceof SubProcess) {
            return bpmnDiagram;
        }
        return null;
    }

    public void execute(ICustomContext context) {
        CreateContext createContext;
        CreateReferenceFeature createFeature = (CreateReferenceFeature)context.getProperty((Object)"create.feature");
        if (createFeature != null && createFeature.canCreate((ICreateContext)(createContext = CreateParticipantReferenceFeature.prepareCreateContext(context)))) {
            BPMNShape shape = createFeature.getShape();
            createContext.setWidth((int)shape.getBounds().getWidth());
            createContext.setHeight((int)shape.getBounds().getHeight());
            ContainerShape newShape = (ContainerShape)createFeature.create((ICreateContext)createContext)[0];
            this.getFeatureProvider().getDiagramTypeProvider().getDiagramBehavior().getDiagramContainer().setPictogramElementForSelection((PictogramElement)newShape);
            this.changesDone = true;
        }
    }

    public boolean hasDoneChanges() {
        return this.changesDone;
    }

    protected static CreateContext prepareCreateContext(ICustomContext context) {
        CreateContext cc = new CreateContext();
        PictogramElement[] pes = context.getPictogramElements();
        if (pes == null || pes.length != 1) {
            return null;
        }
        PictogramElement container = pes[0];
        if (!(container instanceof ContainerShape)) {
            return null;
        }
        cc.setTargetContainer((ContainerShape)container);
        cc.setX(context.getX());
        cc.setY(context.getY());
        cc.putProperty((Object)"is.importing", (Object)Boolean.TRUE);
        return cc;
    }

    private static class CreateReferenceFeature
    extends AbstractBpmn2CreateFeature<Participant> {
        Participant pool;
        BPMNShape shape;

        private CreateReferenceFeature(IFeatureProvider fp, BPMNShape shape, Participant pool) {
            this(fp);
            this.shape = shape;
            this.pool = pool;
        }

        private CreateReferenceFeature(IFeatureProvider fp) {
            super(fp);
        }

        @Override
        public boolean canCreate(ICreateContext context) {
            return true;
        }

        public Object[] create(ICreateContext context) {
            PictogramElement pe = this.addGraphicalRepresentation((IAreaContext)context, this.pool);
            return new Object[]{pe};
        }

        @Override
        public EClass getBusinessObjectClass() {
            return Bpmn2Package.eINSTANCE.getParticipant();
        }

        public Participant getPool() {
            return this.pool;
        }

        public BPMNShape getShape() {
            return this.shape;
        }
    }
}

