/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.bpmn2.modeler.core.features;

import org.eclipse.bpmn2.modeler.core.features.BendpointConnectionRouter;
import org.eclipse.bpmn2.modeler.core.features.ConnectionRoute;
import org.eclipse.bpmn2.modeler.core.features.DetourPoints;
import org.eclipse.bpmn2.modeler.core.utils.AnchorUtil;
import org.eclipse.bpmn2.modeler.core.utils.GraphicsUtil;
import org.eclipse.graphiti.features.IFeatureProvider;
import org.eclipse.graphiti.mm.algorithms.styles.Point;
import org.eclipse.graphiti.mm.pictograms.Anchor;
import org.eclipse.graphiti.mm.pictograms.AnchorContainer;
import org.eclipse.graphiti.mm.pictograms.ContainerShape;

public class AutomaticConnectionRouter
extends BendpointConnectionRouter {
    protected static final int margin = 10;

    public AutomaticConnectionRouter(IFeatureProvider fp) {
        super(fp);
    }

    @Override
    protected ConnectionRoute calculateRoute() {
        int length;
        if (this.isSelfConnection()) {
            return this.calculateSelfConnectionRoute();
        }
        GraphicsUtil.debug = false;
        Point start = null;
        Point end = null;
        Point middle = null;
        if (this.movedBendpoint != null) {
            middle = this.movedBendpoint;
        }
        Point ref = (length = this.oldPoints.length) > 2 ? this.oldPoints[1] : GraphicsUtil.getShapeCenter((AnchorContainer)this.target);
        AnchorUtil.moveAnchor(this.sourceAnchor, ref);
        AnchorUtil.adjustAnchors((AnchorContainer)this.source);
        ref = length > 2 ? this.oldPoints[length - 2] : GraphicsUtil.getShapeCenter((AnchorContainer)this.source);
        AnchorUtil.moveAnchor(this.targetAnchor, ref);
        AnchorUtil.adjustAnchors((AnchorContainer)this.target);
        ConnectionRoute route = new ConnectionRoute(this, 1, this.source, this.target);
        start = GraphicsUtil.createPoint((Anchor)this.sourceAnchor);
        end = GraphicsUtil.createPoint((Anchor)this.targetAnchor);
        route.setSourceAnchor(this.sourceAnchor);
        route.setTargetAnchor(this.targetAnchor);
        this.calculateRoute(route, start, middle, end);
        return route;
    }

    protected ConnectionRoute calculateRoute(ConnectionRoute route, Point start, Point middle, Point end) {
        if (middle != null) {
            this.calculateRoute(route, start, middle);
            this.calculateRoute(route, middle, end);
        } else {
            this.calculateRoute(route, start, end);
        }
        route.add(end);
        return route;
    }

    protected ConnectionRoute calculateRoute(ConnectionRoute route, Point start, Point end) {
        ContainerShape shape;
        route.add(start);
        Point p1 = start;
        Point p2 = end;
        while ((shape = this.getCollision(p1, p2)) != null && shape != this.target && shape != this.source) {
            DetourPoints detour = new DetourPoints(shape, 10);
            for (Point d : detour.calculateDetour(p1, p2)) {
                if (route.add(d)) continue;
                return route;
            }
            p1 = route.get(route.size() - 1);
        }
        return route;
    }

    protected void optimize(ConnectionRoute route) {
        route.addSpecial(this.movedBendpoint);
        route.optimize();
    }
}

