/*
 * Decompiled with CFR 0.152.
 */
package org.fusesource.ide.server.servicemix.core.bean;

import java.io.File;
import org.jboss.ide.eclipse.as.core.server.bean.AbstractCondition;
import org.jboss.ide.eclipse.as.core.server.bean.ICondition;
import org.jboss.ide.eclipse.as.core.server.bean.ServerBeanType;

public class ServerBeanTypeServiceMix5x
extends ServerBeanType {
    protected static final String SMX5x_RELEASE_VERSION = "Bundle-Version";
    public static final String V5_0 = "5.0";
    public static final String V5_1 = "5.1";
    public static final String V5_2 = "5.2";
    public static final String V5_3 = "5.3";
    public static final String V5_4 = "5.4";
    public static final String V5_x = "5.";

    protected ServerBeanTypeServiceMix5x() {
        super("SMX5x", "Apache ServiceMix 5.x", "lib" + File.separator + "servicemix-version.jar", (ICondition)new ServiceMix5xServerTypeCondition());
    }

    public static class ServiceMix5xServerTypeCondition
    extends AbstractCondition {
        public boolean isServerRoot(File location) {
            return ServiceMix5xServerTypeCondition.checkServiceMixVersion(location, ServerBeanTypeServiceMix5x.SMX5x_RELEASE_VERSION, ServerBeanTypeServiceMix5x.V5_x);
        }

        protected static boolean checkServiceMixVersion(File location, String property, String propPrefix) {
            String mainFolder = new ServerBeanTypeServiceMix5x().getSystemJarPath();
            String value = ServerBeanTypeServiceMix5x.getJarProperty((File)new File(location + File.separator + mainFolder), (String)property);
            return value != null && value.startsWith(propPrefix);
        }

        public String getServerTypeId(String version) {
            if (version.equals(ServerBeanTypeServiceMix5x.V5_0)) {
                return "org.fusesource.ide.servicemix.server.50";
            }
            if (version.equals(ServerBeanTypeServiceMix5x.V5_1)) {
                return "org.fusesource.ide.servicemix.server.51";
            }
            if (version.equals(ServerBeanTypeServiceMix5x.V5_2)) {
                return "org.fusesource.ide.servicemix.server.52";
            }
            if (version.equals(ServerBeanTypeServiceMix5x.V5_3)) {
                return "org.fusesource.ide.servicemix.server.53";
            }
            if (version.equals(ServerBeanTypeServiceMix5x.V5_4)) {
                return "org.fusesource.ide.servicemix.server.54";
            }
            if (version.startsWith(ServerBeanTypeServiceMix5x.V5_x)) {
                return "org.fusesource.ide.servicemix.server.54";
            }
            return null;
        }
    }
}

