/*
 * Decompiled with CFR 0.152.
 */
package org.fusesource.ide.fabric8.ui.navigator.properties;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.text.NumberFormat;
import java.util.Collection;
import java.util.Set;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.ui.views.properties.IPropertySheetPage;
import org.fusesource.ide.commons.Viewers;
import org.fusesource.ide.commons.tree.Refreshables;
import org.fusesource.ide.commons.ui.Selections;
import org.fusesource.ide.commons.ui.actions.SeparatorFactory;
import org.fusesource.ide.commons.ui.label.Health;
import org.fusesource.ide.commons.ui.label.HealthLabelProvider;
import org.fusesource.ide.commons.ui.label.PercentFunctionLabelProvider;
import org.fusesource.ide.commons.ui.views.TableViewSupport;
import org.fusesource.ide.commons.util.Function1;
import org.fusesource.ide.commons.util.FunctionInteger;
import org.fusesource.ide.fabric8.core.dto.ProfileStatusDTO;
import org.fusesource.ide.fabric8.core.dto.VersionDTO;
import org.fusesource.ide.fabric8.ui.FabricPlugin;
import org.fusesource.ide.fabric8.ui.actions.CreateChildContainerAction;
import org.fusesource.ide.fabric8.ui.actions.CreateSshContainerAction;
import org.fusesource.ide.fabric8.ui.actions.jclouds.CreateJCloudsContainerAction;
import org.fusesource.ide.fabric8.ui.navigator.Fabric;
import org.fusesource.ide.fabric8.ui.navigator.FabricNavigator;
import org.fusesource.ide.fabric8.ui.navigator.ProfileNode;
import org.fusesource.ide.fabric8.ui.navigator.VersionNode;
import org.jboss.tools.jmx.core.tree.Node;

public class FabricStatusTableSheetPage
extends TableViewSupport
implements IPropertySheetPage {
    public static final String VIEW_ID = FabricStatusTableSheetPage.class.getName();
    protected static SeparatorFactory separatorFactory = new SeparatorFactory(VIEW_ID);
    private boolean showPercentOnStatusColumn;
    private final Fabric fabric;
    private CreateChildContainerAction createChildContainerAction;
    private CreateJCloudsContainerAction createCloudContainerAction;
    private CreateSshContainerAction createSshContainerAction;
    private MenuManager setVersionMenu;
    private Separator separator1 = separatorFactory.createSeparator();
    private Separator separator2 = separatorFactory.createSeparator();
    private Separator separator3 = separatorFactory.createSeparator();
    private Separator separator4 = separatorFactory.createSeparator();
    private Runnable refreshRunnable = new Runnable(){

        @Override
        public void run() {
            FabricStatusTableSheetPage.this.refresh();
        }
    };

    public static ProfileStatusDTO asProfileStatus(Object element) {
        if (element instanceof ProfileStatusDTO) {
            return (ProfileStatusDTO)element;
        }
        return null;
    }

    public FabricStatusTableSheetPage(Fabric fabric) {
        this.fabric = fabric;
        this.updateActionStatus();
    }

    public void dispose() {
        super.dispose();
        this.fabric.removeFabricUpdateRunnable(this.refreshRunnable);
    }

    protected void configureViewer() {
        this.addLocalMenuActions(new Object[]{this.separator1, this.getCreateChildContainerAction(), this.getCreateCloudContainerAction(), this.getCreateSshContainerAction(), this.separator2});
        this.getViewer().addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                ProfileStatusDTO s;
                String profileId;
                ProfileNode profileNode;
                Object oSel;
                FabricNavigator nav = FabricPlugin.getFabricNavigator();
                if (nav != null && (oSel = Selections.getFirstSelection((ISelection)event.getSelection())) != null && oSel instanceof ProfileStatusDTO && (profileNode = FabricStatusTableSheetPage.this.searchProfile(nav, profileId = (s = FabricStatusTableSheetPage.asProfileStatus(oSel)).getProfile(), (Node)FabricStatusTableSheetPage.this.getFabric().getVersionsNode())) != null) {
                    nav.selectReveal((ISelection)new StructuredSelection((Object)profileNode));
                }
            }
        });
        this.getViewer().addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                FabricStatusTableSheetPage.this.updateActionStatus();
            }
        });
        this.fabric.addFabricUpdateRunnable(this.refreshRunnable);
        this.updateData();
    }

    private ProfileNode searchProfile(FabricNavigator nav, String profileId, Node node) {
        ProfileNode result = null;
        if (node instanceof ProfileNode && ((ProfileNode)node).getId().equals(profileId)) {
            result = (ProfileNode)node;
        } else {
            Node[] nodes = node.getChildren();
            if (nodes != null) {
                Node[] nodeArray = node.getChildren();
                int n = nodeArray.length;
                int n2 = 0;
                while (n2 < n) {
                    Node n3 = nodeArray[n2];
                    result = this.searchProfile(nav, profileId, n3);
                    if (result != null) break;
                    ++n2;
                }
            }
        }
        return result;
    }

    public void refresh() {
        Viewers.async((Runnable)new Runnable(){

            @Override
            public void run() {
                FabricStatusTableSheetPage.this.updateData();
                Refreshables.refresh((Object)FabricStatusTableSheetPage.this.getViewer());
                FabricStatusTableSheetPage.this.updateActionStatus();
            }
        });
    }

    protected void updateData() {
        this.setInput(this.getProfileStatuses());
    }

    protected Collection<ProfileStatusDTO> getProfileStatuses() {
        return this.fabric.getProfileStatuses();
    }

    protected void createColumns() {
        this.clearColumns();
        int bounds = 100;
        int column = 0;
        Object function = new Function1(){

            public Object apply(Object element) {
                ProfileStatusDTO status = FabricStatusTableSheetPage.asProfileStatus(element);
                if (status != null) {
                    return status.getProfile();
                }
                return null;
            }
        };
        column = this.addColumnFunction(250, column, (Function1)function, "Profile");
        function = new FunctionInteger(){

            public BigInteger apply(Object element) {
                ProfileStatusDTO status = FabricStatusTableSheetPage.asProfileStatus(element);
                if (status != null) {
                    return status.getCount();
                }
                return null;
            }
        };
        column = this.addColumnFunction(bounds, column, (Function1)function, "Count");
        function = new FunctionInteger(){

            public BigInteger apply(Object element) {
                ProfileStatusDTO status = FabricStatusTableSheetPage.asProfileStatus(element);
                if (status != null) {
                    return status.getMinimumInstances();
                }
                return null;
            }
        };
        column = this.addColumnFunction(bounds, column, (Function1)function, "Minumum");
        function = new FunctionInteger(){

            public BigInteger apply(Object element) {
                ProfileStatusDTO status = FabricStatusTableSheetPage.asProfileStatus(element);
                if (status != null) {
                    return status.getMaximumInstances();
                }
                return null;
            }
        };
        column = this.addColumnFunction(bounds, column, (Function1)function, "Maximum");
        function = new Function1(){

            public Object apply(Object element) {
                ProfileStatusDTO status = FabricStatusTableSheetPage.asProfileStatus(element);
                if (status != null) {
                    return FabricStatusTableSheetPage.this.toHealth(status);
                }
                return null;
            }
        };
        column = this.addColumnFunction(bounds, column, (Function1)function, "Status", (CellLabelProvider)new HealthLabelProvider(function));
        function = new Function1(){

            public BigDecimal apply(Object element) {
                ProfileStatusDTO status = FabricStatusTableSheetPage.asProfileStatus(element);
                if (status != null) {
                    return status.getHealth(status.getCount());
                }
                return null;
            }
        };
        column = this.addColumnFunction(bounds, column, (Function1)function, "Health", (CellLabelProvider)new PercentFunctionLabelProvider(function));
        function = new Function1(){

            public Object apply(Object element) {
                ProfileStatusDTO status = FabricStatusTableSheetPage.asProfileStatus(element);
                if (status != null) {
                    return status.getDependentProfiles();
                }
                return null;
            }
        };
        column = this.addColumnFunction(250, column, (Function1)function, "Dependencies");
    }

    protected Health toHealth(ProfileStatusDTO status) {
        BigInteger count = status.getCount();
        String text = null;
        if (this.showPercentOnStatusColumn) {
            text = NumberFormat.getPercentInstance().format(status.getHealth(count));
        }
        return Health.newInstance((String)text, (Number)count, (Number)status.getMinimumInstances(), (Number)status.getMaximumInstances());
    }

    protected IStructuredContentProvider createContentProvider() {
        return ArrayContentProvider.getInstance();
    }

    protected String getHelpID() {
        return VIEW_ID;
    }

    public String getColumnConfigurationId() {
        return VIEW_ID;
    }

    public Fabric getFabric() {
        return this.fabric;
    }

    protected IStructuredSelection getSelection() {
        return Selections.getStructuredSelection((Viewer)this.getViewer());
    }

    protected ProfileNode getSelectedProfileNode() {
        Object first = Selections.getFirstSelection((Viewer)this.getViewer());
        if (first instanceof ProfileStatusDTO) {
            ProfileStatusDTO status = (ProfileStatusDTO)first;
            String id = status.getProfile();
            VersionNode version = this.getFabric().getDefaultVersionNode();
            if (version != null) {
                return version.getProfileNode(id);
            }
        }
        return null;
    }

    protected boolean hasVersionApartFrom(Set<String> names, VersionDTO version) {
        int minSize;
        int n = minSize = names.contains(version.getId()) ? 2 : 1;
        return names.size() >= minSize;
    }

    protected CreateChildContainerAction getCreateChildContainerAction() {
        if (this.createChildContainerAction == null) {
            this.createChildContainerAction = this.createChildContainerAction(this.fabric);
            this.createChildContainerAction.updateEnabled();
        }
        return this.createChildContainerAction;
    }

    protected void setCreateChildContainerAction(CreateChildContainerAction createChildContainerAction) {
        this.createChildContainerAction = createChildContainerAction;
    }

    protected CreateJCloudsContainerAction getCreateCloudContainerAction() {
        if (this.createCloudContainerAction == null) {
            this.createCloudContainerAction = this.createCloudContainerAction(this.fabric);
        }
        return this.createCloudContainerAction;
    }

    protected void setCreateCloudContainerAction(CreateJCloudsContainerAction createCloudContainerAction) {
        this.createCloudContainerAction = createCloudContainerAction;
    }

    protected CreateSshContainerAction getCreateSshContainerAction() {
        if (this.createSshContainerAction == null) {
            this.createSshContainerAction = this.createSshContainerAction(this.fabric);
        }
        return this.createSshContainerAction;
    }

    protected void setCreateSshContainerAction(CreateSshContainerAction createSshContainerAction) {
        this.createSshContainerAction = createSshContainerAction;
    }

    protected CreateJCloudsContainerAction createCloudContainerAction(Fabric fabric) {
        return new CreateJCloudsContainerAction(fabric);
    }

    protected CreateSshContainerAction createSshContainerAction(Fabric fabric) {
        return new CreateSshContainerAction(fabric);
    }

    protected CreateChildContainerAction createChildContainerAction(Fabric fabric) {
        return new CreateChildContainerAction(fabric);
    }

    protected void updateActionStatus() {
        ProfileNode profileNode = this.getSelectedProfileNode();
        this.getCreateChildContainerAction().setProfileNode(profileNode);
        this.getCreateSshContainerAction().setProfileNode(profileNode);
        this.getCreateCloudContainerAction().setProfileNode(profileNode);
    }
}

