/*
 * Decompiled with CFR 0.152.
 */
package org.fusesource.ide.fabric8.ui.navigator.properties;

import com.google.common.base.Joiner;
import java.util.List;
import org.fusesource.ide.commons.ui.propsrc.BeanPropertySource;
import org.fusesource.ide.fabric8.core.dto.ContainerDTO;
import org.fusesource.ide.fabric8.core.dto.ProfileDTO;
import org.fusesource.ide.fabric8.core.dto.VersionDTO;
import org.fusesource.ide.fabric8.ui.navigator.Fabrics;

public class ContainerViewBean {
    public static final Joiner spaceJoiner = Joiner.on((String)" ");
    private final ContainerDTO container;

    public static ContainerViewBean toContainerViewBean(Object element) {
        if (element instanceof BeanPropertySource) {
            BeanPropertySource source = (BeanPropertySource)element;
            return ContainerViewBean.toContainerViewBean(source.getBean());
        }
        if (element instanceof ContainerViewBean) {
            return (ContainerViewBean)element;
        }
        if (element instanceof ContainerDTO) {
            return new ContainerViewBean((ContainerDTO)element);
        }
        return null;
    }

    public ContainerViewBean(ContainerDTO container) {
        this.container = container;
    }

    public List<ContainerDTO> getChildren() {
        return this.container.getChildren();
    }

    public String getId() {
        return this.container.getId();
    }

    public String getVersion() {
        return Fabrics.getVersionName(this.version());
    }

    public VersionDTO version() {
        return this.container.getVersion();
    }

    public List<String> getJmxDomains() {
        return this.container.getJmxDomains();
    }

    public String getJmxUrl() {
        return this.container.getJMXUrl();
    }

    public String getLocation() {
        return this.container.getLocation();
    }

    public ContainerDTO getParent() {
        return this.container.getParent();
    }

    public String getProfileIds() {
        List ids = this.container.getProfileIDs();
        if (ids == null || ids.size() == 0) {
            return null;
        }
        return spaceJoiner.join((Iterable)ids);
    }

    public List<ProfileDTO> getProfiles() {
        return this.container.getProfiles();
    }

    public String getSshUrl() {
        return this.container.getSshUrl();
    }

    public String getType() {
        return this.container.getType();
    }

    public boolean isAlive() {
        return this.container.isAlive();
    }

    public String getStatus() {
        String status = this.container.getProvisionStatus();
        if ((this.isRoot() || !this.isAlive()) && status != null && status.startsWith("not provisioned")) {
            return "";
        }
        return status;
    }

    public boolean isProvisioningComplete() {
        return this.container.isProvisioningComplete();
    }

    public boolean isRoot() {
        return this.container.isRoot();
    }

    public void setLocation(String newLocation) {
        this.container.setLocation(newLocation);
    }

    public void setProfiles(List<ProfileDTO> arg0) {
        this.container.setProfileDTOs(arg0);
    }

    public void setVersion(VersionDTO arg0) {
        this.container.setVersion(arg0);
    }

    public void start() {
        this.container.start();
    }

    public void stop() {
        this.container.stop();
    }

    public ContainerDTO container() {
        return this.container;
    }
}

