/*
 * Decompiled with CFR 0.152.
 */
package org.fusesource.ide.fabric8.ui.navigator.properties;

import org.eclipse.jface.viewers.StyledCellLabelProvider;
import org.eclipse.jface.viewers.StyledString;
import org.eclipse.jface.viewers.ViewerCell;
import org.fusesource.ide.fabric8.core.dto.ContainerDTO;
import org.fusesource.ide.fabric8.ui.FabricPlugin;
import org.fusesource.ide.fabric8.ui.navigator.properties.ContainerViewBean;

public class ContainerStatusLabelProvider
extends StyledCellLabelProvider {
    public void update(ViewerCell cell) {
        Object element = cell.getElement();
        ContainerViewBean bean = ContainerViewBean.toContainerViewBean(element);
        if (bean != null) {
            ContainerDTO container = bean.container();
            boolean managed = container.isManaged();
            String image = "yellow-dot.png";
            String status = bean.getStatus();
            FabricPlugin.getLogger().debug("Container: " + container.getId() + " alive: " + container.isAlive() + " managed: " + container.isManaged() + " pending: " + container.isProvisioningPending() + " complete: " + container.isProvisioningComplete() + " status: " + container.getProvisionStatus());
            if (!bean.isAlive()) {
                image = "gray-dot.png";
            }
            if (container.isProvisioningPending().booleanValue()) {
                image = "yellow-dot.png";
                managed = true;
            } else if (status != null) {
                String lowerStatus = status.toLowerCase();
                if (lowerStatus.startsWith("success") || lowerStatus.length() == 0) {
                    if (bean.isAlive()) {
                        image = "green-dot.png";
                    } else {
                        status = "stopped";
                    }
                    if (lowerStatus.length() == 0 && !managed && bean.isRoot()) {
                        status = "root";
                    }
                } else if (lowerStatus.startsWith("error")) {
                    image = "red-dot.png";
                }
            }
            if (status != null) {
                StyledString.Styler style = null;
                StyledString styledString = new StyledString(status, style);
                cell.setText(styledString.toString());
                cell.setStyleRanges(styledString.getStyleRanges());
            }
            if (image != null) {
                cell.setImage(FabricPlugin.getDefault().getImage(image));
            }
        }
        super.update(cell);
    }
}

