/*
 * Decompiled with CFR 0.152.
 */
package org.fusesource.ide.fabric8.ui.navigator;

import com.google.common.base.Joiner;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.progress.UIJob;
import org.eclipse.ui.views.properties.IPropertySheetPage;
import org.fusesource.ide.commons.Activator;
import org.fusesource.ide.commons.Viewers;
import org.fusesource.ide.commons.tree.GraphableNode;
import org.fusesource.ide.commons.tree.GraphableNodeConnected;
import org.fusesource.ide.commons.tree.HasOwner;
import org.fusesource.ide.commons.tree.HasRefreshableUI;
import org.fusesource.ide.commons.tree.RefreshableNode;
import org.fusesource.ide.commons.tree.RefreshableUI;
import org.fusesource.ide.commons.ui.ContextMenuProvider;
import org.fusesource.ide.commons.ui.actions.ActionSupport;
import org.fusesource.ide.commons.ui.views.ViewPropertySheetPage;
import org.fusesource.ide.commons.util.Objects;
import org.fusesource.ide.fabric8.core.connector.Fabric8Facade;
import org.fusesource.ide.fabric8.core.dto.ContainerDTO;
import org.fusesource.ide.fabric8.core.dto.CreateContainerOptionsDTO;
import org.fusesource.ide.fabric8.core.dto.ProfileDTO;
import org.fusesource.ide.fabric8.core.dto.VersionDTO;
import org.fusesource.ide.fabric8.ui.FabricPlugin;
import org.fusesource.ide.fabric8.ui.actions.CreateChildContainerAction;
import org.fusesource.ide.fabric8.ui.actions.CreateSshContainerAction;
import org.fusesource.ide.fabric8.ui.actions.Messages;
import org.fusesource.ide.fabric8.ui.actions.jclouds.CreateJCloudsContainerAction;
import org.fusesource.ide.fabric8.ui.navigator.ContainersNode;
import org.fusesource.ide.fabric8.ui.navigator.Fabric;
import org.fusesource.ide.fabric8.ui.navigator.FabricNodeSupport;
import org.fusesource.ide.fabric8.ui.navigator.Fabrics;
import org.fusesource.ide.fabric8.ui.navigator.IdBasedFabricNode;
import org.fusesource.ide.fabric8.ui.navigator.ProfileNode;
import org.fusesource.ide.fabric8.ui.navigator.VersionNode;
import org.fusesource.ide.fabric8.ui.navigator.properties.ContainerTabViewPage;
import org.fusesource.ide.fabric8.ui.navigator.properties.ContainerTableSheetPage;
import org.fusesource.ide.fabric8.ui.navigator.properties.ContainerViewBean;
import org.fusesource.ide.fabric8.ui.view.logs.FabricLogBrowser;
import org.fusesource.ide.fabric8.ui.view.logs.HasLogBrowser;
import org.fusesource.ide.fabric8.ui.view.logs.ILogBrowser;
import org.fusesource.ide.server.view.ITerminalConnectionListener;
import org.fusesource.ide.server.view.SshView;
import org.jboss.tools.jmx.core.tree.Node;
import org.jboss.tools.jmx.ui.ImageProvider;

public class ContainerNode
extends IdBasedFabricNode
implements HasRefreshableUI,
ImageProvider,
GraphableNode,
GraphableNodeConnected,
ContextMenuProvider,
ITerminalConnectionListener,
HasLogBrowser {
    private final ContainerDTO container;
    private ILogBrowser logBrowser;

    public static ContainerNode toContainerNode(Object object) {
        if (object instanceof ContainerNode) {
            return (ContainerNode)object;
        }
        if (object instanceof HasOwner) {
            HasOwner ho = (HasOwner)object;
            return ContainerNode.toContainerNode(ho.getOwner());
        }
        return null;
    }

    public static ContainerDTO toContainer(Object object) {
        if (object instanceof ContainerDTO) {
            return (ContainerDTO)object;
        }
        ContainerNode node = ContainerNode.toContainerNode(object);
        if (node != null) {
            return node.getContainer();
        }
        return null;
    }

    public ContainerNode(RefreshableNode parent, ContainerDTO agent, Fabric fabric) {
        super((Node)parent, fabric, agent.getId());
        this.container = agent;
        this.setPropertyBean(new ContainerViewBean(agent));
        Joiner joiner = Joiner.on((String)"\n    ");
        List profileIds = agent.getProfileIDs();
        for (String profileId : profileIds) {
            ProfileDTO overlay = this.getFabricService().getProfile(this.container.getVersionId(), profileId);
            FabricPlugin.getLogger().debug("Profile: " + overlay);
            FabricPlugin.getLogger().debug("  bundles: " + joiner.join((Iterable)overlay.getBundles()));
            FabricPlugin.getLogger().debug("  features: " + joiner.join((Iterable)overlay.getFeatures()));
            FabricPlugin.getLogger().debug("  repos:   " + joiner.join((Iterable)overlay.getRepositories()));
        }
    }

    public ContainerNode(RefreshableNode parent, ContainerNode agentNode) {
        this(parent, agentNode.getContainer(), agentNode.getFabric());
    }

    public ContainerNode(FabricNodeSupport agents, ContainerDTO agent) {
        this((RefreshableNode)agents, agent, agents.getFabric());
    }

    public VersionNode getVersionNode() {
        return this.getFabric().getVersionNode(this.container.getVersionId());
    }

    public Object getAdapter(Class adapter) {
        if (adapter == IPropertySheetPage.class) {
            this.checkLoaded();
            VersionNode versionNode = this.getVersionNode();
            if (versionNode != null) {
                versionNode.getChildren();
                return new ContainerTabViewPage(this);
            }
        }
        return super.getAdapter(adapter);
    }

    @Override
    public List<Node> getChildrenGraph() {
        HashSet<Node> answer = new HashSet<Node>();
        answer.add((Node)this);
        List profileIds = this.getContainer().getProfileIDs();
        ArrayList<ProfileDTO> profiles = new ArrayList<ProfileDTO>();
        for (String id : profileIds) {
            ProfileDTO p = this.getFabricService().getProfile(this.getVersionNode().getVersionId(), id);
            if (p == null) continue;
            profiles.add(p);
        }
        Collection<ProfileNode> profileNodes = this.getFabric().getProfileNodes(profiles);
        for (ProfileNode profileNode : profileNodes) {
            profileNode.addAndDescendants(answer);
        }
        return new ArrayList<Node>(answer);
    }

    public Collection<Node> getGraphConnectedTo() {
        ContainersNode containersNode = this.getFabric().getContainersNode();
        if (this.getContainer().isRoot().booleanValue() && containersNode != null) {
            ArrayList<Node> answer = new ArrayList<Node>();
            List list = this.getContainer().getChildrenIds();
            for (String containerId : list) {
                ContainerNode containerNode = containersNode.getContainerNode(containerId);
                if (containerNode == null) continue;
                answer.add((Node)containerNode);
            }
            return answer;
        }
        return Collections.emptyList();
    }

    public RefreshableUI getRefreshableUI() {
        return super.getRefreshableUI();
    }

    public Image getImage() {
        return FabricPlugin.getDefault().getImage("container.png");
    }

    public String getSshUrl() {
        return this.getContainer().getSshUrl();
    }

    protected void checkLoaded() {
        if (this.hasJmxConnector()) {
            super.checkLoaded();
        }
    }

    protected void loadChildren() {
    }

    protected boolean hasJmxConnector() {
        boolean provisioned;
        ContainerDTO a = this.getContainer();
        String jmxUrl = a.getJMXUrl();
        boolean bl = provisioned = a.isAlive() != false && a.isProvisioningComplete() != false;
        return jmxUrl != null && jmxUrl.trim().length() > 0 && (provisioned || a.isRoot() != false);
    }

    public ContainerDTO getContainer() {
        return this.container;
    }

    public boolean supportsJmxDomain(String domain) {
        return this.container.getJmxDomains().contains(domain);
    }

    public boolean matches(ProfileDTO profile) {
        ContainerDTO ag = this.getContainer();
        List profileIds = ag.getProfileIDs();
        for (String pId : profileIds) {
            if (!Objects.equal((Object)pId, (Object)profile.getId()) || !Objects.equal((Object)ag.getVersionId(), (Object)profile.getVersionId())) continue;
            return true;
        }
        return false;
    }

    public boolean matches(VersionDTO version) {
        return Objects.equal((Object)this.getContainer().getVersionId(), (Object)Fabrics.getVersionName(version));
    }

    @Override
    public void provideContextMenu(IMenuManager menu) {
        Action startStopAction;
        ActionSupport openTerminalAction = new ActionSupport(Messages.openTerminalLabel, Messages.openTerminalToolTip, FabricPlugin.getDefault().getImageDescriptor("terminal_view.gif")){

            public void run() {
                ContainerNode.this.openTerminal();
            }
        };
        menu.add((IAction)openTerminalAction);
        final ImageDescriptor versionImage = FabricPlugin.getDefault().getImageDescriptor("version.png");
        final MenuManager subMenu = new MenuManager("Set Version", versionImage, "org.fusesource.ide.actions.update");
        menu.add((IContributionItem)subMenu);
        subMenu.setRemoveAllWhenShown(true);
        subMenu.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager manager) {
                UIJob loadJob = new UIJob("Loading data..."){

                    public IStatus runInUIThread(IProgressMonitor monitor) {
                        List versions = ContainerNode.this.getFabric().getVersionsNode().getChildrenList();
                        for (Node node : versions) {
                            if (node == null || !(node instanceof VersionNode)) continue;
                            final VersionNode version = (VersionNode)node;
                            Action action = new Action(version.getVersionId(), versionImage){

                                public void run() {
                                    ContainerNode.this.getContainer().setVersion(version.getVersion());
                                    ContainerNode.this.getFabric().getVersionsNode().refresh();
                                }
                            };
                            if (ContainerNode.this.matches(version.getVersion())) {
                                action.setEnabled(false);
                            }
                            subMenu.add((IAction)action);
                        }
                        subMenu.update(true);
                        return Status.OK_STATUS;
                    }
                };
                loadJob.schedule();
                subMenu.setVisible(true);
            }
        });
        if (this.getContainer().isAlive().booleanValue()) {
            startStopAction = new Action(Messages.StopAgentAction, 32){

                public void run() {
                    ContainerNode.this.stop();
                }
            };
            startStopAction.setToolTipText(Messages.StopAgentActionToolTip);
            startStopAction.setImageDescriptor(FabricPlugin.getDefault().getImageDescriptor("stop_task.gif"));
        } else {
            startStopAction = new Action(Messages.StartAgentAction, 32){

                public void run() {
                    ContainerNode.this.start();
                }
            };
            startStopAction.setToolTipText(Messages.StartAgentActionToolTip);
            startStopAction.setImageDescriptor(FabricPlugin.getDefault().getImageDescriptor("start_task.gif"));
        }
        if (!this.getContainer().isRoot().booleanValue()) {
            menu.add((IAction)startStopAction);
        }
        menu.add((IContributionItem)new Separator());
        if (this.getContainer().isRoot().booleanValue()) {
            menu.add((IAction)new CreateChildContainerAction(this));
        }
        menu.add((IAction)new CreateJCloudsContainerAction(this.getVersionNode(), this, null));
        menu.add((IAction)new CreateSshContainerAction(this.getVersionNode(), this, null));
    }

    protected void openTerminal() {
        ContainerNode.openTerminal(this.getFabric(), this.getContainer(), this);
    }

    public static void openTerminal(Fabric theFabric, ContainerDTO theContainer, ITerminalConnectionListener listener) {
        String url = theContainer.getSshUrl();
        String user = theFabric.getUserName();
        String password = theFabric.getPassword();
        if (url == null) {
            return;
        }
        if (!url.contains("://")) {
            url = "http://" + url;
        }
        URL sshUrl = null;
        try {
            sshUrl = new URL(url);
        }
        catch (Exception e) {
            Activator.getLogger().warning("Failed to parse URI: '" + url + "'. " + e, (Throwable)e);
            return;
        }
        String host = sshUrl.getHost();
        int port = sshUrl.getPort();
        IViewPart vp = FabricPlugin.openTerminalView();
        if (vp == null || !(vp instanceof SshView)) {
            FabricPlugin.getLogger().error("Unable to open the terminal view!");
            return;
        }
        SshView connectorView = (SshView)vp;
        connectorView.setPartName(theContainer.getId());
        if (listener != null) {
            connectorView.addConnectionListener(listener);
        }
        try {
            FabricPlugin.getLogger().debug("Creating the connection if it doesn't exist for host: " + host + " port " + port + " user " + user + " pwd " + password);
            connectorView.createConnectionIfNotExists(host, port, user, password);
        }
        catch (Exception ex) {
            FabricPlugin.getLogger().error("Unable to connect via SSH", (Throwable)ex);
        }
    }

    public void onConnect() {
        FabricPlugin.openTerminalView().setFocus();
    }

    public void onDisconnect() {
        IViewPart vp = FabricPlugin.openTerminalView();
        if (vp == null || !(vp instanceof SshView)) {
            FabricPlugin.getLogger().error("Unable to open the terminal view!");
            return;
        }
        SshView connectorView = (SshView)vp;
        connectorView.setPartName(Messages.shellViewLabel);
        connectorView.removeConnectionListener((ITerminalConnectionListener)this);
    }

    public void createContainer(String name, List<ProfileDTO> profiles, VersionNode version) {
        try {
            ArrayList<String> profilesList = new ArrayList<String>();
            for (ProfileDTO p : profiles) {
                profilesList.add(p.getId());
            }
            FabricPlugin.getLogger().debug("About to create child container of " + this + " with name: " + name + " and profiles: " + Arrays.asList(profiles));
            Fabric8Facade fabricService = this.getFabricService();
            CreateContainerOptionsDTO options = CreateContainerOptionsDTO.builder().name(name).parent(this.getId()).version(version.getVersionId()).profiles(Collections.unmodifiableSet(new HashSet(profilesList))).zookeeperUrl(fabricService.getZookeeperUrl()).zookeeperPassword(this.getFabric().getDetails().getZkPassword()).jmxUser(this.getFabric().getDetails().getUserName()).jmxPassword(this.getFabric().getDetails().getPassword()).proxyUri(fabricService.getMavenRepoURI()).build();
            fabricService.createContainers(options);
            this.getFabric().refreshCreatedAgent(name);
            Display.getDefault().syncExec(new Runnable(){

                @Override
                public void run() {
                    ContainerNode.this.getFabric().getContainersNode().refresh();
                    ViewPropertySheetPage p = ContainerNode.this.getFabric().getContainersNode().getPropertySourceTablePage();
                    if (p instanceof ContainerTableSheetPage) {
                        ((ContainerTableSheetPage)p).updateData();
                        Viewers.refresh((Viewer)((ContainerTableSheetPage)p).getTableView().getViewer());
                    }
                    ContainerNode.this.refresh();
                }
            });
        }
        catch (Exception e) {
            FabricPlugin.showUserError("Failed to create new child container of " + this, e.getMessage(), e);
        }
    }

    public void start() {
        try {
            this.getFabricService().startContainer(this.getContainer());
            this.getFabric().refresh();
        }
        catch (Exception e) {
            FabricPlugin.showUserError("Failed to start container " + this, e.getMessage(), e);
        }
    }

    public void stop() {
        try {
            this.getFabricService().stopContainer(this.getContainer());
            this.getFabric().refresh();
        }
        catch (Exception e) {
            FabricPlugin.showUserError("Failed to stop container " + this, e.getMessage(), e);
        }
    }

    public void destroy() {
        try {
            this.getFabricService().destroyContainer(this.getContainer());
            this.getFabric().refresh();
        }
        catch (Exception e) {
            FabricPlugin.showUserError("Failed to destroy container " + this, e.getMessage(), e);
        }
    }

    public RefreshableNode getParent() {
        return (RefreshableNode)super.getParent();
    }

    public Fabric8Facade getFabricService() {
        return this.getFabric().getFabricService();
    }

    @Override
    public ILogBrowser getLogBrowser() {
        if (this.logBrowser == null) {
            this.logBrowser = new FabricLogBrowser(this);
        }
        return this.logBrowser;
    }
}

