/*
 * Decompiled with CFR 0.152.
 */
package org.fusesource.ide.fabric8.ui.actions.jclouds;

import com.google.common.base.Optional;
import com.google.common.collect.Lists;
import com.google.common.reflect.TypeToken;
import com.google.inject.Module;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Properties;
import java.util.Set;
import org.fusesource.ide.commons.util.Objects;
import org.fusesource.ide.commons.util.Strings;
import org.jclouds.Context;
import org.jclouds.View;
import org.jclouds.apis.ApiMetadata;
import org.jclouds.apis.Apis;
import org.jclouds.compute.ComputeServiceContext;
import org.jclouds.compute.domain.ComputeMetadata;
import org.jclouds.compute.domain.Hardware;
import org.jclouds.compute.domain.NodeMetadata;
import org.jclouds.compute.domain.OperatingSystem;
import org.jclouds.domain.Location;
import org.jclouds.domain.ResourceMetadata;
import org.jclouds.providers.ProviderMetadata;
import org.jclouds.providers.Providers;

public class JClouds {
    public static final ApiMetadata EMPTY_API = new ApiMetadata(){

        public ApiMetadata.Builder toBuilder() {
            return null;
        }

        public Set<TypeToken<? extends View>> getViews() {
            return null;
        }

        public String getVersion() {
            return null;
        }

        public String getName() {
            return " ";
        }

        public String getIdentityName() {
            return " ";
        }

        public String getId() {
            return "EMPTY_API";
        }

        public String getEndpointName() {
            return null;
        }

        public URI getDocumentation() {
            return null;
        }

        public Properties getDefaultProperties() {
            return null;
        }

        public Set<Class<? extends Module>> getDefaultModules() {
            return null;
        }

        public Optional<String> getDefaultIdentity() {
            return null;
        }

        public Optional<String> getDefaultEndpoint() {
            return null;
        }

        public Optional<String> getDefaultCredential() {
            return null;
        }

        public Optional<String> getCredentialName() {
            return null;
        }

        public TypeToken<? extends Context> getContext() {
            return null;
        }

        public Optional<String> getBuildVersion() {
            return null;
        }
    };
    public static final ProviderMetadata EMPTY_PROVIDER = new ProviderMetadata(){

        public ProviderMetadata.Builder toBuilder() {
            return null;
        }

        public String getName() {
            return " ";
        }

        public Set<String> getLinkedServices() {
            return null;
        }

        public Set<String> getIso3166Codes() {
            return null;
        }

        public String getId() {
            return "EMPTY_PROVIDER";
        }

        public Optional<URI> getHomepage() {
            return null;
        }

        public String getEndpoint() {
            return null;
        }

        public Properties getDefaultProperties() {
            return null;
        }

        public Optional<URI> getConsole() {
            return null;
        }

        public ApiMetadata getApiMetadata() {
            return EMPTY_API;
        }
    };

    public static Iterable<ProviderMetadata> getComputeProviders() {
        Iterable retVal = Providers.viewableAs((TypeToken)TypeToken.of(ComputeServiceContext.class));
        ArrayList<ProviderMetadata> providers = new ArrayList<ProviderMetadata>();
        providers.add(EMPTY_PROVIDER);
        Iterator ite = retVal.iterator();
        while (ite.hasNext()) {
            providers.add((ProviderMetadata)ite.next());
        }
        return providers;
    }

    public static Iterable<ApiMetadata> getComputeApis() {
        Iterable retVal = Apis.viewableAs((TypeToken)TypeToken.of(ComputeServiceContext.class));
        ArrayList<ApiMetadata> apis = new ArrayList<ApiMetadata>();
        apis.add(EMPTY_API);
        Iterator ite = retVal.iterator();
        while (ite.hasNext()) {
            apis.add((ApiMetadata)ite.next());
        }
        return apis;
    }

    public static ClassLoader getJCloudsClassLoader() {
        return ProviderMetadata.class.getClassLoader();
    }

    public static String text(ComputeMetadata md) {
        return Strings.getOrElse((Object)md.getName(), (String)md.getId());
    }

    public static String text(ApiMetadata md) {
        return Strings.getOrElse((Object)md.getName(), (String)md.getId());
    }

    public static String text(Hardware md) {
        return Strings.getOrElse((Object)md.getName(), (String)md.getId());
    }

    public static String text(OperatingSystem md) {
        return Strings.getOrElse((Object)md.getDescription(), (String)md.getName());
    }

    public static String text(ResourceMetadata<?> rm) {
        return Strings.getOrElse((Object)rm.getName(), (String)rm.getProviderId());
    }

    public static String text(Location location) {
        return Strings.getOrElse((Object)location.getDescription(), (String)location.getId());
    }

    public static String text(ProviderMetadata provider) {
        return Strings.getOrElse((Object)provider.getName(), (String)provider.getId());
    }

    public static ProviderMetadata getProvider(String providerId) {
        if (providerId != null) {
            ClassLoader oldClassLoader = Thread.currentThread().getContextClassLoader();
            try {
                Thread.currentThread().setContextClassLoader(Providers.class.getClassLoader());
                ProviderMetadata providerMetadata = Providers.withId((String)providerId);
                return providerMetadata;
            }
            catch (NoSuchElementException noSuchElementException) {
                ProviderMetadata providerMetadata = EMPTY_PROVIDER;
                return providerMetadata;
            }
            finally {
                Thread.currentThread().setContextClassLoader(oldClassLoader);
            }
        }
        return null;
    }

    public static ApiMetadata getApi(String apiId) {
        if (apiId != null) {
            ClassLoader oldClassLoader = Thread.currentThread().getContextClassLoader();
            try {
                Thread.currentThread().setContextClassLoader(Apis.class.getClassLoader());
                ApiMetadata apiMetadata = Apis.withId((String)apiId);
                return apiMetadata;
            }
            catch (NoSuchElementException noSuchElementException) {
                ApiMetadata apiMetadata = EMPTY_API;
                return apiMetadata;
            }
            finally {
                Thread.currentThread().setContextClassLoader(oldClassLoader);
            }
        }
        return null;
    }

    public static String getId(ProviderMetadata provider) {
        if (provider != null) {
            return provider.getId();
        }
        return null;
    }

    public static String getId(ApiMetadata api) {
        if (api != null) {
            return api.getId();
        }
        return null;
    }

    public static <T extends ResourceMetadata<?>> List<T> sortedList(Collection<T> coll) {
        ArrayList answer = Lists.newArrayList(coll);
        Collections.sort(answer, new Comparator<T>(){

            @Override
            public int compare(T o1, T o2) {
                return Objects.compare((Object)JClouds.text(o1), (Object)JClouds.text(o2));
            }
        });
        return answer;
    }

    public static <T extends Location> List<T> sortedLocationList(Collection<T> coll) {
        ArrayList answer = Lists.newArrayList(coll);
        Collections.sort(answer, new Comparator<T>(){

            @Override
            public int compare(T o1, T o2) {
                return Objects.compare((Object)JClouds.text(o1), (Object)JClouds.text(o2));
            }
        });
        return answer;
    }

    public static ComputeMetadata asComputeMetadata(Object element) {
        if (element instanceof ComputeMetadata) {
            return (ComputeMetadata)element;
        }
        return null;
    }

    public static NodeMetadata asNodeMetadata(Object element) {
        if (element instanceof NodeMetadata) {
            return (NodeMetadata)element;
        }
        return null;
    }

    public static Location asLocation(Object element) {
        if (element instanceof Location) {
            return (Location)element;
        }
        ComputeMetadata value = JClouds.asComputeMetadata(element);
        if (value != null) {
            return value.getLocation();
        }
        return null;
    }

    public static String id(ComputeMetadata node) {
        if (node != null) {
            return node.getId();
        }
        return null;
    }

    public static NodeMetadata.Status getState(ComputeMetadata n) {
        NodeMetadata node = JClouds.asNodeMetadata(n);
        if (node != null) {
            return (NodeMetadata.Status)node.getStatus();
        }
        return NodeMetadata.Status.ERROR;
    }
}

