/*
 * Decompiled with CFR 0.152.
 */
package org.fusesource.ide.fabric8.ui.actions;

import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.ui.navigator.CommonViewer;
import org.eclipse.ui.progress.UIJob;
import org.fusesource.ide.commons.ui.actions.HasDoubleClickAction;
import org.fusesource.ide.fabric8.ui.actions.FabricConnectAction;
import org.fusesource.ide.fabric8.ui.navigator.Fabric;

public class DoubleClickAction
extends Action
implements ISelectionChangedListener {
    private ISelection selection;
    private CommonViewer viewer;

    public void selectionChanged(SelectionChangedEvent event) {
        this.selection = event.getSelection();
        this.viewer = (CommonViewer)event.getSource();
    }

    public void run() {
        if (this.selection == null) {
            return;
        }
        StructuredSelection structured = (StructuredSelection)this.selection;
        final Object element = structured.getFirstElement();
        this.viewer.expandToLevel(element, 1);
        if (element instanceof HasDoubleClickAction) {
            HasDoubleClickAction hdc = (HasDoubleClickAction)element;
            Action doubleClickAction = hdc.getDoubleClickAction();
            if (doubleClickAction != null) {
                doubleClickAction.run();
            }
        } else if (element instanceof Fabric) {
            final Fabric fabric = (Fabric)element;
            UIJob job = new UIJob("Connect to Fabric: " + fabric.toString()){

                public IStatus runInUIThread(IProgressMonitor monitor) {
                    IStatus answer = super.run(monitor);
                    FabricConnectAction action = new FabricConnectAction(fabric);
                    action.run();
                    DoubleClickAction.this.viewer.expandToLevel(element, 1);
                    return answer;
                }
            };
            job.schedule();
            this.viewer.expandToLevel(element, 1);
        }
    }
}

