/*
 * Decompiled with CFR 0.152.
 */
package org.fusesource.ide.fabric8.ui.actions;

import java.util.ArrayList;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Text;
import org.fusesource.ide.commons.ui.ICanValidate;
import org.fusesource.ide.fabric8.core.dto.ContainerDTO;
import org.fusesource.ide.fabric8.core.dto.CreateContainerOptionsDTO;
import org.fusesource.ide.fabric8.core.dto.ProfileDTO;
import org.fusesource.ide.fabric8.ui.actions.CreateContainerFormSupport;
import org.fusesource.ide.fabric8.ui.actions.CreateSshContainerArgumentsBean;
import org.fusesource.ide.fabric8.ui.actions.Messages;
import org.fusesource.ide.fabric8.ui.navigator.ContainerNode;
import org.fusesource.ide.fabric8.ui.navigator.ProfileNode;
import org.fusesource.ide.fabric8.ui.navigator.VersionNode;

public class CreateSshContainerForm
extends CreateContainerFormSupport {
    private final ContainerNode selectedAgent;
    private final ProfileNode selectedProfile;
    private Text hostField;
    private CreateSshContainerArgumentsBean args = new CreateSshContainerArgumentsBean();

    public CreateSshContainerForm(ICanValidate validator, VersionNode versionNode, ContainerNode selectedAgent, String defaultAgentName, ProfileNode selectedProfile) {
        super(validator, versionNode, defaultAgentName);
        this.selectedAgent = selectedAgent;
        this.selectedProfile = selectedProfile;
        this.addMandatoryPropertyNames(new String[]{"host", "path", "username", "password"});
    }

    @Override
    public void setFocus() {
        this.hostField.setFocus();
    }

    @Override
    public void okPressed() {
        if (this.isValid()) {
            String agentName = this.getNewAgentName();
            ProfileDTO[] profiles = this.getSelectedProfileArray();
            ContainerDTO agent = null;
            if (this.selectedAgent != null) {
                agent = this.selectedAgent.getContainer();
            }
            this.args.setName(agentName);
            this.getFabric().createContainer(agent, profiles, (CreateContainerOptionsDTO)this.args.delegate());
        }
    }

    @Override
    protected void loadPreference() {
        ProfileDTO profile;
        if (this.selectedProfile != null && (profile = this.selectedProfile.getProfile()) != null) {
            ArrayList<ProfileDTO> profs = new ArrayList<ProfileDTO>();
            profs.add(profile);
            this.setCheckedProfiles(profs);
        }
        super.loadPreference();
    }

    @Override
    protected void createTextFields(Composite inner) {
        super.createTextFields(inner);
        this.hostField = this.createBeanPropertyTextField(inner, (Object)this.args, "host", Messages.agentHostLabel, Messages.agentHostLabel);
        this.createBeanPropertyTextField(inner, (Object)this.args, "username", Messages.agentUserLabel, Messages.agentUserLabel);
        this.createBeanPropertyTextField(inner, (Object)this.args, "password", Messages.agentPasswordLabel, Messages.agentPasswordLabel, 0x400800);
        this.createBeanPropertyTextField(inner, (Object)this.args, "path", Messages.agentPathLabel, Messages.agentPathTooltip);
        this.createBeanPropertyTextField(inner, (Object)this.args, "port", Messages.agentPortLabel, Messages.agentPortLabel);
        this.createBeanPropertyTextField(inner, (Object)this.args, "sshRetries", Messages.agentSshRetriesLabel, Messages.agentSshRetriesTooltip);
        this.createBeanPropertyTextField(inner, (Object)this.args, "retryDelay", Messages.agentRetryDelayLabel, Messages.agentRetryDelayTooltip);
    }
}

