/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.modelgenerator.wsdl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.eclipse.xsd.XSDSchema;
import org.jdom.Namespace;
import org.teiid.designer.modelgenerator.wsdl.ModelBuildingException;
import org.teiid.designer.modelgenerator.wsdl.SOAPTableImpl;
import org.teiid.designer.modelgenerator.wsdl.SoapBindingInfo;
import org.teiid.designer.modelgenerator.wsdl.model.Message;
import org.teiid.designer.modelgenerator.wsdl.model.Model;
import org.teiid.designer.modelgenerator.wsdl.model.Operation;
import org.teiid.designer.modelgenerator.wsdl.model.Part;
import org.teiid.designer.modelgenerator.wsdl.schema.extensions.SOAPSchemaProcessor;
import org.teiid.designer.modelgenerator.wsdl.util.NameUtil;
import org.teiid.designer.modelgenerator.xml.modelextension.impl.XMLRequestResponseExtensionManagerImpl;
import org.teiid.designer.schema.tools.model.jdbc.Column;
import org.teiid.designer.schema.tools.model.jdbc.DataType;
import org.teiid.designer.schema.tools.model.jdbc.Table;
import org.teiid.designer.schema.tools.model.jdbc.internal.ColumnImpl;
import org.teiid.designer.schema.tools.model.jdbc.internal.DataTypeImpl;
import org.teiid.designer.schema.tools.model.jdbc.internal.TableImpl;
import org.teiid.designer.schema.tools.model.schema.Relationship;
import org.teiid.designer.schema.tools.model.schema.RootElement;
import org.teiid.designer.schema.tools.model.schema.SchemaModel;
import org.teiid.designer.schema.tools.processing.RelationshipProcessor;
import org.teiid.designer.schema.tools.processing.RelationshipProcessorFactory;
import org.teiid.designer.schema.tools.processing.SchemaProcessingException;

public class TableBuilder {
    public static final String RESPONSE_IN = "ResponseIn";
    public static final String RESPONSE_OUT = "ResponseOut";
    public static final String XML_SCHEMA_URI = "http://www.w3.org/2001/XMLSchema";
    public static final String MMID = "mmid";
    XSDSchema[] m_schemas;
    SchemaModel m_schemaModel;
    private Model m_model;

    public Map getNamespaces() {
        return this.m_model.getNamespaces();
    }

    public Collection createTables(Operation[] opers) throws ModelBuildingException {
        HashMap<String, SOAPTableImpl> tables = new HashMap<String, SOAPTableImpl>(opers.length * 2);
        this.m_model = opers[0].getBinding().getPort().getService().getModel();
        this.m_schemas = this.m_model.getSchemas();
        try {
            SOAPSchemaProcessor processor = new SOAPSchemaProcessor(null);
            processor.representTypes(true);
            processor.setNamespaces(this.m_model.getNamespaces());
            processor.processSchemas(this.m_schemas);
            this.m_schemaModel = processor.getSchemaModel();
            ArrayList messages = this.getMessages(opers);
            for (Message message : messages) {
                Table baseTable = this.createBaseTable(message);
                String soapAction = null;
                if (message.isRequest()) {
                    soapAction = message.getOperation().getSOAPAction();
                }
                SoapBindingInfo info = null;
                if (message.getOperation() != null) {
                    info = message.getOperation().getSoapBindingInfo();
                }
                SOAPTableImpl baseTableWrapper = new SOAPTableImpl(baseTable, message.isRequest(), soapAction, info);
                String tableName = String.valueOf(baseTable.getCatalog()) + "." + baseTable.getName();
                tables.put(tableName, baseTableWrapper);
                Part[] parts = message.getParts();
                int i = 0;
                while (i < parts.length) {
                    String elementNamespace;
                    String elementName;
                    Part part = parts[i];
                    if (part.isElement()) {
                        elementName = part.getElementName();
                        elementNamespace = part.getElementNamespace();
                    } else {
                        elementName = part.getTypeName();
                        elementNamespace = part.getTypeNamespace();
                    }
                    if (elementNamespace.equalsIgnoreCase(XML_SCHEMA_URI)) {
                        Column add = this.createColumn(part);
                        baseTable.addColumn(add);
                    } else {
                        SchemaModel clone = this.m_schemaModel.copy();
                        String topName = null;
                        if (part.isElement()) {
                            RootElement theElement = null;
                            List roots = this.m_schemaModel.getPotentialRootElements();
                            for (RootElement root : roots) {
                                if ((root != null || elementNamespace.trim().length() != 0) && (root == null || !root.getNamespace().equalsIgnoreCase(elementNamespace)) || root == null || !root.getName().equalsIgnoreCase(elementName)) continue;
                                theElement = root;
                                break;
                            }
                            HashSet<RootElement> eSet = new HashSet<RootElement>(1);
                            eSet.add(theElement);
                            clone.setSelectedRootElements(eSet);
                            topName = theElement.getName();
                        } else {
                            clone.setTypeAsRoot(elementName, elementNamespace);
                            topName = elementName;
                        }
                        RelationshipProcessor relProc = message.isRequest() ? RelationshipProcessorFactory.getRequestProcessor() : RelationshipProcessorFactory.getQueryOptimizingProcessor((int)4, (int)Integer.MAX_VALUE, (int)Integer.MAX_VALUE);
                        relProc.calculateRelationshipTypes(clone);
                        List tabList = clone.getTables();
                        SOAPTableImpl top = new SOAPTableImpl(this.getRootTable(tabList, topName));
                        top.setCatalog(baseTable.getCatalog());
                        top.setSchema(baseTable.getSchema());
                        top.setName(NameUtil.normalizeNameForRelationalTable(top.getName()));
                        Column[] columns = top.getColumns();
                        int col = 0;
                        while (col < columns.length) {
                            Column column = columns[col];
                            column.setName(NameUtil.normalizeNameForRelationalTable(column.getName()));
                            ++col;
                        }
                        if (!(message.isRequest() || top.getMaxOccurs() != -1 && top.getMaxOccurs() <= 1)) {
                            this.createKeyInChild(top, baseTable.getName());
                            this.addMMIdColumn(baseTable, "");
                            top.setName(part.getName());
                            StringBuffer combinedXPath = new StringBuffer(baseTable.getOutputXPath());
                            if (!baseTable.getOutputXPath().endsWith("/")) {
                                combinedXPath.append("/");
                            }
                            combinedXPath.append(part.getName());
                            combinedXPath.append("/*");
                            String newXPathPrefix = combinedXPath.toString();
                            top.setOutputXPath(newXPathPrefix);
                            Table[] table = new Table[]{top};
                            this.processChildren(table, message.isRequest(), tables, baseTable, newXPathPrefix);
                        } else {
                            if (!part.isElement()) {
                                String inputXPath = top.getInputXPath();
                                if (inputXPath.indexOf(47) != 0) {
                                    inputXPath = "/" + inputXPath;
                                }
                                top.setInputXPath("/" + part.getName() + inputXPath);
                            }
                            this.mergeTables(baseTable, top, message.isRequest());
                            this.processChildren(top.getChildTables(), message.isRequest(), tables, baseTable, null);
                        }
                    }
                    ++i;
                }
            }
        }
        catch (SchemaProcessingException se) {
            throw new ModelBuildingException(se);
        }
        return tables.values();
    }

    private void createKeyInChild(Table table, String parentName) {
        String childColumnName = String.valueOf(parentName) + "_" + MMID;
        ColumnImpl keyColumn = new ColumnImpl();
        keyColumn.setName(childColumnName);
        keyColumn.setDataType((DataType)new DataTypeImpl("string", XML_SCHEMA_URI));
        keyColumn.setRole(XMLRequestResponseExtensionManagerImpl.DATA_ROLE);
        keyColumn.setOutputXPath("../../@com.metamatrix.xml.xpathpart");
        keyColumn.setIsForeignKey(true);
        table.addColumn((Column)keyColumn);
    }

    private void processChildren(Table[] tabs, boolean isRequest, HashMap tables, Table baseTable, String xPathPrefix) {
        int i = 0;
        while (i < tabs.length) {
            Table table = tabs[i];
            String tableName = String.valueOf(baseTable.getCatalog()) + "." + baseTable.getSchema() + "." + table.getName();
            if (tables.get(tableName = NameUtil.normalizeNameForRelationalTable(tableName)) == null) {
                table.setCatalog(baseTable.getCatalog());
                table.setSchema(baseTable.getSchema());
                table.setName(NameUtil.normalizeNameForRelationalTable(table.getName()));
                this.checkForForeignKeys(baseTable, table, tables);
                TableBuilder.mergeNamespacePrefixes(table, baseTable);
                Column[] columns = table.getColumns();
                int col = 0;
                while (col < columns.length) {
                    Column column = columns[col];
                    column.setName(NameUtil.normalizeNameForRelationalTable(column.getName()));
                    if (isRequest && !column.getName().equals(MMID)) {
                        this.setInputColumnValues(column.getOutputXPath(), column);
                    }
                    ++col;
                }
                if (!isRequest) {
                    this.addResponseInColumn(table);
                }
                tables.put(tableName, new SOAPTableImpl(table, isRequest, null, null));
                this.processChildren(table, tables, isRequest, baseTable, xPathPrefix);
            }
            ++i;
        }
    }

    private void processChildren(Table table, HashMap tables, boolean isRequest, Table baseTable, String xPathPrefix) {
        Table[] tabs = table.getChildTables();
        int i = 0;
        while (i < tabs.length) {
            String tableName = String.valueOf(table.getCatalog()) + "." + table.getSchema() + "." + tabs[i].getName();
            tableName = NameUtil.normalizeNameForRelationalTable(tableName);
            this.checkForForeignKeys(table, tabs[i], tables);
            if (tables.get(tableName) == null) {
                if (xPathPrefix != null) {
                    String currentXPath = tabs[i].getOutputXPath();
                    if (currentXPath.charAt(0) != '/') {
                        tabs[i].setOutputXPath(String.valueOf(xPathPrefix) + "/" + currentXPath);
                    } else {
                        tabs[i].setOutputXPath(String.valueOf(xPathPrefix) + currentXPath);
                    }
                }
                tabs[i].setName(NameUtil.normalizeNameForRelationalTable(tabs[i].getName()));
                tabs[i].setCatalog(table.getCatalog());
                tabs[i].setSchema(table.getSchema());
                TableBuilder.mergeNamespacePrefixes(table, baseTable);
                tables.put(tableName, new SOAPTableImpl(tabs[i], isRequest, null, null));
                Column[] columns = tabs[i].getColumns();
                int col = 0;
                while (col < columns.length) {
                    Column column = columns[col];
                    column.setName(NameUtil.normalizeNameForRelationalTable(column.getName()));
                    ++col;
                }
                if (!isRequest) {
                    this.addResponseInColumn(tabs[i]);
                }
                this.processChildren(tabs[i], tables, isRequest, table, xPathPrefix);
            }
            ++i;
        }
    }

    private Table getRootTable(List tabList, String name) {
        Table tab = null;
        for (Table temp : tabList) {
            String tempName = temp.getName();
            if (tempName.indexOf(40) != -1) {
                tempName = tempName.substring(0, tempName.indexOf(40));
            }
            if (!tempName.equalsIgnoreCase(name)) continue;
            tab = temp;
            break;
        }
        return tab;
    }

    private void mergeTables(Table baseTable, Table toMerge, boolean isRequest) {
        TableBuilder.mergeNamespacePrefixes(baseTable, toMerge);
        String inputXpathPrepend = toMerge.getInputXPath();
        String outputXpathPrepend = toMerge.getOutputXPath();
        Column[] cols = toMerge.getColumns();
        if (isRequest && cols.length == 1) {
            ColumnImpl empty = new ColumnImpl();
            empty.setName(NameUtil.normalizeNameForRelationalTable(toMerge.getName()));
            empty.setIsInputParameter(true);
            empty.setIsRequiredValue(false);
            empty.setInputXPath(toMerge.getOutputXPath());
            empty.setDataType((DataType)new DataTypeImpl("string", XML_SCHEMA_URI));
            baseTable.addColumn((Column)empty);
        }
        int i = 0;
        while (i < cols.length) {
            Column source = cols[i];
            if (!source.getName().equals(MMID)) {
                Column candidate = this.copyColumn(inputXpathPrepend, outputXpathPrepend, source, isRequest);
                baseTable.addColumn(candidate);
            } else if (!isRequest) {
                this.addMMIdColumn(baseTable, outputXpathPrepend);
            }
            ++i;
        }
        baseTable.setElement(toMerge.getElement());
        baseTable.setBase(true);
    }

    public static void mergeNamespacePrefixes(Table toTable, Table fromTable) {
        Namespace[] ns = TableBuilder.extractNamespaces(fromTable.getNamespaceDeclaration());
        Namespace[] existing = TableBuilder.extractNamespaces(toTable.getNamespaceDeclaration());
        int i = 0;
        while (i < ns.length) {
            String nsUri = ns[i].getURI();
            String nsPrefix = ns[i].getPrefix();
            boolean already = false;
            int j = 0;
            while (j < existing.length) {
                if (existing[j].getURI().equals(nsUri) && existing[j].getPrefix().equals(nsPrefix)) {
                    already = true;
                    break;
                }
                ++j;
            }
            if (!already) {
                toTable.addNamespace(ns[i]);
            }
            ++i;
        }
    }

    private Column copyColumn(String inputXpathPrepend, String outputXpathPrepend, Column source, boolean isRequest) {
        ColumnImpl candidate = new ColumnImpl();
        candidate.setName(NameUtil.normalizeNameForRelationalTable(source.getName()));
        candidate.setDataType(source.getDataType());
        candidate.setMultipleValues(source.getMultipleValues());
        if (isRequest) {
            if (inputXpathPrepend.lastIndexOf(47) == inputXpathPrepend.length() - 1) {
                this.setInputColumnValues(String.valueOf(inputXpathPrepend) + source.getOutputXPath(), (Column)candidate);
            } else {
                this.setInputColumnValues(String.valueOf(inputXpathPrepend) + "/" + source.getOutputXPath(), (Column)candidate);
            }
        } else {
            candidate.setOutputXPath(String.valueOf(outputXpathPrepend) + "/" + source.getOutputXPath());
        }
        candidate.setRole(source.getRole());
        return candidate;
    }

    private void setInputColumnValues(String baseXpath, Column candidate) {
        if (baseXpath.startsWith("/")) {
            baseXpath = baseXpath.substring(1);
        }
        candidate.setIsInputParameter(true);
        if (baseXpath.indexOf(64) >= 0) {
            candidate.setIsAttributeOfParent(true);
            int atIndex = baseXpath.indexOf(64);
            String attrName = baseXpath.substring(atIndex + 1);
            String parentXpath = "/";
            if (atIndex > 0 && (parentXpath = baseXpath.substring(0, baseXpath.indexOf(64) - 1)).endsWith("/")) {
                parentXpath = parentXpath.substring(0, parentXpath.length() - 1);
            }
            candidate.setDataAttributeName(attrName);
            candidate.setInputXPath(parentXpath);
        } else {
            if (baseXpath.endsWith("/data()")) {
                baseXpath = baseXpath.substring(0, baseXpath.length() - "/data()".length());
            }
            if (baseXpath.endsWith("/text()")) {
                baseXpath = baseXpath.substring(0, baseXpath.length() - "/text()".length());
            }
            candidate.setInputXPath(baseXpath);
        }
        candidate.setIsRequiredValue(true);
    }

    private static Namespace[] extractNamespaces(String namespaceDeclaration) {
        String temp = namespaceDeclaration;
        String[] decls = temp.split("xmlns:");
        Namespace[] retVal = new Namespace[decls.length - 1];
        int i = 1;
        while (i < decls.length) {
            if (decls[i].startsWith("=")) {
                String suffix = decls[i].substring(2, decls[i].length() - 1);
                retVal[i - 1] = Namespace.getNamespace(null, (String)suffix);
            } else {
                String[] nsParts = decls[i].substring(1).split("=");
                String prefix = nsParts[0].trim();
                String suffix = nsParts[1].trim().substring(1, nsParts[1].trim().length() - 1);
                retVal[i - 1] = Namespace.getNamespace((String)prefix, (String)suffix);
            }
            ++i;
        }
        return retVal;
    }

    private ArrayList getMessages(Operation[] opers) {
        ArrayList<Message> messages = new ArrayList<Message>(opers.length);
        int i = 0;
        while (i < opers.length) {
            messages.add(opers[i].getInputMessage());
            messages.add(opers[i].getOutputMessage());
            ++i;
        }
        return messages;
    }

    private Table createBaseTable(Message msg) {
        String style;
        SOAPTableImpl table = new SOAPTableImpl();
        if (msg.isRequest() || msg.isResponse()) {
            table.setName(NameUtil.normalizeNameForRelationalTable(msg.getName()));
            table.setSchema(msg.getOperation().getName());
            table.setCatalog(msg.getOperation().getBinding().getPort().getService().getName());
        } else {
            table.setName(NameUtil.normalizeNameForRelationalTable(msg.getFault().getName()));
            table.setSchema(msg.getFault().getOperation().getName());
            table.setCatalog(msg.getFault().getOperation().getBinding().getPort().getService().getName());
        }
        String string = style = msg.getOperation() == null ? msg.getFault().getOperation().getBinding().getStyle() : msg.getOperation().getBinding().getStyle();
        if (style.equalsIgnoreCase("RPC")) {
            String ns = "";
            if (msg.getNamespaceURI() != null && !msg.getNamespaceURI().trim().equals("")) {
                ns = String.valueOf(this.findNamespacePrefix(msg.getNamespaceURI().trim())) + ":";
            }
            if (msg.isRequest()) {
                table.setInputXPath("/" + ns + table.getSchema());
                table.setOutputXPath("/");
            } else {
                table.setOutputXPath("/" + ns + table.getSchema() + "Response");
            }
        } else {
            table.setInputXPath("/");
            table.setOutputXPath("/");
        }
        for (String prefix : this.m_model.getNamespaces().keySet()) {
            String uri = this.m_model.getNamespaces().get(prefix);
            Namespace ns = Namespace.getNamespace((String)prefix, (String)uri);
            table.addNamespace(ns);
        }
        if (msg.isResponse() || msg.isFault()) {
            this.addResponseInColumn(table);
        } else {
            this.addResponseOutColumn(table);
        }
        return table;
    }

    private void addMMIdColumn(Table table, String prefix) {
        ColumnImpl col = new ColumnImpl();
        DataTypeImpl type = new DataTypeImpl("string", XML_SCHEMA_URI);
        col.setDataType((DataType)type);
        col.setName(MMID);
        col.setOutputXPath(String.valueOf(prefix) + "/@com.metamatrix.xml.xpathpart");
        col.setRole(XMLRequestResponseExtensionManagerImpl.DATA_ROLE);
        table.addColumn((Column)col);
    }

    private void addResponseOutColumn(Table table) {
        ColumnImpl col = new ColumnImpl();
        DataTypeImpl type = new DataTypeImpl("string", XML_SCHEMA_URI);
        col.setDataType((DataType)type);
        col.setName(RESPONSE_OUT);
        col.setRole(XMLRequestResponseExtensionManagerImpl.RESPONSE_OUT_ROLE);
        table.addColumn((Column)col);
    }

    private void addResponseInColumn(Table table) {
        ColumnImpl col = new ColumnImpl();
        DataTypeImpl type = new DataTypeImpl("string", XML_SCHEMA_URI);
        col.setDataType((DataType)type);
        col.setName(RESPONSE_IN);
        col.setRole(XMLRequestResponseExtensionManagerImpl.RESPONSE_IN_ROLE);
        col.setIsInputParameter(true);
        table.addColumn((Column)col);
    }

    private Column createColumn(Part part) {
        String name = part.getElementName() == null ? part.getName() : part.getElementName();
        ColumnImpl col = new ColumnImpl();
        col.setName(NameUtil.normalizeNameForRelationalTable(name));
        if (part.getElementNamespace() != null) {
            this.m_model.addNamespaceToMap(part.getElementNamespace());
        }
        if (part.getMessage().isRequest()) {
            col.setIsInputParameter(true);
            col.setInputXPath(name);
        } else {
            col.setOutputXPath(String.valueOf(name) + "/text()");
        }
        if (part.getTypeName() != null) {
            col.setDataType((DataType)new DataTypeImpl(part.getTypeName(), part.getTypeNamespace()));
        } else {
            col.setDataType((DataType)new DataTypeImpl(part.getElementName(), part.getElementNamespace()));
        }
        return col;
    }

    public String findNamespacePrefix(String namespaceURI) {
        String prefix = null;
        for (String key : this.m_model.getNamespaces().keySet()) {
            if (!this.m_model.getNamespaces().get(key).equals(namespaceURI)) continue;
            prefix = key;
        }
        if (prefix == null) {
            this.m_model.addNamespaceToMap(namespaceURI);
            prefix = this.findNamespacePrefix(namespaceURI);
        }
        return prefix;
    }

    private void checkForForeignKeys(Table parent, Table child, HashMap tables) {
        switch (child.getRelationToParent()) {
            case 4: {
                String childColumnName = String.valueOf(parent.getName()) + "_" + MMID;
                ColumnImpl keyColumn = new ColumnImpl();
                keyColumn.setName(childColumnName);
                keyColumn.setDataType((DataType)new DataTypeImpl("string", XML_SCHEMA_URI));
                keyColumn.setRole(XMLRequestResponseExtensionManagerImpl.DATA_ROLE);
                keyColumn.setOutputXPath(this.getChildKeyColumnXPath(parent, child));
                keyColumn.setIsForeignKey(true);
                child.addColumn((Column)keyColumn);
                break;
            }
            case 0: {
                String parentColumnName = String.valueOf(child.getName()) + "_" + MMID;
                String parentOutputXPath = "";
                ColumnImpl parentKeyColumn = new ColumnImpl();
                parentKeyColumn.setName(parentColumnName);
                parentKeyColumn.setDataType((DataType)new DataTypeImpl("string", XML_SCHEMA_URI));
                parentKeyColumn.setRole(XMLRequestResponseExtensionManagerImpl.DATA_ROLE);
                parentKeyColumn.setOutputXPath(parentOutputXPath);
                parentKeyColumn.setIsForeignKey(true);
                parent.addColumn((Column)parentKeyColumn);
                break;
            }
            case 5: {
                if (tables.containsKey(String.valueOf(parent.getName()) + "_" + child.getName())) break;
                SOAPTableImpl relTable = new SOAPTableImpl();
                relTable.setCatalog(parent.getCatalog());
                relTable.setSchema(parent.getSchema());
                relTable.setName(String.valueOf(parent.getName()) + "_" + child.getName());
                relTable.setOutputXPath("/");
                String relParentColumnName = String.valueOf(parent.getName()) + "_" + MMID;
                String relParentOutputXPath = String.valueOf(parent.getOutputXPath()) + "/@com.metamatrix.xml.xpathpart";
                ColumnImpl relParentKeyColumn = new ColumnImpl();
                relParentKeyColumn.setName(relParentColumnName);
                relParentKeyColumn.setDataType((DataType)new DataTypeImpl("string", XML_SCHEMA_URI));
                relParentKeyColumn.setRole(XMLRequestResponseExtensionManagerImpl.DATA_ROLE);
                relParentKeyColumn.setOutputXPath(relParentOutputXPath);
                relParentKeyColumn.setIsForeignKey(true);
                relTable.addColumn((Column)relParentKeyColumn);
                String relChildColumnName = String.valueOf(child.getName()) + "_" + MMID;
                String relChildOutputXPath = String.valueOf(child.getOutputXPath()) + "/@com.metamatrix.xml.xpathpart";
                ColumnImpl relChildKeyColumn = new ColumnImpl();
                relChildKeyColumn.setName(relChildColumnName);
                relChildKeyColumn.setDataType((DataType)new DataTypeImpl("string", XML_SCHEMA_URI));
                relChildKeyColumn.setRole(XMLRequestResponseExtensionManagerImpl.DATA_ROLE);
                relChildKeyColumn.setOutputXPath(relChildOutputXPath);
                relChildKeyColumn.setIsForeignKey(true);
                relTable.addColumn((Column)relChildKeyColumn);
                tables.put(relTable.getName(), new SOAPTableImpl(relTable, false, null, null));
            }
        }
    }

    private String getChildKeyColumnXPath(Table parent, Table child) {
        Relationship relationship = ((TableImpl)child).getRelationObjectToParent(parent);
        StringBuffer result = new StringBuffer();
        result.append(relationship.getParentRelativeXpath());
        result.append("/@com.metamatrix.xml.xpathpart");
        return result.toString();
    }
}

